/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.action;

import com.simsilica.action.ActionContext;
import com.simsilica.action.ObjectTypeRegistry;
import com.simsilica.action.Option;
import com.simsilica.action.PromptProvider;
import com.simsilica.action.PromptType;
import java.util.LinkedList;
import java.util.List;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionEnvironment<A, T>
implements PromptProvider<A, T> {
    static Logger log = LoggerFactory.getLogger(ActionEnvironment.class);
    private static ThreadLocal<LinkedList<ActionEnvironment>> envStack = new ThreadLocal<LinkedList<ActionEnvironment>>(){

        @Override
        protected LinkedList<ActionEnvironment> initialValue() {
            return new LinkedList<ActionEnvironment>();
        }
    };
    private ObjectTypeRegistry<A, T> types;
    private A activator;
    private PromptProvider<A, T> promptProvider;
    private Bindings variables;

    public ActionEnvironment(ObjectTypeRegistry<A, T> types, A activator) {
        this(types, activator, new SimpleBindings());
    }

    public ActionEnvironment(ObjectTypeRegistry<A, T> types, A activator, Bindings variables) {
        this.types = types;
        this.activator = activator;
        this.variables = variables;
        this.resetDefaultProvider();
    }

    public static <A, T> ActionEnvironment<A, T> getCurrentEnvironment() {
        return ActionEnvironment.getCurrentEnvironment(true);
    }

    public static <A, T> ActionEnvironment<A, T> getCurrentEnvironment(boolean failOnMiss) {
        LinkedList<ActionEnvironment> stack = envStack.get();
        if (stack.isEmpty()) {
            if (failOnMiss) {
                throw new IllegalStateException("An action environment is not in scope.");
            }
            return null;
        }
        return stack.getFirst();
    }

    public static <A, T> void pushCurrentEnvironment(ActionEnvironment<A, T> actionEnv) {
        envStack.get().push(actionEnv);
    }

    public static <A, T> void popCurrentEnvironment(ActionEnvironment<A, T> actionEnv) {
        ActionEnvironment check = envStack.get().pop();
        assert (check == actionEnv) : "Env stack consistency error";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAction(T targetObject, String actionName, Object ... parms) {
        envStack.get().push(this);
        try {
            ActionContext<A, T> context = this.types.getContext(targetObject);
            context.run(this, actionName, parms);
        }
        finally {
            ActionEnvironment check = envStack.get().pop();
            assert (check == this) : "Env stack consistency error";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActionIfExists(T targetObject, String actionName, Object ... parms) {
        envStack.get().push(this);
        try {
            ActionContext<A, T> context = this.types.getContext(targetObject);
            context.runIfExists(this, actionName, parms);
        }
        finally {
            ActionEnvironment check = envStack.get().pop();
            assert (check == this) : "Env stack consistency error";
        }
    }

    @Override
    public void showPrompt(T target, PromptType type, String prompt) {
        if (this.promptProvider == null) {
            throw new IllegalStateException("No prompt provider has been specified");
        }
        this.promptProvider.showPrompt(target, type, prompt);
    }

    @Override
    public final void showOptions(T target, List<Option<T>> options) {
        if (this.promptProvider == null) {
            throw new IllegalStateException("No prompt provider has been specified");
        }
        this.promptProvider.showOptions(target, options);
    }

    @Override
    public void showOptions(T target, List<Option<T>> options, Option<T> closeOption) {
        if (this.promptProvider == null) {
            throw new IllegalStateException("No prompt provider has been specified");
        }
        this.promptProvider.showOptions(target, options, closeOption);
    }

    public A getActivator() {
        return this.activator;
    }

    public ObjectTypeRegistry<A, T> getTypes() {
        return this.types;
    }

    public void setPromptProvider(PromptProvider<A, T> promptProvider) {
        this.promptProvider = promptProvider;
        if (promptProvider == null) {
            this.resetDefaultProvider();
        }
    }

    public PromptProvider<A, T> getPromptProvider() {
        return this.promptProvider;
    }

    public Bindings getVariables() {
        return this.variables;
    }

    public <T> T getVar(String key, T defaultValue) {
        Object result = this.variables.get(key);
        return (T)(result == null ? defaultValue : result);
    }

    public void setVar(String key, Object value) {
        if (value == null) {
            this.variables.remove(key);
        } else {
            this.variables.put(key, value);
        }
    }

    protected final void resetDefaultProvider() {
        if (this.activator instanceof PromptProvider) {
            this.promptProvider = (PromptProvider)this.activator;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[activator:" + this.activator + "]";
    }
}

