/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolSystem
extends AbstractGameSystem
implements Executor {
    static Logger log = LoggerFactory.getLogger(ThreadPoolSystem.class);
    private ThreadPoolExecutor pool;
    private boolean stopped = false;

    public ThreadPoolSystem(String name, int poolSize, int maxQueueSize) {
        log.info("Initializing thread pool");
        this.pool = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(maxQueueSize));
        this.pool.setThreadFactory(new ThreadFactoryBuilder().setNameFormat(name + "-%d").build());
    }

    @Override
    public void execute(Runnable command) {
        if (this.stopped) {
            this.shutdownPool();
            log.info("Stopped, running background runnable directly:" + command);
            command.run();
        } else {
            this.pool.execute(command);
        }
    }

    protected void initialize() {
    }

    protected void terminate() {
    }

    protected void shutdownPool() {
        if (this.pool.isShutdown()) {
            return;
        }
        long pending = this.pool.getTaskCount() - this.pool.getCompletedTaskCount();
        log.info("Shutting down thread pool, approx. pending count:" + pending);
        this.pool.shutdown();
        try {
            log.info("Awaiting termination...");
            if (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
                log.info("Failed to execute all pending tasks before continuing.");
            }
            log.info("All tasks finished.");
        }
        catch (InterruptedException e) {
            log.error("Interrupted while waiting for pool tasks", (Throwable)e);
        }
    }

    public void start() {
    }

    public void update(SimTime time) {
    }

    public void stop() {
        this.shutdownPool();
        this.stopped = true;
    }
}

