/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world.cave;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import mythruna.world.cave.CaveNode;
import mythruna.world.cave.Influencer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaveEdge
implements Serializable {
    static Logger log = LoggerFactory.getLogger(CaveEdge.class);
    private static final long serialVersionUID = 42L;
    private CaveNode end1;
    private CaveNode end2;
    private double radius;
    private Influencer[] influencers;

    public CaveEdge(CaveNode end1, CaveNode end2, double radius) {
        this.end1 = end1;
        this.end2 = end2;
        this.radius = radius;
    }

    public CaveNode getEnd1() {
        return this.end1;
    }

    public CaveNode getEnd2() {
        return this.end2;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setInfluencers(Influencer ... influencers) {
        this.influencers = influencers;
    }

    public Influencer[] getInfluencers() {
        return this.influencers;
    }

    public CaveNode adjacent(CaveNode node) {
        if (Objects.equals(this.end1, node)) {
            return this.end2;
        }
        if (Objects.equals(this.end2, node)) {
            return this.end1;
        }
        throw new IllegalArgumentException("Node is not a part of this edge:" + node);
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("end1", (Object)this.end1).add("end2", (Object)this.end2).add("radius", this.radius).add("influencers", this.influencers == null ? "null" : Arrays.asList(this.influencers)).toString();
    }
}

