/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public class BorderLayout
extends AbstractGuiComponent
implements GuiLayout,
Cloneable {
    private GuiControl parent;
    private Map<Position, Node> children = new EnumMap<Position, Node>(Position.class);
    private Vector3f lastPreferredSize = new Vector3f();

    @Override
    public BorderLayout clone() {
        BorderLayout result = new BorderLayout();
        return result;
    }

    @Override
    protected void invalidate() {
        if (this.parent != null) {
            this.parent.invalidate();
        }
    }

    protected Vector3f getPreferredSize(Position pos) {
        Node child = this.children.get((Object)pos);
        if (child == null) {
            return Vector3f.ZERO;
        }
        return ((GuiControl)child.getControl(GuiControl.class)).getPreferredSize();
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        Vector3f pref = this.getPreferredSize(Position.Center);
        size.addLocal(pref);
        pref = this.getPreferredSize(Position.North);
        size.y += pref.y;
        size.x = Math.max(size.x, pref.x);
        pref = this.getPreferredSize(Position.South);
        size.y += pref.y;
        size.x = Math.max(size.x, pref.x);
        pref = this.getPreferredSize(Position.East);
        size.y = Math.max(size.y, pref.y);
        size.x += pref.x;
        pref = this.getPreferredSize(Position.West);
        size.y = Math.max(size.y, pref.y);
        size.x += pref.x;
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        Vector3f pref;
        this.calculatePreferredSize(new Vector3f());
        Node child = this.children.get((Object)Position.North);
        if (child != null) {
            pref = this.getPreferredSize(Position.North);
            child.setLocalTranslation(pos);
            pos.y -= pref.y;
            size.y -= pref.y;
            ((GuiControl)child.getControl(GuiControl.class)).setSize(new Vector3f(size.x, pref.y, size.z));
        }
        if ((child = this.children.get((Object)Position.South)) != null) {
            pref = this.getPreferredSize(Position.South);
            child.setLocalTranslation(pos.x, pos.y - size.y + pref.y, pos.z);
            size.y -= pref.y;
            ((GuiControl)child.getControl(GuiControl.class)).setSize(new Vector3f(size.x, pref.y, size.z));
        }
        if ((child = this.children.get((Object)Position.West)) != null) {
            pref = this.getPreferredSize(Position.West);
            child.setLocalTranslation(pos);
            pos.x += pref.x;
            size.x -= pref.x;
            ((GuiControl)child.getControl(GuiControl.class)).setSize(new Vector3f(pref.x, size.y, size.z));
        }
        if ((child = this.children.get((Object)Position.East)) != null) {
            pref = this.getPreferredSize(Position.East);
            child.setLocalTranslation(pos.x + size.x - pref.x, pos.y, pos.z);
            size.x -= pref.x;
            ((GuiControl)child.getControl(GuiControl.class)).setSize(new Vector3f(pref.x, size.y, size.z));
        }
        if ((child = this.children.get((Object)Position.Center)) != null) {
            child.setLocalTranslation(pos);
            ((GuiControl)child.getControl(GuiControl.class)).setSize(size);
        }
    }

    public <T extends Node> T addChild(Position pos, T n) {
        if (n.getControl(GuiControl.class) == null) {
            throw new IllegalArgumentException("Child is not GUI element:" + n);
        }
        Node existing = this.children.remove((Object)pos);
        if (existing != null && this.parent != null) {
            this.parent.getNode().detachChild((Spatial)existing);
        }
        this.children.put(pos, n);
        if (this.parent != null) {
            this.parent.getNode().attachChild(n);
        }
        this.invalidate();
        return n;
    }

    @Override
    public <T extends Node> T addChild(T n, Object ... constraints) {
        Position p = Position.Center;
        for (Object o : constraints) {
            if (!(o instanceof Position)) {
                throw new IllegalArgumentException("Unknown border layout constraint:" + o);
            }
            p = (Position)((Object)o);
        }
        this.addChild(p, n);
        return n;
    }

    @Override
    public void removeChild(Node n) {
        if (!this.children.values().remove(n)) {
            throw new RuntimeException("Node is not a child of this layout:" + n);
        }
        if (this.parent != null) {
            this.parent.getNode().detachChild((Spatial)n);
        }
        this.invalidate();
    }

    @Override
    public Collection<Node> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    @Override
    public void clearChildren() {
        if (this.parent != null) {
            ArrayList<Node> copy = new ArrayList<Node>(this.children.values());
            for (Node n : copy) {
                this.parent.getNode().detachChild((Spatial)n);
            }
        }
        this.children.clear();
        this.invalidate();
    }

    @Override
    public void attach(GuiControl parent) {
        this.parent = parent;
        Node self = parent.getNode();
        for (Node child : this.children.values()) {
            self.attachChild((Spatial)child);
        }
    }

    @Override
    public void detach(GuiControl parent) {
        this.parent = null;
        ArrayList<Node> copy = new ArrayList<Node>(this.children.values());
        for (Node n : copy) {
            n.removeFromParent();
        }
    }

    public static enum Position {
        North,
        South,
        East,
        West,
        Center;

    }
}

