/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input;

import com.jme3.app.Application;
import com.jme3.input.Input;
import com.jme3.input.RawInputListener;
import com.jme3.system.AWTContext;
import com.jme3.system.AWTTaskExecutor;
import java.awt.Component;
import java.util.Objects;

public class AWTInput
implements Input {
    protected static final AWTTaskExecutor EXECUTOR = AWTTaskExecutor.getInstance();
    protected final AWTContext context;
    protected RawInputListener listener;
    protected Component component;
    protected Application application;
    protected boolean initialized;

    public AWTInput(AWTContext context) {
        this.context = context;
    }

    public void bind(Component component) {
        this.component = component;
        Objects.requireNonNull(this.component, "binded Component cannot be null");
    }

    public void unbind() {
        this.component = null;
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.initializeImpl();
        this.initialized = true;
    }

    protected void initializeImpl() {
    }

    public void update() {
        if (!this.context.isRenderable()) {
            return;
        }
        this.updateImpl();
    }

    protected void updateImpl() {
    }

    public void destroy() {
        this.unbind();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInputListener(RawInputListener listener) {
        this.listener = listener;
    }

    public long getInputTimeNanos() {
        return System.nanoTime();
    }
}

