/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.tile.pc;

import com.google.common.base.MoreObjects;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.DataVersion;
import com.simsilica.mworld.TileId;
import com.simsilica.mworld.tile.Resolution;
import com.simsilica.mworld.tile.pc.PointCloudData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PointCloudLayer {
    static Logger log = LoggerFactory.getLogger(PointCloudLayer.class);
    private static int COLUMN_SIZE = 32;
    private TileId tileId;
    private Resolution resolution;
    private DataVersion version;
    private Map<Short, PointCloudData> index = new HashMap<Short, PointCloudData>();

    public PointCloudLayer(TileId tileId, DataVersion version, Resolution resolution) {
        this.tileId = tileId;
        this.version = version;
        this.resolution = resolution;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public TileId getTileId() {
        return this.tileId;
    }

    public DataVersion getVersion() {
        return this.version;
    }

    public void updatePointCloud(PointCloudData cloud) {
        short indexId = ColumnId.toTileLocalIndexId(cloud.getOriginX() / 32, cloud.getOriginZ() / 32);
        this.index.put(indexId, cloud);
    }

    public PointCloudData getPointCloud(ColumnId id) {
        TileId tileId = id.getTileId();
        if (!Objects.equals(tileId, this.getTileId())) {
            throw new IllegalArgumentException("Column is not in this tile:" + id + ", tile:" + this.getTileId());
        }
        short localId = id.getTileLocalIndexId();
        return this.index.get(localId);
    }

    public Collection<PointCloudData> getPointClouds() {
        return this.index.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).add("tileId", (Object)this.tileId).add("resolution", (Object)this.resolution).add("version", (Object)this.version).toString();
    }
}

