/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.HAlignment;
import com.simsilica.lemur.Insets3f;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import com.simsilica.lemur.VAlignment;
import com.simsilica.lemur.component.BorderLayout;
import com.simsilica.lemur.component.IconComponent;
import com.simsilica.lemur.component.QuadBackgroundComponent;
import com.simsilica.lemur.core.GuiComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedHolder;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.progress.view.TrackerView;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import mythruna.client.GuiState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(ProgressState.class);
    private Container progressWindow;
    private Label splashLabel;
    private TrackerView trackerView;
    private VersionedHolder<String> splash;
    private VersionedReference<String> splashRef;
    private ColorRGBA background = new ColorRGBA(0.0f, 0.0f, 0.0f, 0.5f);
    private Thread renderThread;
    private Set<Object> requesters = new HashSet<Object>();

    public ProgressState() {
        this.setEnabled(false);
    }

    public void openView(Object requester) {
        this.openView(requester, null);
    }

    public void openView(Object requester, String text) {
        this.runOnRender(() -> {
            this.requesters.add(requester);
            this.setText(text);
            this.setEnabled(true);
        });
    }

    public void releaseView(Object requester) {
        this.runOnRender(() -> {
            this.requesters.remove(requester);
            this.setEnabled(!this.requesters.isEmpty());
        });
    }

    public void setText(String text) {
        this.runOnRender(() -> this.trackerView.setDefaultText(text));
    }

    public void setSplash(String splash) {
        this.runOnRender(() -> this.splash.updateObject((Object)splash));
    }

    public boolean isRenderThread() {
        return Thread.currentThread() == this.renderThread;
    }

    protected void runOnRender(Runnable r) {
        if (this.isRenderThread()) {
            r.run();
        } else {
            this.getApplication().enqueue(r);
        }
    }

    public void setMainThreadFilter(Predicate<Thread> filter) {
        this.trackerView.setMainThreadFilter(filter);
    }

    protected void initialize(Application app) {
        this.renderThread = Thread.currentThread();
        this.splash = new VersionedHolder(null);
        this.splashRef = this.splash.createReference();
        this.progressWindow = new Container((GuiLayout)new BorderLayout(), new ElementId("popup"));
        this.progressWindow.setLocalScale(1.5f);
        this.splashLabel = new Label("");
        this.splashLabel.setFontSize(1.0f);
        this.splashLabel.setText(null);
        this.splashLabel.setInsets(new Insets3f(5.0f, 5.0f, -5.0f, 5.0f));
        this.splashLabel.setBackground((GuiComponent)new QuadBackgroundComponent(ColorRGBA.Red));
        this.trackerView = (TrackerView)this.progressWindow.addChild((Node)new TrackerView(), new Object[]{BorderLayout.Position.South});
        this.trackerView.setExpandOnly(false);
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.progressWindow);
        GuiGlobals.getInstance().getPopupState().showModalPopup((Spatial)this.progressWindow, this.background);
    }

    protected void onDisable() {
        GuiGlobals.getInstance().getPopupState().closePopup((Spatial)this.progressWindow);
    }

    public void update(float tpf) {
        if (this.splashRef.update()) {
            String s = (String)this.splash.getObject();
            if (s == null) {
                this.splashLabel.setIcon(null);
                this.progressWindow.removeChild((Node)this.splashLabel);
            } else {
                IconComponent icon = new IconComponent(s);
                icon.setVAlignment(VAlignment.Center);
                icon.setHAlignment(HAlignment.Center);
                this.splashLabel.setIcon((GuiComponent)icon);
                this.progressWindow.addChild((Node)this.splashLabel, new Object[0]);
            }
        }
        ((GuiState)this.getState(GuiState.class)).center((Panel)this.progressWindow);
    }
}

