/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.WatchedEntity;
import com.simsilica.lemur.anim.Animation;
import com.simsilica.lemur.anim.AnimationState;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.TweenAnimation;
import com.simsilica.lemur.anim.Tweens;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.view.FarTerrainState;
import com.simsilica.mworld.view.FogSettings;
import com.simsilica.mworld.view.TerrainState;
import com.simsilica.state.MessageState;
import java.util.HashMap;
import java.util.Map;
import mythruna.client.GameSessionState;
import mythruna.client.PostProcessingState;
import mythruna.client.net.ConnectionState;
import mythruna.client.view.AvatarState;
import mythruna.client.view.EnvironmentState;
import mythruna.client.view.WorldViewState;
import mythruna.es.VisionEffect;
import mythruna.net.GameSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisionEffectState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(VisionEffectState.class);
    private EntityData ed;
    private AvatarState avatar;
    private PostProcessingState post;
    private AnimationState animation;
    private WorldViewState worldView;
    private TerrainState terrain;
    private FarTerrainState farTerrain;
    private GameSession session;
    private FogSettings fogSettings;
    private WatchedEntity self;
    private VisionEffect visionEffect;
    private Effect currentEffect;
    private Map<Integer, Effect> effectIndex = new HashMap<Integer, Effect>();

    protected void initialize(Application app) {
        this.ed = ((ConnectionState)this.getState(ConnectionState.class, true)).getEntityData();
        this.avatar = (AvatarState)this.getState(AvatarState.class, true);
        this.post = (PostProcessingState)this.getState(PostProcessingState.class, true);
        this.animation = (AnimationState)this.getState(AnimationState.class, true);
        this.worldView = (WorldViewState)this.getState(WorldViewState.class, true);
        this.terrain = (TerrainState)this.getState(TerrainState.class, true);
        this.farTerrain = (FarTerrainState)this.getState(FarTerrainState.class, true);
        this.session = ((GameSessionState)this.getState(GameSessionState.class, true)).getGameSession();
        EntityId avatarId = this.avatar.getAvatarId();
        this.self = this.ed.watchEntity(avatarId, new Class[]{VisionEffect.class});
        this.fogSettings = ((EnvironmentState)this.getState(EnvironmentState.class)).getFogSettings();
        this.effectIndex.put(1, new PortalBlindness());
        this.setVisionEffect((VisionEffect)this.self.get(VisionEffect.class));
    }

    protected void cleanup(Application app) {
    }

    protected void onEnable() {
    }

    protected void onDisable() {
    }

    protected void statusMessage(String msg) {
        log.info("statusMessage(" + msg + ")");
        ((MessageState)this.getState(MessageState.class)).addMessage(msg, ColorRGBA.Pink);
    }

    public void update(float tpf) {
        if (this.self.applyChanges()) {
            this.setVisionEffect((VisionEffect)this.self.get(VisionEffect.class));
        }
        if (this.currentEffect != null) {
            this.currentEffect.update(tpf);
        }
    }

    protected void setEffect(Effect effect) {
        log.info("setEffect(" + effect + ")");
        if (this.currentEffect != null) {
            if (effect != null) {
                this.currentEffect.abort();
            } else {
                this.currentEffect.stop();
            }
        }
        this.currentEffect = effect;
        if (this.currentEffect != null) {
            this.currentEffect.start();
        }
    }

    protected void setVisionEffect(VisionEffect visionEffect) {
        this.visionEffect = visionEffect;
        this.setEffect(this.getEffect(visionEffect));
    }

    protected Effect getEffect(VisionEffect visionEffect) {
        if (visionEffect == null) {
            return null;
        }
        Effect result = this.effectIndex.get(visionEffect.getIndex());
        if (result == null) {
            log.warn("No effect registered for:" + result);
        }
        return result;
    }

    protected class PortalBlindness
    implements Effect {
        private Vec3d startPos;
        private boolean moved;
        private float leadTime = 5.0f;
        private float checkTime = 1.0f;
        private double maxDist;
        private boolean checkWorld;
        private boolean checkTerrain;
        private boolean checkFar;
        private double currentDist;
        private double targetDist;
        private double deltaDist;
        private TweenAnimation shutdown;
        private int status = 0;

        @Override
        public void start() {
            if (this.shutdown != null && this.shutdown.isRunning()) {
                VisionEffectState.this.animation.cancel((Animation)this.shutdown);
            }
            this.shutdown = null;
            this.status = 0;
            this.startPos = VisionEffectState.this.avatar.getPosition();
            this.moved = false;
            this.leadTime = 3.0f;
            this.checkTime = 1.0f;
            this.checkWorld = true;
            this.checkTerrain = true;
            this.checkFar = true;
            this.currentDist = 0.0;
            this.targetDist = 0.0;
            this.deltaDist = 0.0;
            VisionEffectState.this.post.getPortalBlindness().setEnabled(true);
            VisionEffectState.this.post.getPortalBlindness().setFadeDistance(0.0f);
            VisionEffectState.this.post.getPortalBlindness().setFadeMinimum(0.3f);
            VisionEffectState.this.post.getPortalBlindness().setAlpha(1.0f);
            this.maxDist = VisionEffectState.this.fogSettings.getFogDistance();
        }

        protected void setAlpha(float alpha) {
            VisionEffectState.this.post.getPortalBlindness().setAlpha(1.0f - alpha);
            if ((double)alpha == 1.0) {
                VisionEffectState.this.post.getPortalBlindness().setEnabled(false);
            }
        }

        @Override
        public void stop() {
            this.shutdown = VisionEffectState.this.animation.add(new Tween[]{Tweens.callTweenMethod((double)2.0, (Object)this, (String)"setAlpha", (Object[])new Object[0])});
        }

        @Override
        public void abort() {
        }

        protected double getDist() {
            if (this.checkWorld && VisionEffectState.this.worldView.isEnabled()) {
                double max = VisionEffectState.this.worldView.getVisualRadius();
                double dist = VisionEffectState.this.worldView.getNearestBlankDistance();
                if (dist < max) {
                    return dist;
                }
                this.checkWorld = false;
                return max;
            }
            if (this.checkTerrain && VisionEffectState.this.terrain.isEnabled()) {
                double max = VisionEffectState.this.terrain.getVisualRadius();
                double dist = VisionEffectState.this.terrain.getNearestBlankDistance();
                if (dist < max) {
                    return dist;
                }
                this.checkTerrain = false;
                return max;
            }
            if (this.checkFar && VisionEffectState.this.farTerrain.isEnabled()) {
                double max = VisionEffectState.this.farTerrain.getVisualRadius();
                double dist = VisionEffectState.this.farTerrain.getNearestBlankDistance();
                if (dist < max) {
                    return dist;
                }
                this.checkFar = false;
                return max;
            }
            return Double.POSITIVE_INFINITY;
        }

        protected void check() {
            double dist = this.getDist();
            double newTarget = Math.max(this.targetDist, Math.min(this.maxDist, dist));
            if (this.targetDist == newTarget) {
                return;
            }
            this.targetDist = newTarget;
            this.deltaDist = Math.max(0.25, (this.targetDist - this.currentDist) / 120.0);
        }

        @Override
        public void update(float tpf) {
            this.leadTime -= tpf;
            if (!this.moved && this.leadTime > -20.0f) {
                Vec3d pos = VisionEffectState.this.avatar.getPosition();
                log.info("startPos:" + this.startPos + " pos:" + pos);
                if (pos.distanceSq(this.startPos) > 256.0) {
                    this.moved = true;
                }
            }
            if (this.leadTime > 0.0f) {
                return;
            }
            this.checkTime -= tpf;
            if (this.checkTime < 0.0f) {
                this.checkTime = 1.0f;
                this.check();
            }
            if (this.status == 0 && this.currentDist > 4.0) {
                VisionEffectState.this.statusMessage("You are experiencing portal blindness...");
                this.status = 1;
            } else if (this.status == 1 && this.currentDist > 1024.0) {
                VisionEffectState.this.statusMessage("...it will clear in a moment.");
                this.status = 2;
                VisionEffectState.this.post.getPortalBlindness().setFadeMinimum(0.2f);
            }
            if (!VisionEffectState.this.post.getPortalBlindness().isEnabled()) {
                log.warn("Active portal blindness effect finds portal blindness turned off.");
            }
            if (this.currentDist < this.targetDist) {
                this.currentDist = Math.min(this.targetDist, this.currentDist + this.deltaDist);
                VisionEffectState.this.post.getPortalBlindness().setFadeDistance((float)this.currentDist);
                if (this.currentDist >= this.maxDist) {
                    log.info("Clearing portal blindness...");
                    VisionEffectState.this.session.runAction(VisionEffectState.this.self.getId(), "clearPortalBlindness", new Object[0]);
                }
            }
        }
    }

    protected static interface Effect {
        public void start();

        public void update(float var1);

        public void stop();

        public void abort();
    }
}

