/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.RigidBody;
import java.util.List;
import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Behavior;
import mythruna.sim.ai.Behaviors;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.FollowBehavior;
import mythruna.sim.ai.Mob;
import mythruna.sim.ai.PrimtiveFleeBehavior;
import mythruna.sim.ai.Reaction;
import mythruna.sim.ai.Signal;
import mythruna.sim.ai.SignalGenerators;
import mythruna.sim.ai.SteeringPrimitives;
import mythruna.sim.ai.TalkBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrainConfigurations {
    static Logger log = LoggerFactory.getLogger(BrainConfigurations.class);

    public static void configureButterfly(Brain target) {
        target.onSignal(Signal.IDLE, (brain, signal) -> {
            double roll = Math.random();
            if (roll < 0.35) {
                double idleTime = 1.0 + Math.random() * 3.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0)), idleTime)).debugName("Idle:" + idleTime);
            }
            double idleTime = 2.0 + Math.random() * 3.0;
            return new Reaction(Behaviors.limited(Behaviors.fly(Behaviors.constant("Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.25))), idleTime)).debugName("Wander:" + idleTime);
        });
    }

    public static void configureDog(Brain target) {
        target.onSignal("Talk", (brain, signal) -> {
            Mob mob = brain.getMob((EntityId)signal.getValue());
            if (mob != null) {
                return new Reaction(new TalkBehavior(mob, "Idle2", 20.0)).debugName("Talk:" + signal.getValue());
            }
            return null;
        });
        target.onSignal("TalkStop", (brain, signal) -> {
            Behavior currentBehavior = brain.getCurrentBehavior();
            if (currentBehavior instanceof TalkBehavior) {
                ((TalkBehavior)currentBehavior).removeConverser((EntityId)signal.getValue());
            }
            return null;
        });
        target.onSignal("Pet", (brain, signal) -> {
            Mob mob = brain.getMob((EntityId)signal.getValue());
            if (mob != null) {
                return new Reaction(Behaviors.limited(new FollowBehavior(mob, "Idle2"), 20.0)).debugName("Follow:" + signal.getValue());
            }
            return null;
        });
        target.onSignal("EnteredView", (brain, signal) -> {
            RigidBody body = (RigidBody)signal.getValue();
            if (brain.refreshShortTermMemory("friends", body.id, 30.0)) {
                return null;
            }
            Mob mob = brain.getMob((EntityId)body.id);
            if (mob == null) {
                return null;
            }
            return new Reaction(Behaviors.limited(Behaviors.doWhile(new FollowBehavior(mob, "Idle2"), b -> {
                double distSq = b.getAgent().getLocation().distanceSq(mob.getLocation());
                return distSq > 1.0;
            }).onDone(b -> {
                b.say("** Woof! **");
                b.addShortTermMemory("friends", body.id, 30.0);
            }), 20.0)).debugName("Meet:" + body.id);
        });
        target.onSignal(Signal.IDLE, (brain, signal) -> {
            Vec3d home = brain.getProperty("home", null);
            if (home == null) {
                double idleTime = Math.random() * 2.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0)), idleTime)).debugName("No home");
            }
            double roll = Math.random();
            if (roll < 0.5) {
                double idleTime = 1.0 + Math.random() * 2.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0)), idleTime)).debugName("Idle:" + idleTime);
            }
            if (roll < 0.75) {
                if (home.distanceSq(brain.getAgent().getLocation()) > 1.0) {
                    return new Reaction(Behaviors.limited(Behaviors.doWhile(Behaviors.constant("Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.arrive(brain.getAgent(), home, 0.5), 0.5)), b -> {
                        double distSq = b.getAgent().getLocation().distanceSq(home);
                        return distSq > 1.0;
                    }), 10.0)).debugName("Go home");
                }
            } else {
                double idleTime = 2.0 + Math.random() * 2.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.5)), idleTime)).debugName("Wander:" + idleTime);
            }
            return null;
        });
    }

    public static void configureNpc(Brain target) {
        target.onSignal("Talk", (brain, signal) -> {
            Mob mob = brain.getMob((EntityId)signal.getValue());
            if (mob != null) {
                return new Reaction(new TalkBehavior(mob, "Idle", 20.0)).debugName("Talk:" + signal.getValue());
            }
            return null;
        });
        target.onSignal("TalkStop", (brain, signal) -> {
            Behavior currentBehavior = brain.getCurrentBehavior();
            if (currentBehavior instanceof TalkBehavior) {
                ((TalkBehavior)currentBehavior).removeConverser((EntityId)signal.getValue());
            }
            return null;
        });
        target.onSignal(Signal.IDLE, (brain, signal) -> {
            Vec3d home = brain.getProperty("home", null);
            if (home == null) {
                double idleTime = Math.random() * 2.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0)), idleTime)).debugName("No home");
            }
            double roll = Math.random();
            if (roll < 0.5) {
                double idleTime = Math.random() * 2.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0)), idleTime)).debugName("Idle:" + idleTime);
            }
            if (roll < 0.75) {
                if (home.distanceSq(brain.getAgent().getLocation()) > 1.0) {
                    return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.arrive(brain.getAgent(), home, 0.5), 0.25)), 10.0)).debugName("Go home");
                }
            } else {
                double idleTime = 2.0 + Math.random() * 2.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.25)), idleTime)).debugName("Wander:" + idleTime);
            }
            return null;
        });
    }

    public static void configureGaefen(Brain target) {
        AbstractBehavior eat = new AbstractBehavior(){

            @Override
            protected void onStart(Brain brain) {
                brain.getAgent().setDefaultAction("Eat");
                brain.getAgent().setSteering(SteeringPrimitives.constant(0.0, 0.0, 0.0));
            }

            @Override
            public boolean update(long frameTime, double step) {
                double hunger = this.getBrain().adjustProperty("hunger", -step * 5.0);
                return hunger > 0.0;
            }
        };
        target.addSignalGenerator(SignalGenerators.interval(1.0, (brain, frame, step) -> {
            double hunger = brain.adjustProperty("hunger", step);
            if (hunger > 60.0) {
                brain.signal(new Signal("Hungry"));
            }
        }));
        target.addSignalGenerator(SignalGenerators.interval(5.0, (brain, frame, step) -> {
            List<RigidBody<EntityId, MBlockShape>> bodies = brain.getAgent().queryNearBodies();
            if (bodies.isEmpty()) {
                double lonely = brain.adjustProperty("lonely", step);
                if (lonely > 25.0) {
                    brain.signal(new Signal("Lonely"));
                }
            } else if (brain.getProperty("lonely", 0.0) > 0.0) {
                brain.setProperty("lonely", 0.0);
            }
        }));
        target.onSignal("Hungry", (brain, signal) -> new Reaction("Eating", eat));
        target.onSignal("Pet", (brain, signal) -> {
            Mob mob = brain.getMob((EntityId)signal.getValue());
            if (mob != null) {
                return new Reaction(Behaviors.limited(new FollowBehavior(mob, "Idle"), 20.0)).debugName("Follow:" + signal.getValue());
            }
            return null;
        });
        target.onSignal(Signal.IDLE, (brain, signal) -> {
            double hunger = brain.getProperty("hunger", 0.0);
            if (hunger > 10.0) {
                return new Reaction("Idle Eating", eat);
            }
            double roll = Math.random();
            if (roll < 0.75) {
                double idleTime = 2.0 + Math.random() * 4.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.25)), idleTime)).debugName(String.format("Idle:%.2f", idleTime));
            }
            double idleTime = 1.0 + Math.random() * 3.0;
            return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0)), idleTime)).debugName(String.format("Sit still:%.2f", idleTime));
        });
        target.onSignal("Lonely", (brain, signal) -> {
            Mob mob;
            List<RigidBody<EntityId, MBlockShape>> bodies = brain.getAgent().queryFarBodies();
            double minDistSq = Double.POSITIVE_INFINITY;
            RigidBody<EntityId, MBlockShape> closest = null;
            for (RigidBody<EntityId, MBlockShape> body : bodies) {
                double distSq = body.position.distanceSq(brain.getAgent().getLocation());
                if (!(distSq < minDistSq)) continue;
                closest = body;
                minDistSq = distSq;
            }
            if (closest != null && (mob = brain.getMob((EntityId)closest.id)) != null) {
                return new Reaction(Behaviors.limited(Behaviors.doWhile(new FollowBehavior(mob, "Idle"), b -> {
                    double lonely = b.getProperty("lonely", 0.0);
                    if (lonely == 0.0) {
                        return false;
                    }
                    return b.getAgent().isInFarRange(mob.getLocation());
                }), 20.0)).debugName("Flock to:" + closest.id);
            }
            return null;
        });
        target.onSignal("EnteredSpace", (brain, signal) -> {
            if (!(signal.getValue() instanceof RigidBody)) {
                return null;
            }
            RigidBody body = (RigidBody)signal.getValue();
            if (brain.isSameType((EntityId)body.id)) {
                brain.say("** Coo **");
                return null;
            }
            double speedSq = body.getLinearVelocity().lengthSq();
            if (speedSq > 4.0) {
                brain.say("** Squawk **");
                Mob mob = brain.getMob((EntityId)body.id);
                return new Reaction(new PrimtiveFleeBehavior(mob, "Idle", 4.0)).debugName("Fleeing:" + body.id);
            }
            return null;
        });
    }

    public static void configureBird(Brain target) {
        target.onSignal("Pet", (brain, signal) -> {
            Mob mob = brain.getMob((EntityId)signal.getValue());
            if (mob != null) {
                return new Reaction(Behaviors.limited(new FollowBehavior(mob, "Idle"), 20.0)).debugName("Follow:" + signal.getValue());
            }
            return null;
        });
        target.onSignal(Signal.IDLE, (brain, signal) -> {
            if (!brain.getAgent().isOnGround()) {
                double idleTime = 2.0 + Math.random() * 4.0;
                return new Reaction(Behaviors.fly(Behaviors.doWhile(Behaviors.limited(Behaviors.constant("Jog", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.5)), idleTime), b -> !b.getAgent().isOnGround()))).debugName(String.format("Land:%.2f", idleTime));
            }
            double roll = Math.random();
            if (roll < 0.5) {
                double idleTime = 2.0 + Math.random() * 4.0;
                return new Reaction(Behaviors.fly(Behaviors.limited(Behaviors.constant("Jog", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.5)), idleTime))).debugName(String.format("Fly-Idle:%.2f", idleTime));
            }
            if (roll < 0.75) {
                double idleTime = 2.0 + Math.random() * 4.0;
                return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.scaleSpeed(SteeringPrimitives.wander(4.0, 1.0, 0.5), 0.1)), idleTime)).debugName(String.format("Walk-Idle:%.2f", idleTime));
            }
            double idleTime = 1.0 + Math.random() * 3.0;
            return new Reaction(Behaviors.limited(Behaviors.constant("Idle", SteeringPrimitives.constant(0.0, 0.0, 0.0)), idleTime)).debugName(String.format("Sit still:%.2f", idleTime));
        });
        target.onSignal("EnteredSpace", (brain, signal) -> {
            if (!(signal.getValue() instanceof RigidBody)) {
                return null;
            }
            RigidBody body = (RigidBody)signal.getValue();
            if (brain.isSameType((EntityId)body.id)) {
                return null;
            }
            double speedSq = body.getLinearVelocity().lengthSq();
            if (speedSq > 4.0) {
                brain.say("** Tweet Tweet **");
                Mob mob = brain.getMob((EntityId)body.id);
                return new Reaction(Behaviors.fly(new PrimtiveFleeBehavior(mob, "Jog", 4.0))).debugName("Fleeing:" + body.id);
            }
            return null;
        });
    }
}

