/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.view.input;

import com.simsilica.es.EntityId;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Rayd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mworld.BlockIterator;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import mythruna.client.view.AvatarState;
import mythruna.client.view.input.ManipulatorType;
import mythruna.client.view.object.ModelViewState;
import mythruna.client.view.object.PickedObject;
import mythruna.net.GameSession;
import mythruna.sim.BlockHit;
import mythruna.sim.ObjectHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandManipulator
implements ManipulatorType {
    static Logger log = LoggerFactory.getLogger(HandManipulator.class);
    private GameSession session;
    private EntityId target;
    private AvatarState avatar;
    private ModelViewState models;
    private ObjectHit selected;
    private boolean dragging;
    private BlockHit lastHit;
    private WorldHit lastMainHit;
    private Consumer<String> defaultAction;
    private float toolTipTimeout = 1.0f;
    private int toolTipDistance = 3;
    private ToolTipTracker toolTipTracker = new ToolTipTracker();
    private Vec3d clickPos = new Vec3d();
    private Vec3d objectPos = new Vec3d();
    private Quatd objectFacing = new Quatd();

    public HandManipulator(GameSession session, AvatarState avatar, ModelViewState models, Consumer<String> defaultAction) {
        this.session = session;
        this.avatar = avatar;
        this.models = models;
        this.defaultAction = defaultAction;
    }

    @Override
    public void setTarget(EntityId target) {
        this.target = target;
    }

    public EntityId getTarget() {
        return this.target;
    }

    protected GameSession getSession() {
        return this.session;
    }

    @Override
    public void update(float tpf) {
        this.toolTipTracker.update(tpf);
    }

    protected void captureClick() {
        Vec3d pos = this.models.getModelPosition(this.selected.entityId);
        log.info("Clicked model position:" + pos);
        if (pos == null) {
            log.warn("Unabled to determine position of clicked model:" + this.selected);
            return;
        }
        Quatd orient = this.models.getModelRotation(this.selected.entityId);
        Vec3d avatarPos = this.avatar.getEyePosition();
        this.clickPos.set(this.selected.location).subtractLocal(avatarPos);
        this.objectPos.set(pos).subtractLocal(avatarPos);
        log.info("Raw relative click pos:" + this.clickPos + "  objectPos:" + this.objectPos);
        Quatd facing = this.avatar.getCameraFacing();
        log.info("dir:" + facing.mult(new Vec3d(0.0, 0.0, 1.0)));
        Quatd inverse = facing.inverse();
        inverse.mult(this.clickPos, this.clickPos);
        inverse.mult(this.objectPos, this.objectPos);
        this.objectFacing = inverse.mult(orient);
        log.info("Click pos:" + this.clickPos + "  objectPos:" + this.objectPos);
    }

    protected Object[] getDragArgs(Vec3d pos, Quatd facing) {
        Vec3d v1 = facing.mult(this.objectPos).addLocal(pos);
        Vec3d v2 = facing.mult(this.clickPos).addLocal(pos);
        Quatd q = facing.mult(this.objectFacing);
        return new Object[]{this.selected.entityId, v1, q, v2};
    }

    protected void startDragging(Vec3d pos, Quatd facing) {
        this.dragging = true;
        this.session.runAction(this.target, "dragStart", this.getDragArgs(pos, facing));
    }

    protected void drag(Vec3d pos, Quatd facing) {
        this.session.runAction(this.target, "drag", this.getDragArgs(pos, facing));
    }

    protected void stopDragging() {
        this.session.runAction(this.target, "dragEnd", new Object[]{this.selected.entityId});
        this.dragging = false;
        this.selected = null;
    }

    protected void runAction(String action, Object ... args) {
        this.session.runAction(this.target, action, args);
    }

    protected void altPressObject(ObjectHit object) {
        this.selected = object;
        this.captureClick();
    }

    protected void altClickObject(ObjectHit object) {
        this.session.runAction(this.target, "contextAction", new Object[]{object});
    }

    protected void altPressBlock(BlockHit hit) {
        this.session.runAction(this.target, "altPressBlock", new Object[]{hit});
    }

    protected void altClickBlock(BlockHit hit) {
        this.session.runAction(this.target, "altClickBlock", new Object[]{hit});
    }

    protected void mainPressObject(ObjectHit object) {
        this.session.runAction(this.target, "mainPressObject", new Object[]{object});
    }

    protected void mainClickObject(ObjectHit object) {
        this.session.runAction(this.target, "mainClickObject", new Object[]{object});
    }

    protected void mainPressBlock(BlockHit hit) {
        this.session.runAction(this.target, "mainPressBlock", new Object[]{hit});
    }

    protected void mainClickBlock(BlockHit hit) {
        this.session.runAction(this.target, "mainClickBlock", new Object[]{hit});
    }

    protected void mainPress() {
        this.session.runAction(this.target, "mainPress", new Object[0]);
    }

    protected void mainClick() {
        this.session.runAction(this.target, "mainClick", new Object[0]);
    }

    protected void altPress() {
        this.session.runAction(this.target, "altPress", new Object[0]);
    }

    protected void altClick() {
        this.session.runAction(this.target, "altClick", new Object[0]);
    }

    @Override
    public void viewChanged(Vec3d pos, Quatd facing) {
        if (this.selected != null) {
            if (this.dragging) {
                this.drag(pos, facing);
            } else {
                this.startDragging(pos, facing);
            }
            this.toolTipTracker.clear();
        } else {
            this.toolTipTracker.check();
        }
    }

    @Override
    public void activate(boolean pressed) {
        this.toolTipTracker.clear();
        if (pressed) {
            this.lastMainHit = this.pickWorld(10);
            if (this.lastMainHit.object != null) {
                log.info("object hit:" + this.lastMainHit.object);
                this.mainPressObject(this.lastMainHit.object);
            } else if (this.lastMainHit.blockHit != null) {
                log.info("block hit:" + this.lastMainHit.blockHit);
                this.mainPressBlock(this.lastMainHit.blockHit);
            } else {
                this.lastMainHit = null;
                this.mainPress();
            }
        } else if (this.lastMainHit != null) {
            if (this.lastMainHit.object != null) {
                this.mainClickObject(this.lastMainHit.object);
            } else if (this.lastMainHit.blockHit != null) {
                this.mainClickBlock(this.lastMainHit.blockHit);
            }
            this.lastMainHit = null;
        } else {
            this.mainClick();
        }
    }

    @Override
    public void altActivate(boolean pressed) {
        this.toolTipTracker.clear();
        if (pressed) {
            WorldHit hit = this.pickWorld(10);
            this.lastHit = hit.blockHit;
            if (hit.object != null) {
                this.altPressObject(hit.object);
            } else if (this.lastHit != null) {
                this.altPressBlock(this.lastHit);
            } else {
                this.lastHit = null;
                this.altPress();
            }
        } else {
            if (this.selected != null) {
                if (this.dragging) {
                    log.info("Stop dragging");
                    this.stopDragging();
                } else {
                    this.altClickObject(this.selected);
                }
            } else if (this.lastHit != null) {
                if (!this.dragging) {
                    this.altClickBlock(this.lastHit);
                }
            } else {
                this.altClick();
            }
            this.selected = null;
            this.lastHit = null;
        }
    }

    @Override
    public void change(int delta) {
        if (!this.dragging || this.selected == null) {
            this.session.runAction(this.target, "rotate", new Object[]{delta});
            return;
        }
        Vec3d avatarPos = this.avatar.getEyePosition();
        Quatd facing = this.avatar.getCameraFacing();
        this.objectFacing = this.objectFacing.mult(new Quatd().fromAngles(0.0, (double)delta * (Math.PI / 180), 0.0));
        this.session.runAction(this.target, "drag", this.getDragArgs(avatarPos, facing));
    }

    protected WorldHit pickWorld(int distance) {
        Rayd view = this.avatar.getViewRay();
        WorldHit result = new WorldHit();
        Vec3d place = null;
        Vec3d angle = null;
        Iterator<BlockIterator.Intersection> it = this.avatar.pick(view, distance);
        if (it.hasNext()) {
            BlockIterator.Intersection hit = it.next();
            if (log.isDebugEnabled()) {
                log.debug("hit:" + hit);
            }
            double blockDistance = Math.ceil(view.getOrigin().distance(hit.getPoint()));
            if (log.isDebugEnabled()) {
                log.debug("blockDistance:" + blockDistance + "  hit:" + hit.getType() + "  normal:" + hit.getNormal());
            }
            if (blockDistance <= (double)distance) {
                result.blockHit = new BlockHit(hit.getPoint(), hit.getBlock(), hit.getType(), hit.getCellValue(), hit.getNormal());
                place = hit.getPoint();
                angle = hit.getNormal();
                if (log.isDebugEnabled()) {
                    log.debug("origin:" + view.getOrigin());
                    log.debug("hit:" + place);
                    log.debug("distance:" + view.getOrigin().distance(place));
                }
                distance = (int)Math.max(1.0, blockDistance);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Need to check for object hits from:" + view + "  limit:" + distance);
        }
        PickedObject picked = this.models.pickObject(this.avatar.getAvatarId(), view.getOrigin(), view.getDirection(), distance);
        if (log.isDebugEnabled()) {
            log.debug("Found:" + picked);
        }
        result.object = picked != null ? new ObjectHit(picked.entityId, picked.location, picked.normal) : null;
        return result;
    }

    private class ToolTipTracker {
        float timeToCheck;
        Object lastTarget;

        private ToolTipTracker() {
        }

        public void clear() {
            if (this.lastTarget != null) {
                this.lastTarget = null;
                HandManipulator.this.defaultAction.accept(null);
            }
            this.timeToCheck = HandManipulator.this.toolTipTimeout;
        }

        public void check() {
            if (this.timeToCheck > 0.0f) {
                return;
            }
            WorldHit newHit = HandManipulator.this.pickWorld(HandManipulator.this.toolTipDistance);
            if (newHit.object == null && newHit.blockHit == null) {
                this.clear();
                return;
            }
            EntityId newTarget = null;
            if (newHit.object != null) {
                newTarget = newHit.object.entityId;
            } else if (newHit.blockHit != null) {
                newTarget = newHit.blockHit.block;
            }
            if (Objects.equals(this.lastTarget, newTarget)) {
                return;
            }
            this.lastTarget = newTarget;
            if (newHit.object != null) {
                HandManipulator.this.session.runAction(HandManipulator.this.target, "showDefaultObjectAction", new Object[]{newHit.object});
            } else if (newHit.blockHit != null) {
                HandManipulator.this.session.runAction(HandManipulator.this.target, "showDefaultBlockAction", new Object[]{newHit.blockHit});
            }
        }

        public void update(float tpf) {
            if (this.timeToCheck > 0.0f) {
                this.timeToCheck -= tpf;
                if (this.timeToCheck < 0.0f) {
                    this.check();
                }
            }
        }
    }

    protected static class WorldHit {
        BlockHit blockHit;
        ObjectHit object;

        protected WorldHit() {
        }
    }
}

