/*
 * Decompiled with CFR 0.152.
 */
package mythruna.character;

import com.google.common.base.MoreObjects;
import com.simsilica.mblock.CellArray;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import mythruna.character.SimilarFabricIndex;
import mythruna.fabric.FabricType;
import mythruna.fabric.FabricTypeIndex;
import mythruna.fabric.FabricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClothingType
implements Cloneable {
    static Logger log = LoggerFactory.getLogger(ClothingType.class);
    private String clothing;
    private String name;
    private int shirtLayer;
    private int pantsLayer;
    private int feetLayer;
    private int miscLayer;
    private Set<String> races;
    private CellArray cells;
    private Set<String> fabrics;
    private String primaryFabric;

    public ClothingType clone() {
        try {
            return (ClothingType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("bad clone", e);
        }
    }

    public String getClothing() {
        return this.clothing;
    }

    public String getName() {
        return this.name;
    }

    public int getShirtLayer() {
        return this.shirtLayer;
    }

    public int getPantsLayer() {
        return this.pantsLayer;
    }

    public int getFeetLayer() {
        return this.feetLayer;
    }

    public int getMiscLayer() {
        return this.miscLayer;
    }

    public int getLayer() {
        if (this.shirtLayer >= 0) {
            return this.shirtLayer;
        }
        if (this.pantsLayer >= 0) {
            return this.pantsLayer;
        }
        if (this.feetLayer >= 0) {
            return this.feetLayer;
        }
        return this.miscLayer;
    }

    protected void setShirtLayer(String s) {
        this.shirtLayer = Integer.parseInt(s);
    }

    protected void setPantsLayer(String s) {
        this.pantsLayer = Integer.parseInt(s);
    }

    protected void setFeetLayer(String s) {
        this.feetLayer = Integer.parseInt(s);
    }

    protected void setMiscLayer(String s) {
        this.miscLayer = Integer.parseInt(s);
    }

    protected void setRaces(String csv) {
        String[] tokens = csv.split(",\\s*");
        this.races = new HashSet<String>(Arrays.asList(tokens));
    }

    public Set<String> getRaces() {
        return this.races;
    }

    public CellArray getCells() {
        return this.cells;
    }

    public Set<String> getFabrics() {
        return this.fabrics;
    }

    public String getPrimaryFabric() {
        return this.primaryFabric;
    }

    public String getFullName() {
        FabricType type = FabricTypeIndex.get(FabricTypeIndex.findType(this.primaryFabric));
        String name = type.getName();
        String var = type.getVariation();
        Object fabric = "metal".equals(name) && !"brushed".equals(var) ? var : ("natural".equals(var) ? name : var + " " + name);
        return (String)fabric + " " + this.getName();
    }

    public ClothingType randomize(SimilarFabricIndex similar, Random rand) {
        if (log.isTraceEnabled()) {
            log.trace("randomize():" + this.getFullName());
        }
        ClothingType result = this.clone();
        result.cells = this.cells.clone();
        HashMap<Integer, Integer> remap = new HashMap<Integer, Integer>();
        int xSize = this.cells.getSizeX();
        int ySize = this.cells.getSizeY();
        int zSize = this.cells.getSizeZ();
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                int val;
                for (int z = 0; z < zSize && (val = this.cells.getCell(x, y, z)) != 0; ++z) {
                    int fab = FabricUtils.toFabric(val);
                    int shape = FabricUtils.toShape(val);
                    Integer r = (Integer)remap.get(fab);
                    if (r == null) {
                        FabricType type = FabricTypeIndex.get(fab);
                        r = similar.getRandomType(type, rand);
                        FabricType newType = FabricTypeIndex.get(r);
                        if (log.isTraceEnabled()) {
                            log.trace("Remapping:" + type.getFullName() + " to:" + newType.getFullName());
                        }
                        remap.put(fab, r);
                    }
                    val = FabricUtils.toCell(shape, r);
                    result.cells.setCell(x, y, z, val);
                }
            }
        }
        result.analyze();
        if (log.isTraceEnabled()) {
            log.trace("randomize() result:" + result.getFullName());
        }
        return result;
    }

    public void populateCells(Function<String, CellArray> cellFunc) {
        if (log.isTraceEnabled()) {
            log.trace("Loading clothing for:" + this.clothing);
        }
        this.cells = cellFunc.apply(this.clothing);
        this.analyze();
    }

    protected void analyze() {
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        this.fabrics = new HashSet<String>();
        int xSize = this.cells.getSizeX();
        int ySize = this.cells.getSizeY();
        int zSize = this.cells.getSizeZ();
        for (int x = 0; x < xSize; ++x) {
            for (int y = 0; y < ySize; ++y) {
                int val;
                for (int z = 0; z < zSize && (val = this.cells.getCell(x, y, z)) != 0; ++z) {
                    int f = FabricUtils.toFabric(val);
                    FabricType type = FabricTypeIndex.get(f);
                    String fn = type.getFullName();
                    this.fabrics.add(fn);
                    Integer count = (Integer)counts.get(fn);
                    if (count == null) {
                        count = 0;
                    }
                    counts.put(fn, count + 1);
                }
            }
        }
        int max = 0;
        for (Map.Entry e : counts.entrySet()) {
            int count = (Integer)e.getValue();
            if (count <= max) continue;
            max = count;
            this.primaryFabric = (String)e.getKey();
        }
        if (log.isTraceEnabled()) {
            log.trace("fabrics:" + this.fabrics + "  primary:" + this.primaryFabric);
            log.trace("***  " + this.primaryFabric + " " + this.name + "  human readable:" + this.getFullName());
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("clothing", (Object)this.clothing).add("shirtLayer", this.shirtLayer).add("pantsLayer", this.pantsLayer).add("feetLayer", this.feetLayer).add("misLayer", this.miscLayer).add("races", this.races).toString();
    }
}

