/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import mythruna.sim.ai.AbstractBehavior;
import mythruna.sim.ai.Brain;
import mythruna.sim.ai.Mob;
import mythruna.sim.ai.Reaction;
import mythruna.sim.ai.Signal;
import mythruna.sim.ai.SteeringPrimitives;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FollowBehavior
extends AbstractBehavior {
    static Logger log = LoggerFactory.getLogger(FollowBehavior.class);
    private String defaultAction;
    private Mob follow;
    private SteeringPrimitives.Arrive arrive;

    public FollowBehavior(Mob follow, String defaultAction) {
        this.defaultAction = defaultAction;
        this.follow = follow;
    }

    public Mob getFollow() {
        return this.follow;
    }

    @Override
    public Reaction generateReaction(Brain brain, Signal signal) {
        if ("EnteredView".equals(signal.getType())) {
            log.info("Ignoring signal:" + signal);
            return new Reaction(null);
        }
        return null;
    }

    @Override
    protected void onStart(Brain brain) {
        log.info("onStart()");
        this.arrive = SteeringPrimitives.arrive(brain.getAgent(), this.follow.getLocation(), 1.0);
        brain.getAgent().setDefaultAction(this.defaultAction);
        brain.getAgent().setSteering(this.arrive);
    }

    @Override
    public boolean update(long frameTime, double step) {
        if (this.follow == null) {
            return false;
        }
        this.getBrain().getAgent().setSteering(this.arrive);
        this.arrive.setTarget(this.follow.getLocation());
        return true;
    }

    @Override
    protected void onStop() {
        log.info("onStop()");
    }
}

