/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.gext;

import com.jme3.math.ColorRGBA;
import java.util.List;
import org.codehaus.groovy.runtime.typehandling.GroovyCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColorRGBAGroovyMethods {
    static Logger log = LoggerFactory.getLogger(ColorRGBAGroovyMethods.class);

    public static ColorRGBA plus(ColorRGBA v1, ColorRGBA v2) {
        return v1.add(v2);
    }

    public static ColorRGBA plus(ColorRGBA v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        ColorRGBA result = new ColorRGBA(v1);
        result.r += v2.get(0).floatValue();
        result.g = result.g + (v2.size() > 1 ? v2.get(1).floatValue() : 0.0f);
        result.b = result.b + (v2.size() > 2 ? v2.get(2).floatValue() : 0.0f);
        result.a = result.a + (v2.size() > 3 ? v2.get(3).floatValue() : 0.0f);
        return result;
    }

    public static ColorRGBA minus(ColorRGBA v1, ColorRGBA v2) {
        ColorRGBA result = new ColorRGBA(v1);
        result.r -= v2.r;
        result.g -= v2.g;
        result.b -= v2.b;
        result.a -= v2.a;
        return result;
    }

    public static ColorRGBA minus(ColorRGBA v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        ColorRGBA result = new ColorRGBA(v1);
        result.r -= v2.get(0).floatValue();
        result.g = result.g - (v2.size() > 1 ? v2.get(1).floatValue() : 0.0f);
        result.b = result.b - (v2.size() > 2 ? v2.get(2).floatValue() : 0.0f);
        result.a = result.a - (v2.size() > 3 ? v2.get(3).floatValue() : 0.0f);
        return result;
    }

    public static ColorRGBA multiply(Number n, ColorRGBA v) {
        return v.mult(n.floatValue());
    }

    public static ColorRGBA multiply(ColorRGBA v, Number n) {
        return v.mult(n.floatValue());
    }

    public static ColorRGBA multiply(ColorRGBA v1, ColorRGBA v2) {
        return v1.mult(v2);
    }

    public static ColorRGBA multiply(ColorRGBA v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        ColorRGBA result = new ColorRGBA(v1);
        result.r *= v2.get(0).floatValue();
        result.g = result.g * (v2.size() > 1 ? v2.get(1).floatValue() : 1.0f);
        result.b = result.b * (v2.size() > 2 ? v2.get(2).floatValue() : 1.0f);
        result.a = result.a * (v2.size() > 3 ? v2.get(3).floatValue() : 1.0f);
        return result;
    }

    public static ColorRGBA div(ColorRGBA v, Number n) {
        return v.mult(1.0f / n.floatValue());
    }

    public static ColorRGBA div(ColorRGBA v1, ColorRGBA v2) {
        ColorRGBA result = new ColorRGBA(v1);
        result.r /= v2.r;
        result.g /= v2.g;
        result.b /= v2.b;
        result.a /= v2.a;
        return result;
    }

    public static ColorRGBA div(ColorRGBA v1, List<Number> v2) {
        if (v2.isEmpty()) {
            return v1;
        }
        ColorRGBA result = new ColorRGBA(v1);
        result.r /= v2.get(0).floatValue();
        result.g = result.g / (v2.size() > 1 ? v2.get(1).floatValue() : 1.0f);
        result.b = result.b / (v2.size() > 2 ? v2.get(2).floatValue() : 1.0f);
        result.a = result.a / (v2.size() > 3 ? v2.get(3).floatValue() : 1.0f);
        return result;
    }

    public static Object asType(ColorRGBA v, Class type) {
        if (type == ColorRGBA.class) {
            return v;
        }
        throw new GroovyCastException("Cannot convert:" + v + " to:" + type);
    }
}

