/*
 * Decompiled with CFR 0.152.
 */
package mythruna.mblock;

import com.simsilica.mblock.BlockName;
import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.IntCombiner;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mblock.phys.collision.ShapeSignature;
import com.simsilica.mblock.phys.collision.SimilarShapeIndex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialShapeCombiner
implements IntCombiner {
    static Logger log = LoggerFactory.getLogger(MaterialShapeCombiner.class);
    private List<String> baseOrder = new ArrayList<String>();
    private Map<String, String> baseMap = new HashMap<String, String>();
    private Map<String, String> shapeMap = new HashMap<String, String>();
    private Map<String, BlockName> baseFallbacks = new HashMap<String, BlockName>();
    private SimilarShapeIndex shapeIndex;
    private IntCombiner defaultCombiner;

    public MaterialShapeCombiner(SimilarShapeIndex shapeIndex, IntCombiner defaultCombiner) {
        this.shapeIndex = shapeIndex;
        this.defaultCombiner = defaultCombiner;
    }

    public static MaterialShapeCombiner createDefaultConfig(SimilarShapeIndex shapeIndex) {
        MaterialShapeCombiner result = new MaterialShapeCombiner(shapeIndex, (i1, i2) -> i2);
        result.setBaseOrder("snow", "leaves", "leaves2", "flora", "hedge", "log", "pine", "shrub", "trunk", "thatch", "ice", "sand", "dirt", "grass", "dry-grass", "clay", "fire", "light", "magic-white", "magic-red", "magic-green", "magic-blue", "glass", "leather", "W&D", "wood", "shingles", "mud-stone", "rock-capped", "rock", "steel-black", "steel-light", "steel", "iron", "cobble", "stone", "bmarble", "wmarble", "sandstone", "dark-granite", "bladder-low", "bladder");
        result.mapBase("thatch", "shrub", "shrub");
        result.mapBase("thatch", "pine", "wood");
        result.mapBase("thatch", "log", "wood");
        result.mapBase("pine", "log", "trunk");
        result.mapBase("shingles", "shrub", "wood");
        result.mapBase("shingles", "pine", "wood");
        result.mapBase("shingles", "log", "wood");
        result.mapBase("shingles", "thatch", "wood");
        result.mapBase("shingles", "W&D", "wood");
        result.mapShapePriority("flame-sm", "flame-lg", "flamex3", "flamex5");
        result.mapShapePriority("level1", "level2", "level3", "level4", "level5", "level6", "level7", "level8");
        result.mapShape("cone", "vcyl", "vcyl");
        result.mapShape("cone-up", "vcyl", "vcyl");
        result.mapShape("cone-dn", "vcyl", "vcyl");
        result.mapShape("spike-up", "vcyl", "vcyl");
        result.mapShape("spike-dn", "vcyl", "vcyl");
        result.mapShape("spike-up", "vcyl25", "vcyl25");
        result.mapShape("spike-dn", "vcyl25", "vcyl25");
        result.mapShape("spike-up", "cone", "cone");
        result.mapShape("spike-up", "cone-up", "cone-up");
        result.mapShape("spike-dn", "cone-dn", "cone-dn");
        result.mapShape("cone-up", "cone-dn", "vcyl");
        result.mapShape("spike-up", "spike-dn", "vcyl25");
        result.mapShape("post", "vcyl25", "post");
        result.mapShape("wall", "vcyl25", "cube");
        result.mapShape("post", "spike-dn", "post");
        result.mapShape("post", "spike-up", "post");
        result.mapShape("wall", "spike-up", "cube");
        result.mapShape("wall", "spike-dn", "cube");
        result.mapShape("cone-up", "spike-dn", "vcyl");
        result.mapShape("cone-dn", "spike-up", "vcyl");
        result.mapShape("cone-up", "vcyl25", "vcyl");
        result.mapShape("cone-dn", "vcyl25", "vcyl");
        result.setBaseFallback("shingles", new BlockName("wood", "cube"));
        result.setBaseFallback("thatch", new BlockName("wood", "cube"));
        return result;
    }

    public void setBaseOrder(String ... base) {
        this.baseOrder.clear();
        this.baseOrder.addAll(Arrays.asList(base));
    }

    public List<String> getBaseOrder() {
        return this.baseOrder;
    }

    public void setBaseFallback(String base, BlockName fallback) {
        this.baseFallbacks.put(base, fallback);
    }

    public BlockName getBaseFallback(String base) {
        return this.baseFallbacks.get(base);
    }

    public void mapBase(String base1, String base2, String result) {
        this.baseMap.put(base1 + "~" + base2, result);
        this.baseMap.put(base2 + "~" + base1, result);
    }

    public void mapShape(String shape1, String shape2, String result) {
        this.shapeMap.put(shape1 + "~" + shape2, result);
        this.shapeMap.put(shape2 + "~" + shape1, result);
    }

    public void mapShapePriority(String ... names) {
        for (int i = 0; i < names.length; ++i) {
            for (int j = i + 1; j < names.length; ++j) {
                this.mapShape(names[i], names[j], names[j]);
            }
        }
    }

    protected String getMappedBase(String base1, String base2) {
        return this.baseMap.get(base1 + "~" + base2);
    }

    protected String getMappedShape(String shape1, String shape2) {
        return this.shapeMap.get(shape1 + "~" + shape2);
    }

    public int apply(int i1, int i2) {
        ShapeSignature sig2;
        int search;
        String preferredBase;
        int index2;
        int index1;
        String base2;
        if ((i1 = MaskUtils.getType((int)i1)) == (i2 = MaskUtils.getType((int)i2))) {
            return i1;
        }
        if (i1 == 0) {
            return i2;
        }
        if (i2 == 0) {
            return i1;
        }
        BlockType type1 = BlockTypeIndex.get((int)i1);
        BlockType type2 = BlockTypeIndex.get((int)i2);
        String base1 = type1.getName().getBase();
        String mappedBase = this.getMappedBase(base1, base2 = type2.getName().getBase());
        if (mappedBase != null) {
            if (base1.equals(mappedBase)) {
                index1 = 1;
                index2 = 2;
            } else {
                index1 = 2;
                index2 = 1;
            }
            preferredBase = mappedBase;
        } else {
            index1 = this.baseOrder.indexOf(base1);
            preferredBase = index1 > (index2 = this.baseOrder.indexOf(base2)) ? base1 : base2;
        }
        String shape1 = type1.getName().getShape();
        Integer rot1 = type1.getName().getRotation();
        String shape2 = type2.getName().getShape();
        Integer rot2 = type2.getName().getRotation();
        if (Objects.equals(shape1, shape2) && Objects.equals(rot1, rot2)) {
            return index1 > index2 ? i1 : i2;
        }
        String preferredShape = this.getMappedShape(shape1, shape2);
        Integer preferredRot = null;
        if (shape1.equals(preferredShape)) {
            preferredRot = rot1;
        } else if (shape2.equals(preferredShape)) {
            preferredRot = rot2;
        }
        log.info("mappedShape(" + shape1 + ", " + shape2 + ") = " + preferredShape);
        if (preferredShape != null && (search = BlockTypeIndex.findType((BlockName)new BlockName(preferredBase, preferredShape, preferredRot))) > 0) {
            return search;
        }
        ShapeSignature sig1 = this.shapeIndex.getSignature(i1);
        ShapeSignature merged = sig1.merge(sig2 = this.shapeIndex.getSignature(i2));
        int containing = this.shapeIndex.findContaining(preferredBase, merged);
        if (containing < 0) {
            BlockName fallback = this.baseFallbacks.get(preferredBase);
            if (fallback != null) {
                containing = BlockTypeIndex.findType((BlockName)fallback);
            } else if (this.defaultCombiner != null) {
                containing = this.defaultCombiner.apply(i1, i2);
            }
        }
        return containing;
    }
}

