/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.shape;

import com.jme3.export.InputCapsule;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.OutputCapsule;
import com.jme3.math.Vector3f;
import com.jme3.scene.Mesh;
import java.io.IOException;

public abstract class AbstractBox
extends Mesh {
    public final Vector3f center = new Vector3f(0.0f, 0.0f, 0.0f);
    public float xExtent;
    public float yExtent;
    public float zExtent;

    protected final Vector3f[] computeVertices() {
        Vector3f[] axes = new Vector3f[]{Vector3f.UNIT_X.mult(this.xExtent), Vector3f.UNIT_Y.mult(this.yExtent), Vector3f.UNIT_Z.mult(this.zExtent)};
        return new Vector3f[]{this.center.subtract(axes[0]).subtractLocal(axes[1]).subtractLocal(axes[2]), this.center.add(axes[0]).subtractLocal(axes[1]).subtractLocal(axes[2]), this.center.add(axes[0]).addLocal(axes[1]).subtractLocal(axes[2]), this.center.subtract(axes[0]).addLocal(axes[1]).subtractLocal(axes[2]), this.center.add(axes[0]).subtractLocal(axes[1]).addLocal(axes[2]), this.center.subtract(axes[0]).subtractLocal(axes[1]).addLocal(axes[2]), this.center.add(axes[0]).addLocal(axes[1]).addLocal(axes[2]), this.center.subtract(axes[0]).addLocal(axes[1]).addLocal(axes[2])};
    }

    protected abstract void doUpdateGeometryIndices();

    protected abstract void doUpdateGeometryNormals();

    protected abstract void doUpdateGeometryTextures();

    protected abstract void doUpdateGeometryVertices();

    public final Vector3f getCenter() {
        return this.center;
    }

    public final float getXExtent() {
        return this.xExtent;
    }

    public final float getYExtent() {
        return this.yExtent;
    }

    public final float getZExtent() {
        return this.zExtent;
    }

    public final void updateGeometry() {
        this.doUpdateGeometryVertices();
        this.doUpdateGeometryNormals();
        this.doUpdateGeometryTextures();
        this.doUpdateGeometryIndices();
        this.setStatic();
    }

    public final void updateGeometry(Vector3f center, float x, float y, float z) {
        if (center != null) {
            this.center.set(center);
        }
        this.xExtent = x;
        this.yExtent = y;
        this.zExtent = z;
        this.updateGeometry();
    }

    public final void updateGeometry(Vector3f minPoint, Vector3f maxPoint) {
        this.center.set(maxPoint).addLocal(minPoint).multLocal(0.5f);
        float x = maxPoint.x - this.center.x;
        float y = maxPoint.y - this.center.y;
        float z = maxPoint.z - this.center.z;
        this.updateGeometry(this.center, x, y, z);
    }

    @Override
    public void read(JmeImporter e) throws IOException {
        super.read(e);
        InputCapsule capsule = e.getCapsule(this);
        this.xExtent = capsule.readFloat("xExtent", 0.0f);
        this.yExtent = capsule.readFloat("yExtent", 0.0f);
        this.zExtent = capsule.readFloat("zExtent", 0.0f);
        this.center.set((Vector3f)capsule.readSavable("center", Vector3f.ZERO.clone()));
    }

    @Override
    public void write(JmeExporter e) throws IOException {
        super.write(e);
        OutputCapsule capsule = e.getCapsule(this);
        capsule.write(this.xExtent, "xExtent", 0.0f);
        capsule.write(this.yExtent, "yExtent", 0.0f);
        capsule.write(this.zExtent, "zExtent", 0.0f);
        capsule.write(this.center, "center", Vector3f.ZERO);
    }
}

