/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mathd;

import com.simsilica.mathd.GridCell;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mathd.Vec3i;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Field;

public class Grid
implements Serializable {
    static final long serialVersionUID = 42L;
    private final Vec3i gridSpacing;
    private final int dimensions;
    private final Mask xMask;
    private final Mask yMask;
    private final Mask zMask;

    public Grid(int spacing) {
        this(spacing, spacing, spacing);
    }

    public Grid(int xSpacing, int zSpacing) {
        this(xSpacing, 0, zSpacing);
    }

    public Grid(int xSpacing, int ySpacing, int zSpacing) {
        this(new Vec3i(xSpacing, ySpacing, zSpacing), null);
    }

    public Grid(int xSpacing, int ySpacing, int zSpacing, Vec3i gridBits) {
        this(new Vec3i(xSpacing, ySpacing, zSpacing), gridBits);
    }

    public Grid(Vec3i gridSpacing) {
        this(gridSpacing, null);
    }

    public Grid(Vec3i gridSpacing, Vec3i gridBits) {
        int total;
        if (gridBits != null && (total = gridBits.x + gridBits.y + gridBits.z) > 64) {
            throw new IllegalArgumentException("Bit overfload in bit sizes:" + total);
        }
        this.gridSpacing = gridSpacing;
        int axes = 0;
        int xBits = 0;
        int yBits = 0;
        int zBits = 0;
        if (gridSpacing.x != 0) {
            ++axes;
            xBits = 1;
        }
        if (gridSpacing.y != 0) {
            ++axes;
            yBits = 1;
        }
        if (gridSpacing.z != 0) {
            ++axes;
            zBits = 1;
        }
        this.dimensions = axes;
        int bits = 64 / axes;
        if (gridBits == null) {
            xBits *= bits;
            yBits *= bits;
            zBits *= bits;
        } else {
            if (xBits > 0 && gridBits.x == 0) {
                throw new IllegalArgumentException("Grid spacing has x but no xBits allocated");
            }
            if (yBits > 0 && gridBits.y == 0) {
                throw new IllegalArgumentException("Grid spacing has y but no yBits allocated");
            }
            if (zBits > 0 && gridBits.z == 0) {
                throw new IllegalArgumentException("Grid spacing has z but no zBits allocated");
            }
            xBits = gridBits.x;
            yBits = gridBits.y;
            zBits = gridBits.z;
        }
        this.xMask = new Mask(xBits);
        this.yMask = new Mask(yBits);
        this.zMask = new Mask(zBits);
    }

    public final Vec3i getSpacing() {
        return this.gridSpacing;
    }

    public final int getDimensions() {
        return this.dimensions;
    }

    public final Vec3i getIdBits() {
        return new Vec3i(this.xMask.shift, this.yMask.shift, this.zMask.shift);
    }

    private int worldToCell(int i, int size) {
        if (size == 0) {
            return 0;
        }
        if (i < 0) {
            i = (i + 1) / size;
            return i - 1;
        }
        return i / size;
    }

    private int worldToCell(double d, int size) {
        return this.worldToCell((int)Math.floor(d), size);
    }

    private int cellToWorld(int i, int size) {
        return i * size;
    }

    public final GridCell getContainingCell(double xWorld, double yWorld, double zWorld) {
        return new GridCell(this, this.worldToCell(xWorld, yWorld, zWorld));
    }

    public final GridCell getContainingCell(Vec3d world) {
        return this.getContainingCell(world.x, world.y, world.z);
    }

    public final GridCell getContainingCell(Vec3i world) {
        return this.getContainingCell(world.x, world.y, world.z);
    }

    public final GridCell getGridCell(Vec3i cell) {
        return new GridCell(this, cell.clone());
    }

    public final GridCell getGridCell(int xCell, int yCell, int zCell) {
        return new GridCell(this, new Vec3i(xCell, yCell, zCell));
    }

    public final Vec3i worldToCell(double xWorld, double yWorld, double zWorld) {
        return this.worldToCell(xWorld, yWorld, zWorld, new Vec3i());
    }

    public final Vec3i worldToCell(double xWorld, double yWorld, double zWorld, Vec3i store) {
        if (store == null) {
            store = new Vec3i();
        }
        store.x = this.worldToCell(xWorld, this.gridSpacing.x);
        store.y = this.worldToCell(yWorld, this.gridSpacing.y);
        store.z = this.worldToCell(zWorld, this.gridSpacing.z);
        return store;
    }

    public final Vec3i worldToCell(Vec3d world) {
        return this.worldToCell(world.x, world.y, world.z, new Vec3i());
    }

    public final Vec3i worldToCell(Vec3d world, Vec3i store) {
        return this.worldToCell(world.x, world.y, world.z, store);
    }

    public final Vec3i cellToWorld(int xCell, int yCell, int zCell) {
        return this.cellToWorld(xCell, yCell, zCell, new Vec3i());
    }

    public final Vec3i cellToWorld(int xCell, int yCell, int zCell, Vec3i store) {
        if (store == null) {
            store = new Vec3i();
        }
        store.x = this.cellToWorld(xCell, this.gridSpacing.x);
        store.y = this.cellToWorld(yCell, this.gridSpacing.y);
        store.z = this.cellToWorld(zCell, this.gridSpacing.z);
        return store;
    }

    public final Vec3d cellToWorld(int xCell, int yCell, int zCell, Vec3d store) {
        if (store == null) {
            store = new Vec3d();
        }
        store.x = this.cellToWorld(xCell, this.gridSpacing.x);
        store.y = this.cellToWorld(yCell, this.gridSpacing.y);
        store.z = this.cellToWorld(zCell, this.gridSpacing.z);
        return store;
    }

    public final Vec3i cellToWorld(Vec3i cell) {
        return this.cellToWorld(cell.x, cell.y, cell.z, new Vec3i());
    }

    public final Vec3i cellToWorld(Vec3i cell, Vec3i store) {
        return this.cellToWorld(cell.x, cell.y, cell.z, store);
    }

    public final Vec3d cellToWorld(Vec3i cell, Vec3d store) {
        return this.cellToWorld(cell.x, cell.y, cell.z, store);
    }

    public final long worldToId(Vec3d world) {
        return this.worldToId(world.x, world.y, world.z);
    }

    public final long worldToId(double xWorld, double yWorld, double zWorld) {
        int x = this.worldToCell(xWorld, this.gridSpacing.x);
        int y = this.worldToCell(yWorld, this.gridSpacing.y);
        int z = this.worldToCell(zWorld, this.gridSpacing.z);
        return this.cellToId(x, y, z);
    }

    public final long cellToId(Vec3i cell) {
        return this.cellToId(cell.x, cell.y, cell.z);
    }

    public final long cellToId(int xCell, int yCell, int zCell) {
        long result = 0L;
        result = this.xMask.apply(xCell, result);
        result <<= this.yMask.shift;
        result = this.yMask.apply(yCell, result);
        result <<= this.zMask.shift;
        result = this.zMask.apply(zCell, result);
        return result;
    }

    public final Vec3i idToCell(long id, Vec3i store) {
        int z = this.zMask.extract(id);
        int y = this.yMask.extract(id >>= this.zMask.shift);
        int x = this.xMask.extract(id >>= this.yMask.shift);
        id >>= this.xMask.shift;
        if (store == null) {
            store = new Vec3i(x, y, z);
        } else {
            store.set(x, y, z);
        }
        return store;
    }

    public final Vec3i idToCell(long id) {
        return this.idToCell(id, new Vec3i());
    }

    public String toString() {
        return "Grid[" + this.gridSpacing + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.xMask == null) {
            int bits = 64 / this.dimensions;
            Mask x = this.gridSpacing.x != 0 ? new Mask(bits) : new Mask(0);
            Mask y = this.gridSpacing.y != 0 ? new Mask(bits) : new Mask(0);
            Mask z = this.gridSpacing.z != 0 ? new Mask(bits) : new Mask(0);
            try {
                Class<?> c = this.getClass();
                Field xf = c.getDeclaredField("xMask");
                xf.setAccessible(true);
                Field yf = c.getDeclaredField("yMask");
                yf.setAccessible(true);
                Field zf = c.getDeclaredField("zMask");
                zf.setAccessible(true);
                xf.set(this, x);
                yf.set(this, y);
                zf.set(this, z);
            }
            catch (Exception e) {
                throw new IOException("Error deserializing older version", e);
            }
        }
    }

    private static final class Mask
    implements Serializable {
        static final long serialVersionUID = 1L;
        private final int shift;
        private final long mask;
        private final int signCheck;
        private final int signExtend;

        public Mask(int bits) {
            this.shift = bits;
            this.signExtend = (int)(-1L << bits);
            this.signCheck = 1 << bits - 1;
            this.mask = -1L << bits ^ 0xFFFFFFFFFFFFFFFFL;
        }

        public long apply(int cell, long target) {
            return target | (long)cell & this.mask;
        }

        public int extract(long id) {
            if (this.shift == 0) {
                return 0;
            }
            int result = (int)(id & this.mask);
            if ((result & this.signCheck) != 0) {
                result |= this.signExtend;
            }
            return result;
        }
    }
}

