/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.text;

import com.simsilica.lemur.core.VersionedObject;
import com.simsilica.lemur.core.VersionedReference;
import com.simsilica.lemur.text.DocumentModel;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DefaultDocumentModel
implements DocumentModel,
Cloneable {
    private long version;
    private List<StringBuilder> lines = new ArrayList<StringBuilder>();
    private String composite = null;
    private Carat carat = new Carat();
    private int line = 0;
    private int column = 0;

    public DefaultDocumentModel() {
        this.parseText("");
    }

    public DefaultDocumentModel(String text) {
        this.parseText(text != null ? text : "");
    }

    @Override
    public DefaultDocumentModel clone() {
        try {
            DefaultDocumentModel result = (DefaultDocumentModel)super.clone();
            result.lines = new ArrayList<StringBuilder>(this.lines.size());
            for (int i = 0; i < result.lines.size(); ++i) {
                StringBuilder sb = this.lines.get(i);
                result.lines.set(i, new StringBuilder(sb));
            }
            result.carat = this.carat.clone();
            result.version = 0L;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Clone not supported", e);
        }
    }

    @Override
    public void setText(String text) {
        this.parseText(text != null ? text : "");
    }

    @Override
    public String getText() {
        if (this.composite == null) {
            this.createComposite();
        }
        return this.composite;
    }

    @Override
    public String getLine(int line) {
        return this.lines.get(line).toString();
    }

    @Override
    public int getLineCount() {
        return this.lines.size();
    }

    @Override
    public int getCarat() {
        return this.carat.get();
    }

    @Override
    public int getCaratLine() {
        return this.line;
    }

    @Override
    public int getCaratColumn() {
        return this.column;
    }

    @Override
    public int getAnchorLine() {
        return this.getCaratLine();
    }

    @Override
    public int getAnchorColumn() {
        return this.getCaratColumn();
    }

    @Override
    public int getAnchor() {
        return this.getCarat();
    }

    @Override
    public int home(boolean currentLine) {
        if (currentLine) {
            this.carat.move(-this.column);
            this.column = 0;
        } else {
            this.carat.set(0);
            this.column = 0;
            this.line = 0;
        }
        return this.carat.get();
    }

    @Override
    public int end(boolean currentLine) {
        if (currentLine) {
            StringBuilder row = this.lines.get(this.line);
            this.carat.move(row.length() - this.column);
            this.column = row.length();
        } else {
            this.carat.set(0);
            this.column = 0;
            this.line = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                if (i > 0) {
                    this.carat.increment();
                }
                StringBuilder row = this.lines.get(i);
                this.carat.move(row.length());
                this.column = row.length();
            }
            this.line = this.lines.size() - 1;
        }
        return this.carat.get();
    }

    @Override
    public int up() {
        if (this.line == 0) {
            return this.carat.get();
        }
        this.carat.move(-this.column);
        --this.line;
        this.carat.decrement();
        if (this.column <= this.lines.get(this.line).length()) {
            this.carat.move(-(this.lines.get(this.line).length() - this.column));
        } else {
            this.column = this.lines.get(this.line).length();
        }
        return this.carat.get();
    }

    @Override
    public int down() {
        if (this.line == this.lines.size() - 1) {
            return this.carat.get();
        }
        int restOfLine = this.lines.get(this.line).length() - this.column;
        this.carat.move(restOfLine);
        ++this.line;
        this.carat.increment();
        this.column = Math.min(this.column, this.lines.get(this.line).length());
        this.carat.move(this.column);
        return this.carat.get();
    }

    @Override
    public int left() {
        if (this.carat.get() == 0) {
            return 0;
        }
        this.carat.decrement();
        --this.column;
        if (this.column < 0) {
            --this.line;
            if (this.line < 0) {
                System.out.println("How did this happen?  carat:" + this.carat);
            }
            this.column = this.lines.get(this.line).length();
        }
        return this.carat.get();
    }

    @Override
    public int right() {
        ++this.column;
        this.carat.increment();
        if (this.column > this.lines.get(this.line).length()) {
            if (this.line < this.lines.size() - 1) {
                ++this.line;
                this.column = 0;
            } else {
                --this.column;
                this.carat.decrement();
            }
        }
        return this.carat.get();
    }

    @Override
    public void insertNewLine() {
        if (this.line == this.lines.size() - 1 && this.column == this.lines.get(this.line).length()) {
            this.lines.add(new StringBuilder());
        } else {
            StringBuilder row = this.lines.get(this.line);
            StringBuilder next = new StringBuilder(row.substring(this.column));
            row.delete(this.column, row.length());
            this.lines.add(this.line + 1, next);
        }
        ++this.line;
        this.column = 0;
        this.carat.increment();
        this.composite = null;
        ++this.version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteCharAt(int pos) {
        if (pos == this.carat.get() - 1) {
            this.backspace();
            return;
        }
        if (pos == this.carat.get()) {
            this.delete();
            return;
        }
        int[] location = new int[2];
        this.findPosition(pos, location);
        if (location[0] >= this.lines.size()) {
            return;
        }
        StringBuilder row = this.lines.get(location[0]);
        if (location[1] == row.length()) {
            if (location[0] >= this.lines.size() - 1) return;
            row.append((CharSequence)this.lines.get(location[0] + 1));
            this.lines.remove(location[0] + 1);
        } else {
            row.deleteCharAt(location[1]);
        }
        if (this.carat.get() <= pos) {
            this.carat.decrement();
            this.findPosition(this.carat.get(), location);
            this.line = location[0];
            this.column = location[1];
        }
        this.composite = null;
        ++this.version;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void backspace() {
        if (this.carat.get() == 0) {
            return;
        }
        if (this.column == 0) {
            if (this.line <= 0) return;
            this.column = this.lines.get(this.line - 1).length();
            this.lines.get(this.line - 1).append((CharSequence)this.lines.remove(this.line));
            this.carat.decrement();
            --this.line;
        } else {
            StringBuilder row = this.lines.get(this.line);
            row.deleteCharAt(this.column - 1);
            --this.column;
            this.carat.decrement();
        }
        this.composite = null;
        ++this.version;
    }

    @Override
    public void delete() {
        StringBuilder row = this.lines.get(this.line);
        if (this.column == row.length()) {
            if (this.line >= this.lines.size() - 1) {
                return;
            }
            row.append((CharSequence)this.lines.remove(this.line + 1));
        } else {
            row.deleteCharAt(this.column);
        }
        this.composite = null;
        ++this.version;
    }

    protected void findPosition(int pos, int[] location) {
        int index = 0;
        location[0] = 0;
        location[1] = 0;
        for (int r = 0; r < this.lines.size(); ++r) {
            StringBuilder l = this.lines.get(r);
            if (pos - index <= l.length()) {
                location[0] = r;
                location[1] = pos - index;
                return;
            }
            index += l.length() + 1;
        }
        location[0] = this.lines.size();
        location[1] = 0;
    }

    @Override
    public void insert(char c) {
        if (c < ' ') {
            return;
        }
        switch (c) {
            default: 
        }
        this.lines.get(this.line).insert(this.column, c);
        this.carat.increment();
        ++this.column;
        this.composite = null;
        ++this.version;
    }

    @Override
    public void insert(String text) {
        for (int i = 0; i < text.length(); ++i) {
            this.insert(text.charAt(i));
        }
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public DocumentModel getObject() {
        return this;
    }

    @Override
    public VersionedReference<DocumentModel> createReference() {
        return new VersionedReference<DocumentModel>(this);
    }

    @Override
    public VersionedReference<Integer> createCaratReference() {
        return this.carat.createReference();
    }

    protected void parseText(String text) {
        this.composite = null;
        this.lines.clear();
        StringTokenizer st = new StringTokenizer(text, "\r\n");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            this.lines.add(new StringBuilder(token));
        }
        if (this.lines.isEmpty()) {
            this.lines.add(new StringBuilder());
        }
        this.end(false);
        ++this.version;
    }

    protected void createComposite() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.lines.size(); ++i) {
            sb.append((CharSequence)this.lines.get(i));
            if (i >= this.lines.size() - 1) continue;
            sb.append("\n");
        }
        this.composite = sb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    private class Carat
    implements VersionedObject<Integer> {
        private int value;
        private long version;

        public Carat clone() {
            Carat result = new Carat();
            result.value = this.value;
            return result;
        }

        public final int get() {
            return this.value;
        }

        public final int set(int value) {
            if (this.value == value) {
                return value;
            }
            this.value = value;
            ++this.version;
            return value;
        }

        public final int move(int amount) {
            this.value += amount;
            ++this.version;
            return this.value;
        }

        public final int increment() {
            ++this.value;
            ++this.version;
            return this.value;
        }

        public final int decrement() {
            --this.value;
            ++this.version;
            return this.value;
        }

        @Override
        public final long getVersion() {
            return this.version;
        }

        @Override
        public final Integer getObject() {
            return this.value;
        }

        @Override
        public final VersionedReference<Integer> createReference() {
            return new VersionedReference<Integer>(this);
        }

        public final String toString() {
            return "Carat[" + this.value + "]";
        }
    }
}

