/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.db;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.mworld.ColumnData;
import com.simsilica.mworld.ColumnId;
import com.simsilica.mworld.db.AbstractColumnDb;
import com.simsilica.mworld.db.ColumnDb;
import com.simsilica.mworld.db.ColumnPostProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostProcColumnDb
extends AbstractColumnDb {
    static Logger log = LoggerFactory.getLogger(PostProcColumnDb.class);
    private ColumnDb delegate;
    private List<ColumnPostProcessor> processorList = new ArrayList<ColumnPostProcessor>();
    private ColumnPostProcessor[] processors;
    private LoadingCache<ColumnId, ColumnData> cache;

    public PostProcColumnDb(ColumnDb delegate, ColumnPostProcessor ... procs) {
        this.delegate = delegate;
        this.cache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<ColumnId, ColumnData>(){

            public ColumnData load(ColumnId id) {
                return PostProcColumnDb.this.loadColumn(id);
            }
        });
        if (procs != null && procs.length > 0) {
            this.processorList.addAll(Arrays.asList(procs));
        }
    }

    public void addColumnPostProcessor(ColumnPostProcessor proc) {
        if (this.processors != null) {
            throw new IllegalArgumentException("Cannot add a processor to initialized PostProcColumnDb");
        }
        this.processorList.add(proc);
    }

    public void removeColumnPostProcessor(ColumnPostProcessor proc) {
        if (this.processors != null) {
            throw new IllegalArgumentException("Cannot add a processor to initialized PostProcColumnDb");
        }
        this.processorList.remove(proc);
    }

    public ColumnDb getDelegate() {
        return this.delegate;
    }

    @Override
    public void initialize() {
        this.delegate.initialize();
        for (ColumnPostProcessor proc : this.processors = this.processorList.toArray(new ColumnPostProcessor[0])) {
            proc.initialize(this);
        }
    }

    @Override
    public void terminate() {
        for (ColumnPostProcessor proc : this.processors) {
            proc.terminate();
        }
        this.delegate.terminate();
    }

    @Override
    public ColumnData getColumn(ColumnId columnId) {
        return (ColumnData)this.cache.getUnchecked((Object)columnId);
    }

    @Override
    public void markChanged(ColumnData col) {
        this.delegate.markChanged(col);
    }

    @Override
    public synchronized void resetColumn(ColumnId columnId) {
        log.info("resetColumn(" + columnId + ")");
        this.delegate.resetColumn(columnId);
        this.loadColumn(columnId);
    }

    protected ColumnData loadColumn(ColumnId columnId) {
        ColumnData result = this.delegate.getColumn(columnId);
        boolean changed = false;
        for (ColumnPostProcessor proc : this.processors) {
            if (!proc.postProcess(result)) continue;
            changed = true;
        }
        if (changed) {
            this.delegate.markChanged(result);
            this.columnGenerated(result);
        }
        return result;
    }
}

