/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.input;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.input.CameraMovementTarget;
import com.simsilica.input.MovementFunctions;
import com.simsilica.input.MovementTarget;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.input.AnalogFunctionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.input.InputState;
import com.simsilica.lemur.input.StateFunctionListener;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MovementState
extends BaseAppState {
    static Logger log = LoggerFactory.getLogger(MovementState.class);
    private InputMapper inputMapper;
    private MovementTarget target;
    private MoveInputListener inputListener = new MoveInputListener();
    private double turnSpeed = 1.0;
    private double yaw = Math.PI;
    private double pitch = 0.0;
    private double maxPitch = 1.5707963267948966;
    private double minPitch = -1.5707963267948966;
    private Quatd facing = new Quatd().fromAngles(this.pitch, this.yaw, 0.0);
    private Vec3d movementForce = new Vec3d();
    private double walkSpeed = 3.0;
    private double runSpeed = 10.0;
    private double currentSpeed = this.walkSpeed;
    private boolean running = false;
    private boolean invertPitch;

    public void setMovementTarget(MovementTarget target) {
        this.setMovementTarget(target, true);
    }

    public void setMovementTarget(MovementTarget target, boolean autoEnable) {
        if (this.target != null) {
            this.target.terminate(this);
        }
        this.target = target;
        if (target != null) {
            target.initialize(this);
            this.initializeRotation(target.getRotation());
            this.setEnabled(autoEnable);
        } else {
            this.setEnabled(false);
        }
    }

    public MovementTarget getMovementTarget() {
        return this.target;
    }

    public void setPitch(double pitch) {
        this.pitch = this.clampPitch(pitch);
        this.updateFacing();
    }

    public double getPitch() {
        return this.pitch;
    }

    public void setMaxPitch(double maxPitch) {
        this.maxPitch = maxPitch;
    }

    public double getMaxPitch() {
        return this.maxPitch;
    }

    public void setMinPitch(double minPitch) {
        this.minPitch = minPitch;
    }

    public double getMinPitch() {
        return this.minPitch;
    }

    public void setInvertPitch(boolean invertPitch) {
        this.invertPitch = invertPitch;
    }

    public boolean isInvertPitch() {
        return this.invertPitch;
    }

    public void setWalkSpeed(double walkSpeed) {
        this.walkSpeed = walkSpeed;
        this.resetCurrentSpeed();
    }

    public double getWalkSpeed() {
        return this.walkSpeed;
    }

    public void setRunSpeed(double runSpeed) {
        this.runSpeed = runSpeed;
        this.resetCurrentSpeed();
    }

    public double getRunSpeed() {
        return this.runSpeed;
    }

    public void setRunning(boolean running) {
        this.running = running;
        this.resetCurrentSpeed();
    }

    public boolean isRunning() {
        return this.runSpeed == this.currentSpeed;
    }

    protected void resetCurrentSpeed() {
        this.currentSpeed = this.running ? this.runSpeed : this.walkSpeed;
    }

    public void setYaw(double yaw) {
        this.yaw = yaw;
        this.updateFacing();
    }

    public double getYaw() {
        return this.yaw;
    }

    public void initializeRotation(double yaw, double pitch) {
        this.pitch = this.clampPitch(pitch);
        this.yaw = yaw;
        this.updateFacing();
    }

    public void initializeRotation(Quatd rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("Rotation cannot be null");
        }
        double[] angle = rotation.toAngles(null);
        this.pitch = this.clampPitch(angle[0]);
        this.yaw = angle[1];
        log.info("initialized yaw/pitch to:" + this.yaw + ", " + this.pitch);
        this.updateFacing();
    }

    public Quatd getRotation() {
        return this.facing;
    }

    public Vec3d getMovementForce() {
        return this.movementForce;
    }

    public void update(float tpf) {
        this.target.move(this.facing, this.movementForce, tpf);
    }

    protected void initialize(Application app) {
        if (this.inputMapper == null) {
            this.inputMapper = GuiGlobals.getInstance().getInputMapper();
        }
        if (this.target == null) {
            log.info("Setting up default CameraMovementTarget for the application camera");
            this.setMovementTarget(new CameraMovementTarget(app.getCamera()), this.isEnabled());
        }
        MovementFunctions.initializeDefaultMappings(this.inputMapper);
        this.inputMapper.addAnalogListener((AnalogFunctionListener)this.inputListener, new FunctionId[]{MovementFunctions.F_Y_LOOK, MovementFunctions.F_X_LOOK, MovementFunctions.F_MOVE, MovementFunctions.F_ELEVATE, MovementFunctions.F_STRAFE});
        this.inputMapper.addStateListener((StateFunctionListener)this.inputListener, new FunctionId[]{MovementFunctions.F_RUN});
    }

    protected void cleanup(Application app) {
        this.inputMapper.removeAnalogListener((AnalogFunctionListener)this.inputListener, new FunctionId[]{MovementFunctions.F_Y_LOOK, MovementFunctions.F_X_LOOK, MovementFunctions.F_MOVE, MovementFunctions.F_ELEVATE, MovementFunctions.F_STRAFE});
        this.inputMapper.removeStateListener((StateFunctionListener)this.inputListener, new FunctionId[]{MovementFunctions.F_RUN});
    }

    protected void onEnable() {
        this.inputMapper.activateGroup("Movement");
        GuiGlobals.getInstance().setCursorEventsEnabled(false);
        this.getApplication().getInputManager().setCursorVisible(false);
        this.initializeRotation(this.target.getRotation());
    }

    protected void onDisable() {
        this.inputMapper.deactivateGroup("Movement");
        GuiGlobals.getInstance().setCursorEventsEnabled(true);
    }

    protected double clampPitch(double pitch) {
        if (pitch < this.minPitch) {
            return this.minPitch;
        }
        if (pitch > this.maxPitch) {
            return this.maxPitch;
        }
        return pitch;
    }

    protected void updateFacing() {
        this.facing.fromAngles(this.pitch * (double)(this.invertPitch ? -1 : 1), this.yaw, 0.0);
        this.target.setRotation(this.facing);
    }

    private class MoveInputListener
    implements AnalogFunctionListener,
    StateFunctionListener {
        private MoveInputListener() {
        }

        public void valueChanged(FunctionId func, InputState value, double tpf) {
            boolean b;
            boolean bl = b = value == InputState.Positive;
            if (func == MovementFunctions.F_RUN) {
                if (b) {
                    MovementState.this.currentSpeed = MovementState.this.runSpeed;
                } else {
                    MovementState.this.currentSpeed = MovementState.this.walkSpeed;
                }
            }
        }

        public void valueActive(FunctionId func, double value, double tpf) {
            if (func == MovementFunctions.F_Y_LOOK) {
                MovementState.this.pitch = MovementState.this.clampPitch(MovementState.this.pitch - value * tpf * MovementState.this.turnSpeed);
                MovementState.this.updateFacing();
            } else if (func == MovementFunctions.F_X_LOOK) {
                MovementState.this.yaw = MovementState.this.yaw + -value * tpf * MovementState.this.turnSpeed;
                if (MovementState.this.yaw < 0.0) {
                    MovementState.this.yaw = MovementState.this.yaw + Math.PI * 2;
                }
                if (MovementState.this.yaw > Math.PI * 2) {
                    MovementState.this.yaw = MovementState.this.yaw - Math.PI * 2;
                }
                MovementState.this.updateFacing();
            } else if (func == MovementFunctions.F_MOVE) {
                ((MovementState)MovementState.this).movementForce.z = value * MovementState.this.currentSpeed;
            } else if (func == MovementFunctions.F_STRAFE) {
                ((MovementState)MovementState.this).movementForce.x = -value * MovementState.this.currentSpeed;
            } else if (func == MovementFunctions.F_ELEVATE) {
                ((MovementState)MovementState.this).movementForce.y = value * MovementState.this.currentSpeed;
            }
        }
    }
}

