/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shape;

import com.google.common.base.MoreObjects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IconName {
    static Logger log = LoggerFactory.getLogger(IconName.class);
    private static final Pattern NAME_PATTERN = Pattern.compile("^(.*?)(?:\\(\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\))?$");
    private String imageName;
    private Integer xCell;
    private Integer yCell;

    protected IconName() {
    }

    public IconName(String imageName, Integer xCell, Integer yCell) {
        this.imageName = imageName;
        this.xCell = xCell;
        this.yCell = yCell;
    }

    public static IconName parse(String s) {
        Matcher m = NAME_PATTERN.matcher(s);
        if (!m.matches()) {
            throw new IllegalArgumentException("Invalid icon name format:" + s);
        }
        String name = m.group(1);
        Integer x = null;
        Integer y = null;
        if (m.group(2) != null) {
            x = Integer.parseInt(m.group(2));
        }
        if (m.group(3) != null) {
            y = Integer.parseInt(m.group(3));
        }
        return new IconName(name, x, y);
    }

    public String getImageName() {
        return this.imageName;
    }

    public Integer getX() {
        return this.xCell;
    }

    public Integer getY() {
        return this.yCell;
    }

    public String toCompositeString() {
        StringBuilder sb = new StringBuilder(this.imageName);
        if (this.xCell != null && this.yCell != null) {
            sb.append("(" + this.xCell + ", " + this.yCell + ")");
        }
        return sb.toString();
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)this.getClass().getSimpleName()).omitNullValues().add("imageName", (Object)this.imageName).add("x", (Object)this.xCell).add("y", (Object)this.yCell).toString();
    }
}

