/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.google.common.base.Function;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.mblock.phys.MBlockShape;
import com.simsilica.mphys.ControlDriver;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.mphys.RigidBody;
import com.simsilica.mphys.UprightDriver;
import com.simsilica.net.server.ChatHostedService;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mythruna.es.AgentType;
import mythruna.sim.DiagnosticsProducer;
import mythruna.sim.ai.AgentChatProvider;
import mythruna.sim.ai.AgentDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentSystem
extends AbstractGameSystem
implements DiagnosticsProducer {
    static Logger log = LoggerFactory.getLogger(AgentSystem.class);
    private EntityData ed;
    private ChatHostedService chatService;
    private MPhysSystem<MBlockShape> physics;
    private AgentContainer agents;
    private AgentBodyInitializer initializer = new AgentBodyInitializer();
    private PhysicsSpace<EntityId, MBlockShape> space;

    public AgentSystem(ChatHostedService chatService) {
        this.chatService = chatService;
    }

    public RigidBody<EntityId, MBlockShape> getBody(EntityId id) {
        return this.space.getBinIndex().getRigidBody((Object)id);
    }

    public AgentDriver getAgentDriver(EntityId id) {
        return (AgentDriver)this.agents.getObject(id);
    }

    @Override
    public String getDiagnostics() {
        return String.format("active agents:%d", this.agents.size());
    }

    @Override
    public List<String> getDiagnostics(EntityId entityId) {
        AgentDriver driver = (AgentDriver)this.agents.getObject(entityId);
        if (driver == null) {
            return new ArrayList<String>(Arrays.asList("No agent for:" + entityId));
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add("entityId:" + driver.getEntityId());
        result.add("isEnabled:" + driver.isEnabled());
        result.add("agentType:" + driver.getAgentType());
        result.add("defaultAction:" + driver.getDefaultAction());
        result.add("flying:" + driver.isFlying());
        result.add("location:" + driver.getLocation());
        result.add("brain:" + driver.getBrain());
        result.add("agent body:" + driver.getAgentBody());
        RigidBody body = this.space.getBinIndex().getRigidBody((Object)entityId);
        result.add("physics space body:" + body);
        return result;
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class);
        if (this.ed == null) {
            throw new RuntimeException(this.getClass().getName() + " system requires an EntityData object.");
        }
        this.physics = (MPhysSystem)this.getSystem(MPhysSystem.class);
        if (this.physics == null) {
            throw new RuntimeException(this.getClass().getName() + " system requires the MPhysSystem system.");
        }
        this.space = this.physics.getPhysicsSpace();
        this.physics.getBodyFactory().addDynamicInitializer((Function)this.initializer);
    }

    protected void terminate() {
    }

    public void start() {
        this.agents = new AgentContainer(this.ed);
        this.agents.start();
    }

    public void update(SimTime time) {
        this.agents.update();
    }

    public void stop() {
        this.agents.stop();
        this.agents = null;
    }

    private class AgentBodyInitializer
    implements Function<RigidBody<EntityId, MBlockShape>, Void> {
        private AgentBodyInitializer() {
        }

        public Void apply(RigidBody<EntityId, MBlockShape> body) {
            AgentDriver driver = (AgentDriver)AgentSystem.this.agents.getObject((EntityId)body.id);
            if (log.isDebugEnabled()) {
                log.debug("MovementBodyInitializer.apply(" + body.id + ")  driver:" + driver);
            }
            if (driver != null) {
                body.setControlDriver((ControlDriver)driver);
            }
            return null;
        }
    }

    private class AgentContainer
    extends EntityContainer<AgentDriver> {
        public AgentContainer(EntityData ed) {
            super(ed, new Class[]{AgentType.class});
            this.setFilter(AgentType.levelFilter(0));
        }

        public AgentDriver[] getArray() {
            return (AgentDriver[])super.getArray();
        }

        protected AgentDriver addObject(Entity e) {
            if (log.isDebugEnabled()) {
                log.debug("addObject(" + e + ")");
            }
            AgentDriver result = new AgentDriver(AgentSystem.this.physics, new AgentChatProvider(e.getId(), AgentSystem.this.chatService), e.getId());
            RigidBody body = AgentSystem.this.space.getBinIndex().getRigidBody((Object)e.getId());
            if (body != null) {
                if (log.isDebugEnabled()) {
                    log.debug("existing body:" + body.id);
                }
                body.setControlDriver((ControlDriver)result);
                body.wakeUp();
                AgentSystem.this.space.getBinIndex().activate(body);
            } else if (log.isDebugEnabled()) {
                log.debug((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"existing body:null"})));
            }
            this.updateObject(result, e);
            return result;
        }

        protected void updateObject(AgentDriver driver, Entity e) {
            if (log.isTraceEnabled()) {
                log.trace("updateObject(" + e + ")");
            }
            AgentType type = (AgentType)e.get(AgentType.class);
            driver.changeAgentType(type);
        }

        protected void removeObject(AgentDriver driver, Entity e) {
            RigidBody body;
            if (log.isDebugEnabled()) {
                log.debug("removeObject(" + e + ")");
            }
            if ((body = AgentSystem.this.space.getBinIndex().getRigidBody((Object)e.getId())) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Removing driver and putting body to sleep:" + e.getId());
                }
                UprightDriver nullDriver = new UprightDriver();
                body.setControlDriver((ControlDriver)nullDriver);
                body.makeSleepy();
            }
        }
    }
}

