/*
 * Decompiled with CFR 0.152.
 */
package mythruna.text;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultipartText {
    static Logger log = LoggerFactory.getLogger(MultipartText.class);
    private static final Pattern SECTION_PATTERN = Pattern.compile("(?m)^\\[\\s*(.*?)\\s*]$");
    private Map<String, String> parts = new HashMap<String, String>();

    public MultipartText(String text) {
        this.parts = MultipartText.parseParts(text);
    }

    public static Map<String, String> parseParts(String text) {
        String previous;
        HashMap<String, String> results = new HashMap<String, String>();
        String section = null;
        int last = 0;
        Matcher m = SECTION_PATTERN.matcher(text);
        while (m.find()) {
            previous = text.substring(last, m.start()).trim();
            if (section == null) {
                if (previous.length() > 0) {
                    results.put(section, previous);
                }
            } else {
                results.put(section, previous);
            }
            section = m.group(1);
            last = m.end();
        }
        if (last < text.length()) {
            previous = text.substring(last).trim();
            results.put(section, previous);
        }
        return results;
    }

    public String get(String part) {
        return this.parts.get(part);
    }
}

