/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SqlSession {
    private Connection conn;
    private Map<String, PreparedStatement> statementCache = new HashMap<String, PreparedStatement>();

    public SqlSession(Connection conn) {
        this.conn = conn;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, true);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return this.prepareStatement(sql, autoGeneratedKeys, true);
    }

    public PreparedStatement prepareStatement(String sql, boolean cache) throws SQLException {
        return this.prepareStatement(sql, 2, cache);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys, boolean cache) throws SQLException {
        PreparedStatement result = this.statementCache.get(sql);
        if (result != null) {
            result.clearParameters();
            return result;
        }
        result = this.conn.prepareStatement(sql, autoGeneratedKeys);
        if (cache) {
            this.statementCache.put(sql, result);
        }
        return result;
    }

    public void release() throws SQLException {
        for (PreparedStatement st : this.statementCache.values()) {
            st.close();
        }
        this.statementCache.clear();
    }
}

