/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.es.server;

import com.simsilica.es.server.EntityDataHostedService;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import com.simsilica.thread.IterationProcessor;
import com.simsilica.thread.IterationProcessorThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUpdater
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(EntityUpdater.class);
    private final EntityDataHostedService entityService;
    private final IterationProcessorThread thread;
    private long checkThresholdNanos = 50000000L;

    public EntityUpdater(EntityDataHostedService entityService) {
        this(entityService, false);
    }

    public EntityUpdater(EntityDataHostedService entityService, boolean backgroundThread) {
        this.entityService = entityService;
        this.thread = backgroundThread ? new IterationProcessorThread("EntityUpdater", new UpdateProcessor(), false) : null;
    }

    public void setTimingCheckThreshold(long checkMs) {
        this.checkThresholdNanos = checkMs * 1000000L;
    }

    public long getTimingCheckThreshold() {
        return this.checkThresholdNanos / 1000000L;
    }

    @Override
    protected void initialize() {
    }

    @Override
    public void start() {
        log.info("start()" + this.thread);
        this.thread.start();
    }

    @Override
    public void update(SimTime time) {
        if (this.thread != null) {
            this.thread.iterate();
        } else {
            this.sendUpdates();
        }
    }

    @Override
    public void stop() {
        log.info("stop()" + this.thread);
        this.thread.close();
    }

    @Override
    protected void terminate() {
    }

    protected void sendUpdates() {
        long start = System.nanoTime();
        this.entityService.sendUpdates();
        long end = System.nanoTime();
        this.checkTiming(start, end);
    }

    protected void checkTiming(long start, long end) {
        long delta = end - start;
        if (delta > this.checkThresholdNanos) {
            log.warn(String.format("Entity updates exceed 50 ms: %.03f ms", (double)delta / 1000000.0));
        }
    }

    public class UpdateProcessor
    implements IterationProcessor {
        @Override
        public void onStart() {
        }

        @Override
        public void onIterate() {
            EntityUpdater.this.sendUpdates();
        }

        @Override
        public void onStop() {
        }
    }
}

