/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.state;

import com.jme3.app.Application;
import com.jme3.app.SimpleApplication;
import com.jme3.app.state.BaseAppState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.TextField;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.component.TextEntryComponent;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.event.KeyAction;
import com.simsilica.lemur.event.KeyActionListener;
import com.simsilica.lemur.input.FunctionId;
import com.simsilica.lemur.input.InputMapper;
import com.simsilica.lemur.style.ElementId;
import com.simsilica.state.CommandEntry;
import com.simsilica.state.MessageState;

public class CommandConsoleState
extends BaseAppState {
    public static final FunctionId F_OPEN_CONSOLE = new FunctionId("Open Console");
    public static final ElementId CONTAINER_ID = new ElementId("console.container");
    public static final ElementId PROMPT_LABEL_ID = new ElementId("console.prompt.label");
    public static final ElementId TEXT_ENTRY_ID = new ElementId("console.textField");
    private Container entryPanel;
    private Label prompt;
    private TextField entry;
    private CommandEntry shell = new DefaultCommandEntry();
    private boolean alwaysOpen = false;

    public CommandConsoleState() {
        this.setEnabled(false);
    }

    public void setCommandEntry(CommandEntry commandEntry) {
        if (commandEntry == null) {
            commandEntry = new DefaultCommandEntry();
        }
        this.shell = commandEntry;
    }

    public CommandEntry getCommandEntry() {
        return this.shell;
    }

    public void toggleConsole() {
        this.setEnabled(!this.isEnabled());
    }

    public void setAlwaysOpen(boolean alwaysOpen) {
        this.alwaysOpen = alwaysOpen;
        this.setEnabled(alwaysOpen);
    }

    public boolean isAlwaysOpen() {
        return this.alwaysOpen;
    }

    protected void initialize(Application app) {
        this.entryPanel = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Last, FillMode.None), new ElementId("console.container"));
        this.prompt = (Label)this.entryPanel.addChild((Node)new Label(">", PROMPT_LABEL_ID), new Object[0]);
        this.entry = (TextField)this.entryPanel.addChild((Node)new TextField("", TEXT_ENTRY_ID), new Object[0]);
        this.entry.getActionMap().put(new KeyAction(28, new int[0]), new NewLine());
        this.entry.getActionMap().put(new KeyAction(1, new int[0]), new Escape());
        InputMapper input = GuiGlobals.getInstance().getInputMapper();
        input.addDelegate(F_OPEN_CONSOLE, (Object)this, "toggleConsole");
    }

    protected void cleanup(Application app) {
        InputMapper input = GuiGlobals.getInstance().getInputMapper();
        input.removeDelegate(F_OPEN_CONSOLE, (Object)this, "toggleConsole");
    }

    protected void onEnable() {
        Node gui = ((SimpleApplication)this.getApplication()).getGuiNode();
        gui.attachChild((Spatial)this.entryPanel);
        this.entryPanel.setPreferredSize(null);
        Vector3f pref = this.entryPanel.getPreferredSize();
        pref.x = this.getApplication().getCamera().getWidth();
        this.entryPanel.setPreferredSize(pref);
        this.entryPanel.setLocalTranslation(0.0f, pref.y, 0.0f);
        ((MessageState)this.getState(MessageState.class)).setMessageRootOffset(new Vector3f(0.0f, pref.y, 0.0f));
        ((MessageState)this.getState(MessageState.class)).setAlphaOverride(1.0f);
        GuiGlobals.getInstance().requestFocus((Spatial)this.entry);
    }

    protected void onDisable() {
        GuiGlobals.getInstance().requestFocus(null);
        this.entryPanel.removeFromParent();
        ((MessageState)this.getState(MessageState.class)).setMessageRootOffset(new Vector3f(0.0f, 0.0f, 0.0f));
        ((MessageState)this.getState(MessageState.class)).setAlphaOverride(0.0f);
    }

    private class DefaultCommandEntry
    implements CommandEntry {
        private DefaultCommandEntry() {
        }

        @Override
        public boolean runCommand(String cmd) {
            ((MessageState)CommandConsoleState.this.getState(MessageState.class)).addMessage(cmd, ColorRGBA.White);
            return false;
        }
    }

    private class Escape
    implements KeyActionListener {
        private Escape() {
        }

        public void keyAction(TextEntryComponent source, KeyAction key) {
            CommandConsoleState.this.entry.setText("");
            CommandConsoleState.this.setEnabled(CommandConsoleState.this.alwaysOpen);
        }
    }

    private class NewLine
    implements KeyActionListener {
        private NewLine() {
        }

        public void keyAction(TextEntryComponent source, KeyAction key) {
            String text = CommandConsoleState.this.entry.getText();
            CommandConsoleState.this.entry.setText("");
            if (!CommandConsoleState.this.shell.runCommand(text)) {
                CommandConsoleState.this.setEnabled(CommandConsoleState.this.alwaysOpen);
            }
        }
    }
}

