/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.anim;

import com.jme3.app.Application;
import com.jme3.app.state.BaseAppState;
import com.simsilica.lemur.anim.Animation;
import com.simsilica.lemur.anim.Tween;
import com.simsilica.lemur.anim.TweenAnimation;
import java.util.ArrayList;
import java.util.List;

public class AnimationState
extends BaseAppState {
    public static final double NANOS_TO_SECONDS = 1.0E-9;
    private static AnimationState defaultInstance;
    private final List<Animation> tasks = new ArrayList<Animation>();
    private Animation[] array = null;
    private long lastTime;

    public AnimationState() {
        if (defaultInstance == null) {
            defaultInstance = this;
        }
    }

    public static AnimationState getDefaultInstance() {
        return defaultInstance;
    }

    public boolean isRunning(Animation anim) {
        return this.tasks.contains(anim);
    }

    public <T extends Animation> T add(T anim) {
        this.tasks.add(anim);
        this.array = null;
        return anim;
    }

    public TweenAnimation add(Tween ... sequence) {
        TweenAnimation anim = new TweenAnimation(sequence);
        return this.add(anim);
    }

    public void cancel(Animation anim) {
        anim.cancel();
        this.remove(anim);
    }

    private Animation[] getArray() {
        if (this.array == null) {
            this.array = new Animation[this.tasks.size()];
            this.array = this.tasks.toArray(this.array);
        }
        return this.array;
    }

    protected void remove(Animation anim) {
        this.tasks.remove(anim);
        this.array = null;
    }

    protected void initialize(Application app) {
    }

    protected void cleanup(Application app) {
        for (Animation a : this.getArray()) {
            this.cancel(a);
        }
        defaultInstance = (AnimationState)this.getState(AnimationState.class);
    }

    protected void onEnable() {
        this.lastTime = System.nanoTime();
    }

    public void update(float tpf) {
        long time = System.nanoTime();
        long delta = time - this.lastTime;
        double t = (double)delta * 1.0E-9;
        this.lastTime = time;
        for (Animation a : this.getArray()) {
            if (a.animate(t)) continue;
            this.remove(a);
        }
    }

    protected void onDisable() {
    }
}

