/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.focus;

import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.simsilica.lemur.focus.FocusManagerState;
import com.simsilica.lemur.focus.FocusTraversal;

public class DefaultFocusTraversalControl
extends AbstractControl
implements FocusTraversal {
    private boolean focusRoot = false;
    private Node node;

    public DefaultFocusTraversalControl() {
    }

    public DefaultFocusTraversalControl(boolean focusRoot) {
        this.focusRoot = focusRoot;
    }

    public void setSpatial(Spatial s) {
        if (s != null && !(s instanceof Node)) {
            throw new IllegalArgumentException("This control only works with nodes.");
        }
        super.setSpatial(s);
        this.node = (Node)s;
    }

    @Override
    public Spatial getDefaultFocus() {
        return this.getFirstFocus();
    }

    @Override
    public Spatial getRelativeFocus(Spatial from, FocusTraversal.TraversalDirection direction) {
        switch (direction) {
            case Up: 
            case Left: 
            case Previous: {
                return this.getPreviousFocus(from);
            }
            default: {
                return this.getNextFocus(from);
            }
            case Home: 
            case PageHome: {
                return this.getFirstFocus();
            }
            case End: 
            case PageEnd: 
        }
        return this.getLastFocus();
    }

    public void setFocusRoot(boolean f) {
        this.focusRoot = f;
    }

    @Override
    public boolean isFocusRoot() {
        return this.focusRoot;
    }

    protected Spatial getFirstFocus() {
        for (int i = 0; i < this.node.getQuantity(); ++i) {
            Spatial s = this.node.getChild(i);
            if (FocusManagerState.findFocusTarget(s) == null) continue;
            return s;
        }
        return null;
    }

    protected Spatial getLastFocus() {
        for (int i = this.node.getQuantity() - 1; i >= 0; --i) {
            Spatial s = this.node.getChild(i);
            if (FocusManagerState.findFocusTarget(s) == null) continue;
            return s;
        }
        return null;
    }

    protected Spatial getNextFocus(Spatial from) {
        int start = this.node.getChildIndex(from);
        if (start < 0) {
            return null;
        }
        for (int i = start + 1; i < this.node.getQuantity(); ++i) {
            Spatial s = this.node.getChild(i);
            if (FocusManagerState.findFocusTarget(s) == null) continue;
            return s;
        }
        return null;
    }

    protected Spatial getPreviousFocus(Spatial from) {
        int start = this.node.getChildIndex(from);
        if (start <= 0) {
            return null;
        }
        for (int i = start - 1; i >= 0; --i) {
            Spatial s = this.node.getChild(i);
            if (FocusManagerState.findFocusTarget(s) == null) continue;
            return s;
        }
        return null;
    }

    protected void controlUpdate(float f) {
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[isFocusRoot= " + this.isFocusRoot() + "]";
    }
}

