/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mblock.config;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.jme3.asset.AssetManager;
import com.jme3.export.JmeExporter;
import com.jme3.export.JmeImporter;
import com.jme3.export.Savable;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.export.binary.BinaryImporter;
import com.jme3.material.Material;
import com.simsilica.mblock.config.MaterialConfig;
import com.simsilica.mblock.geom.GeomPart;
import com.simsilica.mblock.geom.GeomReq;
import com.simsilica.mblock.geom.MaterialType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialRegistry
implements Serializable {
    static Logger log = LoggerFactory.getLogger(MaterialRegistry.class);
    static final long serialVersionUID = 42L;
    private Set<String> names = new TreeSet<String>();
    private Map<MaterialType, MaterialConfig> configs = new HashMap<MaterialType, MaterialConfig>();
    private ListMultimap<String, MaterialConfig> configIndex = MultimapBuilder.hashKeys().arrayListValues().build();
    private transient Map<String, Material> materials = new HashMap<String, Material>();

    public void initialize(AssetManager assets) {
        for (MaterialConfig config : this.configs.values()) {
            MaterialType mt = config.getMaterialType();
            log.info("Creating material:" + mt + "  parms:" + config.entrySet());
            this.materials.put(mt.getId(), config.createMaterial(assets, this));
        }
    }

    public void update(AssetManager assets) {
        for (MaterialConfig config : this.configs.values()) {
            this.update(config, assets);
        }
    }

    public void update(MaterialConfig config, AssetManager assets) {
        log.info("Updating:" + config.getName());
        MaterialType mt = config.getMaterialType();
        String key = mt.getId();
        Material mat = this.materials.get(key);
        if (mat == null) {
            this.materials.put(key, config.createMaterial(assets, this));
            return;
        }
        config.updateMaterial(mat, assets, this);
    }

    public void addConfig(MaterialConfig config) {
        MaterialType mt = config.getMaterialType();
        this.configs.put(mt, config);
        this.configIndex.put((Object)config.getName(), (Object)config);
        this.names.add(config.getName());
    }

    public void addConfigs(Collection<MaterialConfig> configs) {
        for (MaterialConfig c : configs) {
            this.addConfig(c);
        }
    }

    public Set<MaterialType> getTypes() {
        return this.configs.keySet();
    }

    public Collection<String> getNames() {
        return this.names;
    }

    public Collection<MaterialConfig> getConfigs() {
        return this.configs.values();
    }

    public Collection<MaterialConfig> getConfigs(String name) {
        return this.configIndex.get((Object)name);
    }

    public MaterialConfig getConfig(MaterialType type) {
        return this.configs.get(type);
    }

    public MaterialConfig findConfig(String name, MaterialType type) {
        List list = this.configIndex.get((Object)name);
        if (!list.isEmpty()) {
            return (MaterialConfig)list.get(0);
        }
        return null;
    }

    public MaterialConfig findBest(String name, GeomPart part) {
        EnumSet<GeomReq> caps = part.calculateGeomCaps();
        return this.findBest(name, caps);
    }

    public MaterialConfig findBest(String name, GeomReq ... caps) {
        EnumSet<GeomReq> set = EnumSet.noneOf(GeomReq.class);
        if (caps != null && caps.length > 0) {
            set.addAll(Arrays.asList(caps));
            set = GeomReq.expandImplied(set);
        }
        return this.findBest(name, set);
    }

    public MaterialConfig findBest(String name, EnumSet<GeomReq> caps) {
        log.info("************ findBest(" + name + ", " + caps + ")");
        MaterialConfig best = null;
        int maxCount = -1;
        for (MaterialConfig config : this.configIndex.get((Object)name)) {
            EnumSet<GeomReq> reqs = config.getImpliedReqs();
            log.info("  " + name + "  reqs:" + reqs);
            if (!caps.containsAll(reqs) && !reqs.isEmpty()) continue;
            log.info("    compatible.");
            if (reqs.size() <= maxCount) continue;
            maxCount = reqs.size();
            best = config;
        }
        return best;
    }

    public boolean remove(MaterialType type) {
        log.info("Removing:" + type);
        MaterialConfig config = this.configs.remove(type);
        if (config == null) {
            return false;
        }
        this.configIndex.remove((Object)type, (Object)config);
        this.materials.remove(type.getId());
        return true;
    }

    public Material getMaterial(MaterialType type) {
        return this.getMaterial(type, true);
    }

    public Map<String, Material> getMaterials() {
        return this.materials;
    }

    public void storeCompiledMaterials(OutputStream out) throws IOException {
        BinaryExporter.getInstance().save((Savable)new MaterialSetSavable(this.materials), out);
    }

    public static Map<String, Material> loadCompiledMaterials(AssetManager assets, InputStream in) throws IOException {
        BinaryImporter importer = BinaryImporter.getInstance();
        importer.setAssetManager(assets);
        MaterialSetSavable loaded = (MaterialSetSavable)importer.load(in);
        return loaded.materials;
    }

    public static Map<String, Material> loadCompiledMaterials(AssetManager assets, String resource) throws IOException {
        URL u = MaterialRegistry.class.getResource(resource);
        if (u == null) {
            return null;
        }
        return MaterialRegistry.loadCompiledMaterials(assets, u.openStream());
    }

    public Material getMaterial(MaterialType type, boolean failOnMiss) {
        Material result = this.materials.get(type.getName());
        if (result == null && this.materials.containsKey(type.getName())) {
            throw new IllegalStateException("MaterialRegistry has not been initialized");
        }
        if (result == null && failOnMiss) {
            throw new IllegalArgumentException("No material found for:" + type + ", all types:" + this.materials.keySet());
        }
        return result;
    }

    public static class MaterialSetSavable
    implements Savable {
        private Map<String, Material> materials;

        protected MaterialSetSavable() {
        }

        public MaterialSetSavable(Map<String, Material> materials) {
            this.materials = materials;
        }

        public void read(JmeImporter in) throws IOException {
            this.materials = in.getCapsule((Savable)this).readStringSavableMap("materials", null);
        }

        public void write(JmeExporter out) throws IOException {
            out.getCapsule((Savable)this).writeStringSavableMap(this.materials, "materials", null);
        }
    }
}

