/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.mworld.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import com.simsilica.mblock.CellArray;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafId;
import com.simsilica.mworld.io.CellArrayProtocol;
import com.simsilica.mworld.io.ObjectProtocol;
import java.io.IOException;

public class FluidDataProtocol
implements ObjectProtocol<FluidData> {
    private int protocolVersion = 1;
    private CellArrayProtocol cellProtocol = new CellArrayProtocol();

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public void write(FluidData fluidData, BitOutputStream out) throws IOException {
        assert (fluidData.checkCounts());
        out.writeBits(this.protocolVersion, 8);
        out.writeLongBits(fluidData.getLeafId().getId(), 64);
        out.writeLongBits(-1L, 64);
        out.writeBits(fluidData.getEmptyCellCount(), 16);
        int[] array = fluidData.getArray();
        if (array == null) {
            out.writeBits(0, 1);
            return;
        }
        out.writeBits(1, 1);
        this.cellProtocol.writeRleData(array, 31, 0, 5, out);
        this.cellProtocol.writeRleData(array, 480, 5, 4, out);
        this.cellProtocol.writeRleData(array, -67108864, 26, 6, out);
        this.cellProtocol.writeRleData(array, 0x3C00000, 22, 4, out);
        this.cellProtocol.writeRleData(array, 2096640, 9, 12, out);
    }

    @Override
    public FluidData read(BitInputStream in) throws IOException {
        int version = in.readBits(8);
        LeafId leafId = new LeafId(in.readLongBits(64));
        long dataVersion = in.readLongBits(64);
        int emptyCellCount = in.readBits(16);
        int nullBit = in.readBits(1);
        if (nullBit == 0) {
            return new FluidData(leafId, null, emptyCellCount);
        }
        CellArray cells = new CellArray(32);
        this.cellProtocol.readRleData(cells.getArray(), 31, 0, 5, in);
        this.cellProtocol.readRleData(cells.getArray(), 480, 5, 4, in);
        this.cellProtocol.readRleData(cells.getArray(), -67108864, 26, 6, in);
        this.cellProtocol.readRleData(cells.getArray(), 0x3C00000, 22, 4, in);
        this.cellProtocol.readRleData(cells.getArray(), 2096640, 9, 12, in);
        return new FluidData(leafId, cells, emptyCellCount);
    }
}

