/*
 * Decompiled with CFR 0.152.
 */
package mythruna.shell;

import com.simsilica.action.ActionEnvironment;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import mythruna.shell.CommandShell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellService<K> {
    static Logger log = LoggerFactory.getLogger(ShellService.class);
    private WeakHashMap<K, CommandShell> shells = new WeakHashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ActionEnvironment<?, K> globalActionEnv;
    private final CommandShell globalShell;

    public ShellService(ActionEnvironment<?, K> globalActionEnv) {
        this.globalActionEnv = globalActionEnv;
        this.globalShell = new CommandShell(globalActionEnv);
    }

    public CommandShell getGlobalShell() {
        return this.globalShell;
    }

    public CommandShell createChildShell(K id, ActionEnvironment<?, K> actionEnv) {
        return this.createChildShell(id, actionEnv, null);
    }

    public CommandShell createChildShell(K id, ActionEnvironment<?, K> actionEnv, Consumer<String> output) {
        if (this.shells.get(id) != null) {
            throw new IllegalArgumentException("Key:" + id + " already has a shell");
        }
        CommandShell child = new CommandShell(this.globalShell, actionEnv, output);
        this.setShell(id, child);
        return child;
    }

    public void setShell(K id, CommandShell shell) {
        this.lock.writeLock().lock();
        try {
            this.shells.put(id, shell);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public CommandShell getShell(K id) {
        this.lock.readLock().lock();
        try {
            CommandShell commandShell = this.shells.get(id);
            return commandShell;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public CommandShell removeShell(K id) {
        this.lock.writeLock().lock();
        try {
            CommandShell commandShell = this.shells.remove(id);
            return commandShell;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

