/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.encounter;

import com.simsilica.mblock.BlockType;
import com.simsilica.mblock.BlockTypeIndex;
import com.simsilica.mblock.DirectionMasks;
import com.simsilica.mblock.FluidType;
import com.simsilica.mblock.FluidTypeIndex;
import com.simsilica.mblock.FluidUtils;
import com.simsilica.mblock.MaskUtils;
import com.simsilica.mworld.FluidData;
import com.simsilica.mworld.LeafData;
import com.simsilica.mworld.World;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import mythruna.sim.encounter.CellStats;
import mythruna.sim.encounter.Zone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellStatsInitializer
implements Consumer<Zone> {
    static Logger log = LoggerFactory.getLogger(CellStatsInitializer.class);
    private World world;
    private static Set<Integer> leafTypes = new HashSet<Integer>();
    private static Set<Integer> grassTypes = new HashSet<Integer>();
    private static Set<Integer> waterTypes = new HashSet<Integer>();

    public CellStatsInitializer(World world) {
        this.world = world;
        BlockType[] types = BlockTypeIndex.getTypes();
        for (int i = 0; i < types.length; ++i) {
            BlockType type = types[i];
            if (type == null || type.getName() == null) continue;
            String base = type.getName().getBase();
            if (base.startsWith("leaves")) {
                leafTypes.add(i);
                continue;
            }
            if ("pine".equals(base)) {
                leafTypes.add(i);
                continue;
            }
            if ("shrub".equals(base)) {
                leafTypes.add(i);
                continue;
            }
            if (!"grass".equals(base)) continue;
            grassTypes.add(i);
        }
        FluidType[] fluidTypes = FluidTypeIndex.getTypes();
        for (int i = 0; i < fluidTypes.length; ++i) {
            String base;
            FluidType type = fluidTypes[i];
            if (type == null || type.getName() == null || !"water".equals(base = type.getName().getBase())) continue;
            waterTypes.add(i);
        }
    }

    public static boolean isGrassBlock(int type) {
        return grassTypes.contains(type);
    }

    public static boolean isLeafBlock(int type) {
        return leafTypes.contains(type);
    }

    public static boolean isWaterBlock(int type) {
        return waterTypes.contains(type);
    }

    @Override
    public void accept(Zone zone) {
        CellStats stats;
        if (log.isTraceEnabled()) {
            log.trace("Initialize zone:" + zone);
        }
        if ((stats = zone.get(CellStats.class)) == null) {
            stats = new CellStats();
            zone.set(CellStats.class, stats);
        } else {
            stats.clear();
        }
        LeafData blocks = this.world.getLeaf(zone.getZoneId());
        zone.set(LeafData.class, blocks);
        if (!blocks.isEmpty()) {
            for (int i = 0; i < 32; ++i) {
                for (int k = 0; k < 32; ++k) {
                    for (int j = 0; j < 32; ++j) {
                        int val = blocks.getCell(i, j, k);
                        if (val == 0) continue;
                        Integer type = MaskUtils.getType((int)val);
                        if (leafTypes.contains(type)) {
                            ++stats.leafBlocks;
                            continue;
                        }
                        if (!grassTypes.contains(type)) continue;
                        ++stats.grassBlocks;
                    }
                }
            }
        }
        FluidData fluid = this.world.getFluid(zone.getZoneId());
        zone.set(FluidData.class, fluid);
        if (!fluid.isEmpty()) {
            for (int i = 0; i < 32; ++i) {
                for (int k = 0; k < 32; ++k) {
                    for (int j = 0; j < 32; ++j) {
                        Integer type;
                        int sides;
                        int val = fluid.getCell(i, j, k);
                        if (val == 0 || !DirectionMasks.hasUp((int)(sides = FluidUtils.getSideMask((int)val))) || !waterTypes.contains(type = Integer.valueOf(FluidUtils.getType((int)val)))) continue;
                        ++stats.waterBlocks;
                    }
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("leaf stats:" + stats);
        }
    }
}

