/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mythruna.world.WorldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldLibrary {
    static Logger log = LoggerFactory.getLogger(WorldLibrary.class);
    private File dir;
    private List<WorldInfo> worlds = new ArrayList<WorldInfo>();

    public WorldLibrary(File dir) {
        this.dir = dir;
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.refreshList();
    }

    public void refreshList() {
        this.worlds.clear();
        for (File f : this.dir.listFiles()) {
            if (!f.isDirectory() || !f.getName().toLowerCase().endsWith(".world")) continue;
            this.addWorld(f);
        }
    }

    public List<WorldInfo> getWorlds() {
        return Collections.unmodifiableList(this.worlds);
    }

    public WorldInfo createWorldInfo(String name, String fractalName, long seed) {
        if (!this.dir.exists()) {
            this.dir.mkdirs();
        }
        File worldDir = new File(this.dir, name + ".world");
        File infoFile = new File(worldDir, "world.info");
        WorldInfo info = new WorldInfo(name, fractalName, seed);
        if (!worldDir.exists()) {
            worldDir.mkdirs();
        }
        WorldLibrary.store(info, infoFile);
        info.setDirectory(worldDir);
        return info;
    }

    protected void addWorld(File worldDir) {
        File infoFile = new File(worldDir, "world.info");
        WorldInfo info = WorldLibrary.loadWorldInfo(infoFile);
        this.worlds.add(info);
    }

    public WorldInfo loadWorldInfo(String worldDir) {
        File f = new File(worldDir);
        if (!f.isAbsolute() && !f.exists()) {
            f = new File(this.dir, worldDir);
        }
        if (!f.exists()) {
            log.warn("Directory not found:" + f);
            return null;
        }
        File infoFile = new File(f, "world.info");
        return WorldLibrary.loadWorldInfo(infoFile);
    }

    public static WorldInfo loadWorldInfo(File f) {
        if (f.isDirectory()) {
            f = new File(f, "world.info");
        }
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            String json = Files.toString((File)f, (Charset)Charsets.UTF_8);
            WorldInfo info = (WorldInfo)gson.fromJson(json, WorldInfo.class);
            info.setDirectory(f.getCanonicalFile().getParentFile());
            info.upgrade();
            return info;
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading:" + f, e);
        }
    }

    public static void store(WorldInfo worldInfo) {
        File f = worldInfo.getDirectory();
        if (f == null) {
            throw new IllegalArgumentException("WorldInfo has no directory set:" + worldInfo);
        }
        WorldLibrary.store(worldInfo, f);
    }

    public static void store(WorldInfo worldInfo, File f) {
        if (f.isDirectory()) {
            f = new File(f, "world.info");
        }
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting();
        Gson gson = gsonBuilder.create();
        try {
            log.info("Storing:" + f);
            String json = gson.toJson((Object)worldInfo);
            Files.write((CharSequence)json, (File)f, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Error storing:" + f, e);
        }
    }
}

