/*
 * Decompiled with CFR 0.152.
 */
package mythruna.client.net.character;

import com.jme3.scene.Node;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityData;
import com.simsilica.es.Name;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.CallMethodAction;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.Panel;
import java.util.HashMap;
import java.util.Map;
import mythruna.character.RaceType;
import mythruna.character.RaceTypeIndex;
import mythruna.client.net.character.AbstractCharacterPage;
import mythruna.client.net.character.CharacterEditor;
import mythruna.client.ui.MarkdownUtil;
import mythruna.es.Race;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SummaryPage
extends AbstractCharacterPage {
    static Logger log = LoggerFactory.getLogger(SummaryPage.class);
    private EntityData ed;
    private RaceTypeIndex races;
    private Label view = null;
    private int maxTextWidth = 720;
    private Map<String, String> characterAttributes = new HashMap<String, String>();

    public SummaryPage() {
        super("Character Summary");
        this.addChild((Node)new Label("Loading..."), new Object[0]);
        this.setNextActions(new Action[]{new CallMethodAction("Play", (Object)this, "play")});
    }

    @Override
    protected void onInitialize(CharacterEditor parent) {
        this.ed = parent.getEntityData();
        this.races = parent.getRaces();
    }

    @Override
    protected boolean onSetCharacter(Entity character) {
        return character != null;
    }

    @Override
    protected void onAttach() {
        this.characterAttributes.clear();
        this.characterAttributes.put("name", this.getComponent(Name.class).getName());
        Race race = this.getComponent(Race.class);
        RaceType raceType = this.races.getRace(race.getTypeName(this.ed));
        this.characterAttributes.put("raceType.name", raceType.getName());
        this.characterAttributes.put("raceType.subtype", raceType.getSubtype());
        String doc = raceType.getSummary();
        for (Map.Entry<String, String> e : this.characterAttributes.entrySet()) {
            doc = doc.replace("${" + e.getKey() + "}", e.getValue());
        }
        log.info("Summary:\n" + doc);
        MarkdownUtil.populateContainer((Container)this, (float)this.maxTextWidth, doc);
    }

    @Override
    public Panel getView() {
        return this.view;
    }

    protected void play() {
        this.getCharacterEditor().doneEdit();
    }
}

