/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.bpos.mphys;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.simsilica.bpos.BodyPosition;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.ext.mphys.MPhysSystem;
import com.simsilica.ext.mphys.ObjectStatusAdapter;
import com.simsilica.ext.mphys.ObjectStatusListener;
import com.simsilica.mathd.AaBBox;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.AbstractShape;
import com.simsilica.mphys.PhysicsListener;
import com.simsilica.mphys.RigidBody;
import com.simsilica.sim.AbstractGameSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BodyPositionPublisher<S extends AbstractShape>
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(BodyPositionPublisher.class);
    private EntityData ed;
    private PhysicsObserver observer = new PhysicsObserver();

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class);
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).addPhysicsListener((PhysicsListener)this.observer);
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).getBinEntityManager().addObjectStatusListener((ObjectStatusListener)this.observer);
    }

    protected void terminate() {
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).getBinEntityManager().removeObjectStatusListener((ObjectStatusListener)this.observer);
        ((MPhysSystem)this.getSystem(MPhysSystem.class)).removePhysicsListener((PhysicsListener)this.observer);
    }

    private class PhysicsObserver
    extends ObjectStatusAdapter<S>
    implements PhysicsListener<EntityId, S> {
        private long frameTime;
        private Vector3f posf = new Vector3f();
        private Quaternion orientf = new Quaternion();
        private Vec3d pos = new Vec3d();
        private Quatd orient = new Quatd();
        private AaBBox box = new AaBBox(1.0);

        public void startFrame(long frameTime, double stepSize) {
            this.frameTime = frameTime;
        }

        public void endFrame() {
        }

        public void update(RigidBody<EntityId, S> body) {
            BodyPosition bPos;
            if (log.isTraceEnabled()) {
                log.trace("update(" + body + ")");
            }
            if ((bPos = (BodyPosition)BodyPositionPublisher.this.ed.getComponent((EntityId)body.id, BodyPosition.class)) == null) {
                log.error("No body position for:" + body.id);
                return;
            }
            Vec3d pos = body.shape.getWorldShapeOrigin(body);
            bPos.addFrame(this.frameTime, pos, body.orientation, true);
        }

        public void objectLoaded(EntityId id, RigidBody<EntityId, S> body) {
            if (log.isTraceEnabled()) {
                log.trace("objectLoaded(" + id + ", " + body + ")");
            }
            BodyPosition bPos = new BodyPosition(3);
            Vec3d pos = body.shape.getWorldShapeOrigin(body);
            bPos.addFrame(this.frameTime, pos, body.orientation, true);
            BodyPositionPublisher.this.ed.setComponent((EntityId)body.id, (EntityComponent)bPos);
        }

        public void objectUnloaded(EntityId id, RigidBody<EntityId, S> body) {
            BodyPosition bPos;
            if (log.isTraceEnabled()) {
                log.trace("objectUnloaded(" + id + ", " + body + ")");
            }
            if ((bPos = (BodyPosition)BodyPositionPublisher.this.ed.getComponent(id, BodyPosition.class)) == null) {
                return;
            }
            Vec3d pos = body.shape.getWorldShapeOrigin(body);
            bPos.addFrame(this.frameTime, pos, body.orientation, false);
        }
    }
}

