/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.dnd;

import com.jme3.collision.CollisionResult;
import com.jme3.math.Vector2f;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.SafeArrayList;
import com.simsilica.lemur.dnd.DefaultDragSession;
import com.simsilica.lemur.dnd.DragAndDropListener;
import com.simsilica.lemur.dnd.DragEvent;
import com.simsilica.lemur.dnd.Draggable;
import com.simsilica.lemur.event.AbstractCursorEvent;
import com.simsilica.lemur.event.CursorButtonEvent;
import com.simsilica.lemur.event.CursorEventControl;
import com.simsilica.lemur.event.CursorListener;
import com.simsilica.lemur.event.CursorMotionEvent;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DragAndDropControl
extends AbstractControl {
    static Logger log = LoggerFactory.getLogger(DragAndDropControl.class);
    private DndControlListener listener = new DndControlListener();
    private static boolean draggingActive = false;
    private SafeArrayList<DragAndDropListener> listeners = new SafeArrayList(DragAndDropListener.class);
    private DefaultDragSession currentSession;
    private static DefaultDragSession globalSession;

    public DragAndDropControl(DragAndDropListener ... initialListeners) {
        this.listeners.addAll(Arrays.asList(initialListeners));
    }

    public void addDragAndDropListener(DragAndDropListener l) {
        this.listeners.add((Object)l);
    }

    public void removeDragAndDropListener(DragAndDropListener l) {
        this.listeners.remove((Object)l);
    }

    public void setSpatial(Spatial s) {
        if (this.getSpatial() != null) {
            this.detach(this.getSpatial());
        }
        super.setSpatial(s);
        if (s != null) {
            this.attach(s);
        }
    }

    protected void detach(Spatial s) {
        CursorEventControl.removeListenersFromSpatial((Spatial)s, (CursorListener[])new CursorListener[]{this.listener});
    }

    protected void attach(Spatial s) {
        CursorEventControl.addListenersToSpatial((Spatial)s, (CursorListener[])new CursorListener[]{this.listener});
    }

    protected DefaultDragSession getSession(AbstractCursorEvent event) {
        return globalSession;
    }

    protected DefaultDragSession clearSession(AbstractCursorEvent event) {
        DefaultDragSession result = globalSession;
        globalSession = null;
        return result;
    }

    protected boolean dragStarted(CursorButtonEvent event, CollisionResult collision, Spatial target, Spatial capture) {
        DragAndDropListener l;
        if (log.isTraceEnabled()) {
            log.trace("dragStarted(" + event + ", " + collision + ", " + target + ", " + capture + ")");
        }
        this.currentSession = new DefaultDragSession(target, new Vector2f(event.getX(), event.getY()));
        DragEvent dragEvent = new DragEvent(this.currentSession, (AbstractCursorEvent)event, collision);
        Draggable draggable = null;
        DragAndDropListener[] dragAndDropListenerArray = (DragAndDropListener[])this.listeners.getArray();
        int n = dragAndDropListenerArray.length;
        for (int i = 0; i < n && (draggable = (l = dragAndDropListenerArray[i]).onDragDetected(dragEvent)) == null; ++i) {
        }
        if (draggable == null) {
            this.currentSession = null;
            draggingActive = false;
            return false;
        }
        this.currentSession.setDraggable(draggable);
        draggingActive = true;
        globalSession = this.currentSession;
        return true;
    }

    protected void dragging(CursorMotionEvent event, Spatial target, Spatial capture) {
        DefaultDragSession session;
        if (log.isTraceEnabled()) {
            log.trace("dragging(" + event + ", " + target + ", " + capture + ")");
        }
        if ((session = this.getSession((AbstractCursorEvent)event)) == null) {
            log.warn("No session for event:" + event + "  target:" + target + "  capture:" + capture);
            return;
        }
        if (target == capture && target == this.getSpatial()) {
            session.getDraggable().setLocation(event.getX(), event.getY());
            if (event.getCollision() == null) {
                return;
            }
        }
        if (target != this.getSpatial()) {
            log.warn("Received event for different target, this spatial:" + this.getSpatial() + ", target:" + target + ", capture=" + capture);
            return;
        }
        if (target.getControl(DragAndDropControl.class) == null) {
            log.warn("Skipping target without DragAndDropControl:" + target);
            return;
        }
        DragEvent dragEvent = new DragEvent(session, (AbstractCursorEvent)event);
        if (event.getCollision() == null) {
            session.setDropTarget(null, dragEvent);
            session.setDropCollision(null);
        } else {
            session.setDropTarget(target, dragEvent);
            session.setDropCollision(dragEvent.getCollision());
            this.fireDragOver(dragEvent);
        }
    }

    protected void dragStopped(CursorButtonEvent event, CursorMotionEvent lastMotion, Spatial target, Spatial capture) {
        if (!draggingActive) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("dragStopped(" + event + ", " + target + ", " + capture + ")");
        }
        draggingActive = false;
        DefaultDragSession session = this.clearSession((AbstractCursorEvent)event);
        if (session == null) {
            log.warn("dragStopped() called with no active session, event:" + event + ", target:" + target + ", capture:" + capture);
            return;
        }
        session.close(new DragEvent(session, (AbstractCursorEvent)lastMotion, session.getDropCollision()));
    }

    protected void dragExit(CursorMotionEvent event, Spatial target, Spatial capture) {
        DefaultDragSession session = this.getSession((AbstractCursorEvent)event);
        if (session == null) {
            return;
        }
        if (session.getDropTarget() == this.getSpatial()) {
            DragEvent dragEvent = new DragEvent(session, (AbstractCursorEvent)event);
            session.setDropTarget(null, dragEvent);
        }
    }

    protected void fireEnter(DragEvent event) {
        for (DragAndDropListener l : (DragAndDropListener[])this.listeners.getArray()) {
            l.onDragEnter(event);
        }
    }

    protected void fireExit(DragEvent event) {
        for (DragAndDropListener l : (DragAndDropListener[])this.listeners.getArray()) {
            l.onDragExit(event);
        }
    }

    protected void fireDragOver(DragEvent event) {
        for (DragAndDropListener l : (DragAndDropListener[])this.listeners.getArray()) {
            l.onDragOver(event);
        }
    }

    protected void fireDrop(DragEvent event) {
        for (DragAndDropListener l : (DragAndDropListener[])this.listeners.getArray()) {
            l.onDrop(event);
        }
    }

    protected void fireDone(DragEvent event) {
        for (DragAndDropListener l : (DragAndDropListener[])this.listeners.getArray()) {
            l.onDragDone(event);
        }
    }

    protected void controlUpdate(float tpf) {
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }

    private class DndControlListener
    implements CursorListener {
        private CursorMotionEvent lastEvent;
        private CursorButtonEvent downEvent = null;
        private Spatial downTarget;
        private Spatial downCapture;
        private boolean dragDisabled;

        private DndControlListener() {
        }

        protected boolean isDownEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            return event.isPressed();
        }

        protected boolean isDragging(CursorMotionEvent event, Spatial target, Spatial capture) {
            if (this.downEvent == null) {
                return false;
            }
            return event.getX() != this.downEvent.getX() || event.getY() != this.downEvent.getY();
        }

        public void cursorButtonEvent(CursorButtonEvent event, Spatial target, Spatial capture) {
            if (log.isTraceEnabled()) {
                log.trace("cursorButton(" + event + ", " + target + ", " + capture + ")");
            }
            if (this.isDownEvent(event, target, capture)) {
                this.downEvent = event;
                this.downTarget = target;
                this.downCapture = capture;
            } else {
                DragAndDropControl.this.dragStopped(event, this.lastEvent, target, capture);
                this.downEvent = null;
                this.dragDisabled = false;
            }
        }

        public void cursorEntered(CursorMotionEvent event, Spatial target, Spatial capture) {
            if (log.isTraceEnabled()) {
                log.trace(">>>> cursorEntered(" + event + ", " + target + ", " + capture + ")");
            }
        }

        public void cursorExited(CursorMotionEvent event, Spatial target, Spatial capture) {
            if (log.isTraceEnabled()) {
                log.trace("<<<< cursorExited(" + event + ", " + target + ", " + capture + ")");
            }
            DragAndDropControl.this.dragExit(event, target, capture);
        }

        public void cursorMoved(CursorMotionEvent event, Spatial target, Spatial capture) {
            if (draggingActive) {
                DragAndDropControl.this.dragging(event, target, capture);
            } else if (!this.dragDisabled && this.isDragging(event, target, capture)) {
                if (DragAndDropControl.this.dragStarted(this.downEvent, this.lastEvent != null ? this.lastEvent.getCollision() : null, this.downTarget, this.downCapture)) {
                    DragAndDropControl.this.dragging(event, target, capture);
                } else {
                    this.dragDisabled = true;
                }
            }
            this.lastEvent = event;
        }
    }
}

