#import "Common/ShaderLib/GLSLCompat.glsllib"
#import "Common/ShaderLib/Instancing.glsllib"
#import "Common/ShaderLib/Skinning.glsllib"
#import "Common/ShaderLib/Lighting.glsllib"
#import "Common/ShaderLib/MorphAnim.glsllib"

#ifdef VERTEX_LIGHTING
    #import "Common/ShaderLib/BlinnPhongLighting.glsllib"
#endif

#import "MatDefs/ghost.glsllib"

// fog - jayfella
#ifdef USE_FOG
varying float fog_distance;
#endif

#ifdef HAS_LOCAL_LIGHTING
uniform vec4 m_LocalLighting;
varying vec3 localLightDir;
#endif

#ifdef HAS_TEXTURE_ATLAS
uniform vec2 m_TextureOffset;
uniform vec2 m_TextureScale;
#endif

// Used by fog and local lighting
uniform vec3 g_CameraPosition;

uniform vec4 m_Ambient;
uniform vec4 m_Diffuse;
uniform vec4 m_Specular;
uniform float m_Shininess;

uniform vec4 g_LightColor;
uniform vec4 g_LightPosition;
uniform vec4 g_AmbientLightColor;

varying vec2 texCoord;
#ifdef SEPARATE_TEXCOORD
  varying vec2 texCoord2;
  attribute vec2 inTexCoord2;
#endif

varying vec3 AmbientSum;
varying vec4 DiffuseSum;
varying vec3 SpecularSum;

attribute vec3 inPosition;
attribute vec2 inTexCoord;
attribute vec3 inNormal;

varying vec3 lightVec;

#ifdef VERTEX_COLOR
  attribute vec4 inColor;
#endif

#ifndef VERTEX_LIGHTING
  attribute vec4 inTangent;

  #ifndef NORMALMAP
    varying vec3 vNormal;
  #endif
  varying vec3 vViewDir;
  varying vec4 vLightDir;
#else
  varying vec2 vertexLightValues;
  uniform vec4 g_LightDirection;
#endif

#if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP))) && !defined(VERTEX_LIGHTING)
    varying vec3 vViewDirPrlx;
#endif

#ifdef USE_REFLECTION
    uniform vec3 g_CameraPosition;

    uniform vec3 m_FresnelParams;
    varying vec4 refVec;

    /**
     * Input:
     * attribute inPosition
     * attribute inNormal
     * uniform g_WorldMatrix
     * uniform g_CameraPosition
     *
     * Output:
     * varying refVec
     */
    void computeRef(in vec4 modelSpacePos){
        // vec3 worldPos = (g_WorldMatrix * modelSpacePos).xyz;
        vec3 worldPos = TransformWorld(modelSpacePos).xyz;

        vec3 I = normalize( g_CameraPosition - worldPos  ).xyz;
        // vec3 N = normalize( (g_WorldMatrix * vec4(inNormal, 0.0)).xyz );
        vec3 N = normalize( TransformWorld(vec4(inNormal, 0.0)).xyz );

        refVec.xyz = reflect(I, N);
        refVec.w   = m_FresnelParams.x + m_FresnelParams.y * pow(1.0 + dot(I, N), m_FresnelParams.z);
    }
#endif

void main(){
   vec4 modelSpacePos = vec4(inPosition, 1.0);
   vec3 modelSpaceNorm = inNormal;

   setupPostEffect(inPosition * EFFECT_SCALE);

   #ifndef VERTEX_LIGHTING
        vec3 modelSpaceTan  = inTangent.xyz;
   #endif

   #ifdef NUM_MORPH_TARGETS
        #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING)
           Morph_Compute(modelSpacePos, modelSpaceNorm, modelSpaceTan);
        #else
           Morph_Compute(modelSpacePos, modelSpaceNorm);
        #endif
   #endif

   #ifdef NUM_BONES
        #ifndef VERTEX_LIGHTING
        Skinning_Compute(modelSpacePos, modelSpaceNorm, modelSpaceTan);
        #else
        Skinning_Compute(modelSpacePos, modelSpaceNorm);
        #endif
   #endif

   gl_Position = TransformWorldViewProjection(modelSpacePos);// g_WorldViewProjectionMatrix * modelSpacePos;
   texCoord = inTexCoord;
   #ifdef HAS_TEXTURE_ATLAS
    texCoord = m_TextureOffset + texCoord * m_TextureScale;
   #endif

   #ifdef SEPARATE_TEXCOORD
      texCoord2 = inTexCoord2;
   #endif

   vec3 wvPosition = TransformWorldView(modelSpacePos).xyz;// (g_WorldViewMatrix * modelSpacePos).xyz;
   vec3 wvNormal  = normalize(TransformNormal(modelSpaceNorm));//normalize(g_NormalMatrix * modelSpaceNorm);
   vec3 viewDir = normalize(-wvPosition);

   vec4 wvLightPos = (g_ViewMatrix * vec4(g_LightPosition.xyz,clamp(g_LightColor.w,0.0,1.0)));
   wvLightPos.w = g_LightPosition.w;
   vec4 lightColor = g_LightColor;

   #if (defined(NORMALMAP) || defined(PARALLAXMAP)) && !defined(VERTEX_LIGHTING)
     vec3 wvTangent = normalize(TransformNormal(modelSpaceTan));
     vec3 wvBinormal = cross(wvNormal, wvTangent);
     mat3 tbnMat = mat3(wvTangent, wvBinormal * inTangent.w,wvNormal);
   #endif

   #if defined(NORMALMAP) && !defined(VERTEX_LIGHTING)
     vViewDir  = -wvPosition * tbnMat;
     #if (defined(PARALLAXMAP) || (defined(NORMALMAP_PARALLAX) && defined(NORMALMAP)))
         vViewDirPrlx = vViewDir;
     #endif
     lightComputeDir(wvPosition, lightColor.w, wvLightPos, vLightDir, lightVec);
     vLightDir.xyz = (vLightDir.xyz * tbnMat).xyz;
   #elif !defined(VERTEX_LIGHTING)
     vNormal = wvNormal;
     vViewDir = viewDir;
     #if defined(PARALLAXMAP)
        vViewDirPrlx  =  -wvPosition * tbnMat;
     #endif
     lightComputeDir(wvPosition, lightColor.w, wvLightPos, vLightDir, lightVec);
   #endif

   //#ifdef MATERIAL_COLORS
   //    AmbientSum  = (m_Ambient  * g_AmbientLightColor).rgb;
   //    DiffuseSum  =  m_Diffuse  * vec4(lightColor.rgb, 1.0);
   //    SpecularSum = (m_Specular * lightColor).rgb;
   //#else
   //    // Defaults: Ambient and diffuse are white, specular is black.
   //    AmbientSum  = g_AmbientLightColor.rgb;
   //    DiffuseSum  =  vec4(lightColor.rgb, 1.0);
   //    SpecularSum = vec3(0.0);
   //#endif

    //// This is the way that the mblock stuff does it... but I think it's wrong.
    // The issue is that it clears the material colors when there is no sun.
    // And while that will continue to happen for as long as we lump material
    // color into the lighting... there is no reason to do the calculation here
    // if we are already going to be separating it out in the frag shader.
    // Right now, Fayd's hair turns white unless she is in direct sun.
    //#ifdef HAS_LOCAL_LIGHTING
    //    float sunLight = m_LocalLighting.a;
    //    #ifdef MATERIAL_COLORS
    //        AmbientSum  = (m_Ambient  * g_AmbientLightColor * sunLight).rgb;
    //        DiffuseSum  =  m_Diffuse  * vec4(lightColor.rgb * sunLight, 1.0);
    //        SpecularSum = (m_Specular * lightColor).rgb * sunLight;
    //    #else
    //        // Defaults: Ambient and diffuse are white, specular is black.
    //        AmbientSum  = g_AmbientLightColor.rgb * sunLight;
    //        DiffuseSum  =  vec4(lightColor.rgb * sunLight, 1.0);
    //        SpecularSum = vec3(sunLight); //vec3(0.0);
    //    #endif
    //#else
    //    #ifdef MATERIAL_COLORS
    //        AmbientSum  = (m_Ambient  * g_AmbientLightColor).rgb;
    //        DiffuseSum  =  m_Diffuse  * vec4(lightColor.rgb, 1.0);
    //        SpecularSum = (m_Specular * lightColor).rgb;
    //    #else
    //        // Defaults: Ambient and diffuse are white, specular is black.
    //        AmbientSum  = g_AmbientLightColor.rgb;
    //        DiffuseSum  =  vec4(lightColor.rgb, 1.0);
    //        SpecularSum = vec3(0.0);
    //    #endif
    //#endif

    // We'll add the material colors in in the .frag shader as needed
    //AmbientSum  = g_AmbientLightColor.rgb;
    //DiffuseSum  =  vec4(lightColor.rgb, 1.0);
    //SpecularSum = vec3(0.0);
    // We'll try doing specular the same way mblock does now that it
    // properly deals with ambient light colors.  This means we'll also need
    // to factor sunlight into the colors because we won't in the frag and
    // we'll ignore the light-collectors for non-sunlight lighting.
    #ifdef HAS_LOCAL_LIGHTING
        float sunLight = m_LocalLighting.a;
    #else
        float sunLight = 1.0;
    #endif
    AmbientSum  = g_AmbientLightColor.rgb * sunLight;
    DiffuseSum  =  vec4(lightColor.rgb * sunLight, 1.0);
    #ifdef MATERIAL_COLORS
        // For regular lighting we'll wait to multiply in the material colors
        // until the .frag shader but specular is already calculated differently
        // and will do its own thing for local lighting.
        SpecularSum = (m_Specular * lightColor).rgb * sunLight;
    #else
        // Putting this back to black... specify material colors to get specular.
        SpecularSum = vec3(0.0);
    #endif


    #ifdef VERTEX_COLOR
      AmbientSum *= inColor.rgb;
      DiffuseSum *= inColor;
    #endif

    #ifdef VERTEX_LIGHTING
        float spotFallOff = 1.0;
        vec4 vLightDir;
        lightComputeDir(wvPosition, lightColor.w, wvLightPos, vLightDir, lightVec);
        #if __VERSION__ >= 110
            // allow use of control flow
        if(lightColor.w > 1.0){
        #endif
           spotFallOff = computeSpotFalloff(g_LightDirection, lightVec);
        #if __VERSION__ >= 110
        }
        #endif

        vertexLightValues = computeLighting(wvNormal, viewDir, vLightDir.xyz, vLightDir.w * spotFallOff, m_Shininess);
    #endif

    #ifdef USE_REFLECTION
        computeRef(modelSpacePos);
    #endif

    #if defined(USE_FOG) || defined(HAS_LOCAL_LIGHTING)
        vec3 wRelative = g_CameraPosition - (TransformWorld(modelSpacePos)).xyz;
    #endif
    #ifdef USE_FOG
        //fog_distance = distance(g_CameraPosition, (TransformWorld(modelSpacePos)).xyz);
        fog_distance = length(wRelative);
    #endif

    #ifdef HAS_LOCAL_LIGHTING
        // Calculate the local light direction as if our camera was a point light.
        // ...this still isn't quite right, I think.
        localLightDir = normalize((g_ViewMatrix * vec4(g_CameraPosition, 1.0)).xyz - wvPosition);
        //localLightDir = normalize(wRelative);
        // We want the light dir in view space not in camera space.  The direction
        // from our eye to the vertex.  And despite my comment above, it seems "right enough"
    #endif


}
