

createType("MarkerMapTool").with {

    addAction("create") { customMarker, name, world, angle ->
        //createCustomMapMarker.call(session, self, customMarker, name, world, angle);
        log.info("create(" + customMarker + ", " + name + ", " + world + ", " + angle + ")");

        TileId tileId = TileId.fromWorld(world);

        def marker = createEntity(
            new OwnedBy(resolveEntityId(activator)),
            new SpawnPosition(world, new Quatd().fromAngles(0, angle, 0)),
            new Name(name),
            customMarker
        );
    }

    addAction("update") { marker, customMarker, name, world, angle ->
        //updateCustomMapMarker.call(session, self, markerId, customMarker, name, world, angle);
        log.info("update(" + marker + ", " + customMarker + ", " + name + ", " + world + ", " + angle + ")");

        // See if we should do it.
        if( marker[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to update:" + marker);
            echo("You do not have permission to do that.");
            return;
        }

        TileId tileId = TileId.fromWorld(world);
        marker << new SpawnPosition(world, new Quatd().fromAngles(0, angle, 0));
        marker << new Name(name);
        marker << customMarker;
    }

    addAction("move") { marker, worldLoc ->
        //moveCustomMapMarker.call(session, self, markerId, worldLoc);
        log.info("move(" + marker + ", " + worldLoc + ")");

        // See if we should do it.
        if( marker[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to move:" + marker);
            echo("You do not have permission to do that.");

            // assert the position back again
            marker << marker[SpawnPosition];
            return;
        }

        def pos = marker[SpawnPosition];
        pos = new SpawnPosition(worldLoc, pos.orientation);
        marker << marker[CustomMapMarker].changePosition(worldLoc);
        marker << pos;

        //echo("Marker moved.");
    }

    addAction("delete") { marker ->
        //deleteCustomMapMarker.call(session, self, markerId);
        log.info("delete(" + marker + ")");

        // See if we should do it.
        if( marker[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to delete:" + marker);
            echo("You do not have permission to do that.");
            return;
        }
        removeEntity(marker);
    }
}


createType("LineMapTool").with {

    addAction("create") { customLine, name ->
        //createCustomMapLine.call(session, self, customLine, name);
        log.info("create(" + customLine + ", " + name + ")");

        def line = createEntity(
            new OwnedBy(resolveEntityId(activator)),
            customLine
        );

        if( name != null ) {
            line << new Name(name);
        }
    }

    addAction("update") { line, customLine, name ->
        //updateCustomMapLine.call(session, self, lineId, customLine, name);
        log.info("update(" + line + ", " + customLine + ", " + name + ")");

        // See if we should do it.
        if( line[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to update:" + line);
            echo("You do not have permission to do that.");
            return;
        }

        line << customLine;

        if( name != null ) {
            line << new Name(name);
        } else {
            line.remove(Name);
        }
    }

    addAction("move") { line, worldLoc1, worldLoc2 ->
        //moveCustomMapLine.call(session, self, lineId, worldLoc1, worldLoc2);
        log.info("move(" + line + ", " + worldLoc1 + ", " + worldLoc2 + ")");

        // See if we should do it.
        if( line[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to move:" + line);
            echo("You do not have permission to do that.");
            line << line[CustomMapLine];
            return;
        }

        def customLine = line[CustomMapLine];
        if( customLine == null ) {
            log.error("Player:" + activator + " tried to move line:" + line + " with no CustomMapLine component");
            line << line[CustomMapLine];
            echo("Error moving line.");
            return;
        }

        line << customLine.move(worldLoc1, worldLoc2);
    }

    addAction("delete") { line ->
        //deleteCustomMapLine.call(session, self, lineId);
        log.info("delete(" + line + ")");
        // See if we should do it.
        if( line[OwnedBy]?.owner != resolveEntityId(activator) ) {
            log.warn("Player:" + activator + " does not have permission to delete:" + line);
            echo("You do not have permission to do that.");
            return;
        }
        removeEntity(line);
    }
}






// Add the default map tools for players
if( true ) {

    def tools = [
        "Select":MapToolType.create("select", "/Interface/select-icon.png"),
        "Measure":MapToolType.create("measure", "/Interface/measure-icon.png"),
        "Marker":MapToolType.create("marker", "/Interface/flag-icon.png"),
        "Line":MapToolType.create("line", "/Interface/line-icon.png")
    ];

    tools.entrySet().each { entry ->
        String s = entry.key;
        def comp = entry.value;

        def existing = findEntity(ObjectName.filter(s), ObjectName.class, MapToolType.class);
        if( !existing ) {
            existing = createEntity();
        }
        existing << comp; //MapToolType.create(s, "/Interface/marker-icons.png(2,7)", entityData);
        existing << ObjectName.create(s);
        existing << ObjectTypeInfo.create(s + "MapTool");
    }

    // Icon set defined by markers that are owned by the world entity
    def parent = worldManager.worldEntity;

    // Delete the existing icon set
    findEntities(OwnedBy.filter(parent), OwnedBy.class, CustomMapMarker.class).each {
        log.info("Removing icon:" + it[CustomMapMarker]);
        removeEntity(it);
    }

    def loc = new Vec3d(0,0,0);
    def icons = [
        "a) X":CustomMapMarker.create("/Interface/marker-icons.png(2,7)", 0, 0, loc),
        "b) Star":CustomMapMarker.create("/Interface/marker-icons.png(3,7)", 0, 0, loc),
        "c) House":CustomMapMarker.create("/Interface/marker-icons.png(3,6)", 0, 0, loc),
        "d) Henge":CustomMapMarker.create("/Interface/marker-icons.png(4,6)", 0, 0, loc),
        "e) Arch":CustomMapMarker.create("/Interface/marker-icons.png(1,6)", 0, 0, loc),
        "f) Castle":CustomMapMarker.create("/Interface/marker-icons.png(2,6)", 0, 0, loc),
        "g) Dungeon":CustomMapMarker.create("/Interface/marker-icons.png(0,6)", 0, 0, loc),
        "h) Paw Print":CustomMapMarker.create("/Interface/marker-icons.png(1,7)", 0, 0, loc),
        "i) Leaf":CustomMapMarker.create("/Interface/marker-icons.png(4,7)", 0, 0, loc),
        "j) Apple":CustomMapMarker.create("/Interface/marker-icons.png(0,7)", 0, 0, loc),
        "k) Meat":CustomMapMarker.create("/Interface/marker-icons.png(5,7)", 0, 0, loc),
        "l) Potion":CustomMapMarker.create("/Interface/marker-icons.png(6,7)", 0, 0, loc),
        "m) Bottle":CustomMapMarker.create("/Interface/marker-icons.png(7,7)", 0, 0, loc)
    ]

    icons.entrySet().each { entry ->
        String s = entry.key;
        def comp = entry.value;

        def criteria = new EntityCriteria();
        criteria.add(OwnedBy.filter(parent));
        criteria.add(ObjectName.filter(s));
        criteria.add(CustomMapMarker.class);

        def existing = findEntity2(criteria);
        if( !existing ) {
            existing = createEntity();
        }

        existing << comp;
        existing << ObjectName.create(s);
        existing << new OwnedBy(parent);
    }

    def end1 = new Vec3d(0, -1, 0);
    def end2 = new Vec3d(1, -1, 0);
    def lines = [
        "Thin":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,7)", entityData),
        "Thick":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,6)", entityData),
        "Double":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,5)", entityData),
        "Chain":CustomMapLine.create(end1, end2, "/Interface/line-styles.png(0,4)", entityData)
    ]

    lines.entrySet().each { entry ->
        String s = entry.key;
        def comp = entry.value;

        def criteria = new EntityCriteria();
        criteria.add(OwnedBy.filter(parent));
        criteria.add(ObjectName.filter(s));
        criteria.add(CustomMapLine.class);

        def existing = findEntity2(criteria);
        if( !existing ) {
            existing = createEntity();
        }

        existing << comp;
        existing << ObjectName.create(s);
        existing << new OwnedBy(parent);
    }
}

