/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.effect;

import com.jme3.effect.Particle;
import com.jme3.effect.ParticleEmitter;
import com.jme3.effect.ParticleMesh;
import com.jme3.math.FastMath;
import com.jme3.math.Matrix3f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.scene.Mesh;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.TempVars;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class ParticleTriMesh
extends ParticleMesh {
    private int imagesX = 1;
    private int imagesY = 1;
    private boolean uniqueTexCoords = false;
    private ParticleEmitter emitter;

    @Override
    public void initParticleData(ParticleEmitter emitter, int numParticles) {
        this.setMode(Mesh.Mode.Triangles);
        this.emitter = emitter;
        FloatBuffer pb = BufferUtils.createVector3Buffer(numParticles * 4);
        VertexBuffer buf = this.getBuffer(VertexBuffer.Type.Position);
        if (buf != null) {
            buf.updateData(pb);
        } else {
            VertexBuffer pvb = new VertexBuffer(VertexBuffer.Type.Position);
            pvb.setupData(VertexBuffer.Usage.Stream, 3, VertexBuffer.Format.Float, pb);
            this.setBuffer(pvb);
        }
        ByteBuffer cb = BufferUtils.createByteBuffer(numParticles * 4 * 4);
        buf = this.getBuffer(VertexBuffer.Type.Color);
        if (buf != null) {
            buf.updateData(cb);
        } else {
            VertexBuffer cvb = new VertexBuffer(VertexBuffer.Type.Color);
            cvb.setupData(VertexBuffer.Usage.Stream, 4, VertexBuffer.Format.UnsignedByte, cb);
            cvb.setNormalized(true);
            this.setBuffer(cvb);
        }
        FloatBuffer tb = BufferUtils.createVector2Buffer(numParticles * 4);
        this.uniqueTexCoords = false;
        for (int i = 0; i < numParticles; ++i) {
            tb.put(0.0f).put(1.0f);
            tb.put(1.0f).put(1.0f);
            tb.put(0.0f).put(0.0f);
            tb.put(1.0f).put(0.0f);
        }
        tb.flip();
        buf = this.getBuffer(VertexBuffer.Type.TexCoord);
        if (buf != null) {
            buf.updateData(tb);
        } else {
            VertexBuffer tvb = new VertexBuffer(VertexBuffer.Type.TexCoord);
            tvb.setupData(VertexBuffer.Usage.Static, 2, VertexBuffer.Format.Float, tb);
            this.setBuffer(tvb);
        }
        ShortBuffer ib = BufferUtils.createShortBuffer(numParticles * 6);
        for (int i = 0; i < numParticles; ++i) {
            int startIdx = i * 4;
            ib.put((short)(startIdx + 1)).put((short)(startIdx + 0)).put((short)(startIdx + 2));
            ib.put((short)(startIdx + 1)).put((short)(startIdx + 2)).put((short)(startIdx + 3));
        }
        ib.flip();
        buf = this.getBuffer(VertexBuffer.Type.Index);
        if (buf != null) {
            buf.updateData(ib);
        } else {
            VertexBuffer ivb = new VertexBuffer(VertexBuffer.Type.Index);
            ivb.setupData(VertexBuffer.Usage.Static, 3, VertexBuffer.Format.UnsignedShort, ib);
            this.setBuffer(ivb);
        }
        this.updateCounts();
    }

    @Override
    public void setImagesXY(int imagesX, int imagesY) {
        this.imagesX = imagesX;
        this.imagesY = imagesY;
        if (imagesX != 1 || imagesY != 1) {
            this.uniqueTexCoords = true;
            this.getBuffer(VertexBuffer.Type.TexCoord).setUsage(VertexBuffer.Usage.Stream);
        }
    }

    @Override
    public void updateParticleData(Particle[] particles, Camera cam, Matrix3f inverseRotation) {
        VertexBuffer pvb = this.getBuffer(VertexBuffer.Type.Position);
        FloatBuffer positions = (FloatBuffer)pvb.getData();
        VertexBuffer cvb = this.getBuffer(VertexBuffer.Type.Color);
        ByteBuffer colors = (ByteBuffer)cvb.getData();
        VertexBuffer tvb = this.getBuffer(VertexBuffer.Type.TexCoord);
        FloatBuffer texcoords = (FloatBuffer)tvb.getData();
        Vector3f camUp = cam.getUp();
        Vector3f camLeft = cam.getLeft();
        Vector3f camDir = cam.getDirection();
        inverseRotation.multLocal(camUp);
        inverseRotation.multLocal(camLeft);
        inverseRotation.multLocal(camDir);
        boolean facingVelocity = this.emitter.isFacingVelocity();
        Vector3f up = new Vector3f();
        Vector3f left = new Vector3f();
        if (!facingVelocity) {
            up.set(camUp);
            left.set(camLeft);
        }
        positions.clear();
        colors.clear();
        texcoords.clear();
        Vector3f faceNormal = this.emitter.getFaceNormal();
        for (int i = 0; i < particles.length; ++i) {
            boolean dead;
            Particle p = particles[i];
            boolean bl = dead = p.life == 0.0f;
            if (dead) {
                positions.put(0.0f).put(0.0f).put(0.0f);
                positions.put(0.0f).put(0.0f).put(0.0f);
                positions.put(0.0f).put(0.0f).put(0.0f);
                positions.put(0.0f).put(0.0f).put(0.0f);
                continue;
            }
            if (facingVelocity) {
                left.set(p.velocity).normalizeLocal();
                camDir.cross(left, up);
                up.multLocal(p.size);
                left.multLocal(p.size);
            } else if (faceNormal != null) {
                up.set(faceNormal).crossLocal(Vector3f.UNIT_X);
                faceNormal.cross(up, left);
                up.multLocal(p.size);
                left.multLocal(p.size);
                if (p.angle != 0.0f) {
                    TempVars vars = TempVars.get();
                    vars.vect1.set(faceNormal).normalizeLocal();
                    vars.quat1.fromAngleNormalAxis(p.angle, vars.vect1);
                    vars.quat1.multLocal(left);
                    vars.quat1.multLocal(up);
                    vars.release();
                }
            } else if (p.angle != 0.0f) {
                float cos = FastMath.cos(p.angle) * p.size;
                float sin = FastMath.sin(p.angle) * p.size;
                left.x = camLeft.x * cos + camUp.x * sin;
                left.y = camLeft.y * cos + camUp.y * sin;
                left.z = camLeft.z * cos + camUp.z * sin;
                up.x = camLeft.x * -sin + camUp.x * cos;
                up.y = camLeft.y * -sin + camUp.y * cos;
                up.z = camLeft.z * -sin + camUp.z * cos;
            } else {
                up.set(camUp);
                left.set(camLeft);
                up.multLocal(p.size);
                left.multLocal(p.size);
            }
            positions.put(p.position.x + left.x + up.x).put(p.position.y + left.y + up.y).put(p.position.z + left.z + up.z);
            positions.put(p.position.x - left.x + up.x).put(p.position.y - left.y + up.y).put(p.position.z - left.z + up.z);
            positions.put(p.position.x + left.x - up.x).put(p.position.y + left.y - up.y).put(p.position.z + left.z - up.z);
            positions.put(p.position.x - left.x - up.x).put(p.position.y - left.y - up.y).put(p.position.z - left.z - up.z);
            if (this.uniqueTexCoords) {
                int imgX = p.imageIndex % this.imagesX;
                int imgY = p.imageIndex / this.imagesX;
                float startX = (float)imgX / (float)this.imagesX;
                float startY = (float)imgY / (float)this.imagesY;
                float endX = startX + 1.0f / (float)this.imagesX;
                float endY = startY + 1.0f / (float)this.imagesY;
                texcoords.put(startX).put(endY);
                texcoords.put(endX).put(endY);
                texcoords.put(startX).put(startY);
                texcoords.put(endX).put(startY);
            }
            int abgr = p.color.asIntABGR();
            colors.putInt(abgr);
            colors.putInt(abgr);
            colors.putInt(abgr);
            colors.putInt(abgr);
        }
        positions.clear();
        colors.clear();
        if (!this.uniqueTexCoords) {
            texcoords.clear();
        } else {
            texcoords.clear();
            tvb.updateData(texcoords);
        }
        pvb.updateData(positions);
        cvb.updateData(colors);
    }
}

