/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.input.controls;

import com.jme3.input.controls.Trigger;

public class MouseButtonTrigger
implements Trigger {
    private final int mouseButton;

    public MouseButtonTrigger(int mouseButton) {
        if (mouseButton < 0) {
            throw new IllegalArgumentException("Mouse Button cannot be negative");
        }
        this.mouseButton = mouseButton;
    }

    public int getMouseButton() {
        return this.mouseButton;
    }

    @Override
    public String getName() {
        return "Mouse Button " + this.mouseButton;
    }

    public static int mouseButtonHash(int mouseButton) {
        assert (mouseButton >= 0 && mouseButton <= 255);
        return 0x100 | mouseButton & 0xFF;
    }

    @Override
    public int triggerHashCode() {
        return MouseButtonTrigger.mouseButtonHash(this.mouseButton);
    }
}

