/*
 * Decompiled with CFR 0.152.
 */
package mythruna.world;

import com.simsilica.fractal.AbstractSampler;
import com.simsilica.fractal.CellularFilter;
import com.simsilica.fractal.CellularNoise;
import com.simsilica.fractal.FractalSum;
import com.simsilica.fractal.FractalUtils;
import com.simsilica.fractal.InvertedCellularNoise;
import com.simsilica.fractal.PerlinNoise;
import com.simsilica.fractal.RidgeFractal;
import com.simsilica.fractal.Sampler;
import com.simsilica.fractal.Samplers;
import com.simsilica.mathd.Vec3d;
import java.util.Arrays;
import java.util.List;
import mythruna.world.DefaultWorldFractal;
import mythruna.world.WorldFractal;
import mythruna.world.WorldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyWorldFractalFactory {
    static Logger log = LoggerFactory.getLogger(LegacyWorldFractalFactory.class);
    private static String[] fractalTypes = new String[]{"default", "default2", "sample", "sine", "flat"};

    public static List<String> getFractalTypes() {
        return Arrays.asList(fractalTypes);
    }

    public static WorldFractal create(WorldInfo info) {
        switch (info.getFractalName()) {
            case "sine": {
                return LegacyWorldFractalFactory.sineWaves(info.getSeed());
            }
            case "sample": {
                return LegacyWorldFractalFactory.createSample(info.getSeed());
            }
            case "flat": {
                return LegacyWorldFractalFactory.createFlat(info.getSeed());
            }
            case "default": {
                return LegacyWorldFractalFactory.createDefault(info.getSeed(), false);
            }
        }
        return LegacyWorldFractalFactory.createDefault(info.getSeed(), true);
    }

    public static WorldFractal sineWaves(long seed) {
        AbstractSampler elevation;
        Sampler resampled;
        Sampler sinX = Samplers.sin((Sampler)Samplers.dot((Vec3d)Vec3d.UNIT_X));
        Sampler sinZ = Samplers.sin((Sampler)Samplers.dot((Vec3d)Vec3d.UNIT_Z));
        Sampler combined = Samplers.mult((Sampler)sinX, (Sampler)sinZ);
        Sampler pow = Samplers.mult((Sampler)combined, (Sampler)combined);
        pow = Samplers.mult((Sampler)pow, (Sampler)combined);
        double width = 256L * seed;
        final Sampler base = resampled = Samplers.resample((Sampler)pow, (double)(Math.PI / width), (double)1.0, (double)(Math.PI / width));
        AbstractSampler estimated = elevation = new AbstractSampler(0.0, 512.0){

            public double getSample(double x, double y, double z) {
                double e = base.getSample(x, y, z);
                e = e < 0.0 ? (e *= 128.0) : (e *= 512.0);
                return e + 128.0;
            }

            public String toString() {
                return "ElevationRemapping[]";
            }
        };
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double wetnessWidth = 16384.0;
        double wetnessHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)new PerlinNoise(seed + 1L), (double)(1.0 / wetnessWidth), (double)0.0, (double)(1.0 / wetnessHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)unnormalizedWetness, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        Sampler veg3 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        Object veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg, (Sampler)veg3), (double)0.5);
        final Sampler vegBase = veg = Samplers.add((Sampler)veg, (Sampler)Samplers.scale((Sampler)unnormalizedWetness, (double)0.5));
        double snowLine = 500.0;
        double treeLine = 500.0;
        double deepWater = -100.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 500.0) {
                    return 0.0;
                }
                if (height < -100.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[500.0, 500.0, -100.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)0.0);
        return new DefaultWorldFractal((Sampler)estimated, (Sampler)elevation, waterLevel, temperature, weather, (Sampler)veg, null);
    }

    public static WorldFractal createFlat(long seed) {
        Sampler elevation;
        seed = Math.min(672L, Math.max(1L, seed));
        Sampler estimated = elevation = Samplers.constant((double)seed);
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        Sampler resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double wetnessWidth = 16384.0;
        double wetnessHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)new PerlinNoise(seed + 1L), (double)(1.0 / wetnessWidth), (double)0.0, (double)(1.0 / wetnessHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)unnormalizedWetness, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        Sampler veg3 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        Object veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg, (Sampler)veg3), (double)0.5);
        final Sampler vegBase = veg = Samplers.add((Sampler)veg, (Sampler)Samplers.scale((Sampler)unnormalizedWetness, (double)0.5));
        double snowLine = 500.0;
        double treeLine = 500.0;
        double deepWater = -100.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 500.0) {
                    return 0.0;
                }
                if (height < -100.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[500.0, 500.0, -100.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)0.0);
        return new DefaultWorldFractal(estimated, elevation, waterLevel, temperature, weather, (Sampler)veg, null);
    }

    public static WorldFractal createSample(long seed) {
        Object veg;
        PerlinNoise noise1 = new PerlinNoise(seed);
        PerlinNoise noise2 = new PerlinNoise(seed + 1L);
        FractalSum fractal1 = new FractalSum((Sampler)noise1);
        fractal1.setFrequencyIterations(2);
        FractalSum fractal2 = new FractalSum((Sampler)noise2);
        fractal2.setFrequencyIterations(2);
        Sampler resampled = Samplers.resample((Sampler)fractal1, (double)2.44140625E-4, (double)1.0, (double)2.44140625E-4);
        Sampler resampled2 = Samplers.resample((Sampler)fractal2, (double)2.44140625E-4, (double)1.0, (double)2.44140625E-4);
        resampled = Samplers.add((Sampler)resampled, (Sampler)resampled2);
        double raiseWidth = 40096.0;
        double raiseHeight = 40096.0;
        Sampler raise = Samplers.resample((Sampler)noise1, (double)(1.0 / raiseWidth), (double)1.0, (double)(1.0 / raiseHeight));
        raise = Samplers.subtract((Sampler)raise, (Sampler)Samplers.constant((double)0.1));
        resampled = Samplers.add((Sampler)resampled, (Sampler)Samplers.scale((Sampler)raise, (double)3.0));
        Sampler estimatedElevation = Samplers.scale((Sampler)resampled, (double)200.0);
        FractalSum bumpier = new FractalSum((Sampler)noise1, 8);
        bumpier = Samplers.resample((Sampler)bumpier, (double)9.765625E-4, (double)1.0, (double)9.761811792268644E-4);
        bumpier = Samplers.scale((Sampler)bumpier, (double)150.0);
        Sampler elevation = Samplers.add((Sampler)estimatedElevation, (Sampler)bumpier);
        elevation = Samplers.clamp((Sampler)elevation, (double)-188.0, (double)1000.0);
        elevation = Samplers.reflect((Sampler)elevation, (double)-128.0, (double)512.0);
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        resampled = Samplers.resample((Sampler)noise1, (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double weatherWidth = 16384.0;
        double weatherHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)noise2, (double)(1.0 / weatherWidth), (double)0.0, (double)(1.0 / weatherHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        Sampler veg3 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        final Sampler vegBase = veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        double snowLine = 500.0;
        double treeLine = 500.0;
        double deepWater = -100.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 500.0) {
                    return 0.0;
                }
                if (height < -100.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[500.0, -100.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)128.0);
        estimatedElevation = Samplers.add((Sampler)estimatedElevation, (Sampler)waterLevel);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        elevation = Samplers.add((Sampler)elevation, (Sampler)waterLevel);
        return new DefaultWorldFractal(estimatedElevation, elevation, waterLevel, temperature, weather, (Sampler)veg, null);
    }

    public static WorldFractal createDefault(long seed, boolean plateaus) {
        Object veg;
        AbstractSampler terrain;
        AbstractSampler elevation;
        PerlinNoise noise;
        PerlinNoise noise1 = noise = new PerlinNoise(seed);
        PerlinNoise noise2 = new PerlinNoise(seed + 1L);
        AbstractSampler estimated = elevation = (terrain = new AbstractSampler(-128.0, 640.0, (Sampler)noise1, (Sampler)noise2, seed, plateaus){
            private Sampler fractal1x2;
            private Sampler fractal1x3;
            private Sampler fractal1x4;
            private Sampler fractal1x5;
            private Sampler fractal1x6;
            private Sampler fractal1x8;
            private Sampler fractal2x2;
            private RidgeFractal ridgeFractal1x6;
            private RidgeFractal ridgeFractal2x6;
            private long cellSeed;
            private Sampler cellNoise;
            private Sampler invCellNoise;
            private Sampler sparse;
            private Sampler sparse2;
            private Sampler scaledFractal1x2;
            private Sampler platFilter;
            double jitterFrequency;
            Sampler noiseJitter1;
            Sampler noiseJitter2;
            Sampler testSampler;
            Sampler cracked;
            final /* synthetic */ Sampler val$noise1;
            final /* synthetic */ Sampler val$noise2;
            final /* synthetic */ long val$seed;
            final /* synthetic */ boolean val$plateaus;
            {
                Sampler cracks;
                this.val$noise1 = sampler;
                this.val$noise2 = sampler2;
                this.val$seed = l;
                this.val$plateaus = bl;
                super(arg0, arg1);
                this.fractal1x2 = new FractalSum(this.val$noise1, 2);
                this.fractal1x3 = new FractalSum(this.val$noise1, 3);
                this.fractal1x4 = new FractalSum(this.val$noise1, 4);
                this.fractal1x5 = new FractalSum(this.val$noise1, 5);
                this.fractal1x6 = new FractalSum(this.val$noise1, 6);
                this.fractal1x8 = new FractalSum(this.val$noise1, 8);
                this.fractal2x2 = new FractalSum(this.val$noise2, 2);
                this.ridgeFractal1x6 = new RidgeFractal(this.val$noise1);
                this.ridgeFractal2x6 = new RidgeFractal(this.val$noise2);
                this.cellSeed = this.val$seed;
                this.cellNoise = new CellularNoise(this.cellSeed);
                this.invCellNoise = new InvertedCellularNoise(this.cellSeed, true);
                this.sparse = new CellularNoise(this.cellSeed);
                this.sparse2 = new InvertedCellularNoise(this.cellSeed, true);
                this.scaledFractal1x2 = Samplers.scale((Sampler)Samplers.resample((Sampler)this.fractal1x2, (double)0.25, (double)1.0, (double)0.25), (double)8.0);
                this.platFilter = new CellularFilter(this.cellSeed, this.scaledFractal1x2);
                this.jitterFrequency = 0.2;
                this.noiseJitter1 = Samplers.resample((Sampler)this.val$noise1, (double)this.jitterFrequency, (double)1.0, (double)this.jitterFrequency);
                this.noiseJitter2 = Samplers.resample((Sampler)this.val$noise2, (double)this.jitterFrequency, (double)1.0, (double)this.jitterFrequency);
                InvertedCellularNoise cells = new InvertedCellularNoise(this.cellSeed, true);
                cells = Samplers.smoothStep((double)0.1, (double)0.25, (Sampler)cells);
                CellularFilter cellFilter = new CellularFilter(this.cellSeed, this.fractal1x2);
                cellFilter = Samplers.reflect((Sampler)cellFilter, (double)0.3, (double)1.0);
                Sampler cellsResampled = Samplers.resample((Sampler)Samplers.mult((Sampler)cells, (Sampler)cellFilter), (double)0.001953125, (double)1.0, (double)0.001953125);
                cellsResampled = Samplers.offset((Sampler)cellsResampled, (Sampler)Samplers.scale((Sampler)this.noiseJitter1, (double)5.0), (Sampler)Samplers.constant((double)0.0), (Sampler)Samplers.scale((Sampler)this.noiseJitter2, (double)5.0));
                Sampler cells2 = Samplers.smoothStep((double)0.01, (double)0.02, (Sampler)new InvertedCellularNoise(this.cellSeed, true));
                Sampler bigCracks = Samplers.resample((Sampler)cells2, (double)0.00390625, (double)1.0, (double)0.00390625);
                bigCracks = Samplers.subtract((Sampler)Samplers.constant((double)1.0), (Sampler)bigCracks);
                Sampler smallerCracks = Samplers.resample((Sampler)cells2, (double)0.015625, (double)1.0, (double)0.015625);
                smallerCracks = Samplers.subtract((Sampler)Samplers.constant((double)1.0), (Sampler)smallerCracks);
                Sampler invertedCracks = cracks = Samplers.max((Sampler)smallerCracks, (Sampler)bigCracks);
                Sampler crackNoise = Samplers.resample((Sampler)this.fractal1x2, (double)0.015625, (double)1.0, (double)0.015625);
                crackNoise = Samplers.scale((Sampler)Samplers.add((Sampler)crackNoise, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
                invertedCracks = Samplers.mult((Sampler)invertedCracks, (Sampler)crackNoise);
                invertedCracks = Samplers.mult((Sampler)invertedCracks, (Sampler)cellsResampled);
                CellularFilter cellFilter2 = new CellularFilter(this.cellSeed, this.fractal1x2);
                Sampler cellFilterResampled = Samplers.resample((Sampler)cellFilter2, (double)0.00390625, (double)1.0, (double)0.00390625);
                this.testSampler = cellFilterResampled = Samplers.offset((Sampler)cellFilterResampled, (Sampler)Samplers.scale((Sampler)this.noiseJitter1, (double)3.0), (Sampler)Samplers.constant((double)0.0), (Sampler)Samplers.scale((Sampler)this.noiseJitter2, (double)3.0));
                this.cracked = Samplers.add((Sampler[])new Sampler[]{Samplers.scale((Sampler)cellsResampled, (double)170.66666666666666), Samplers.scale((Sampler)cellFilterResampled, (double)42.666666666666664), Samplers.scale((Sampler)invertedCracks, (double)-34.13333333333333)});
            }

            public double getSample(double x, double y, double z) {
                double f3 = this.fractal1x8.getSample(x / 8096.0, y, z / 8096.0);
                double raise = this.val$noise1.getSample(x / 40096.0, y, z / 40096.0);
                f3 += (raise -= 0.1) * 3.0;
                if ((f3 *= 0.25) < -1.0) {
                    f3 = -1.0;
                } else if (f3 > 1.0) {
                    f3 = 1.0;
                }
                double unscaledContinents = f3;
                double xLarge = x / 8192.0;
                double zLarge = z / 8192.0;
                double f1 = this.fractal1x2.getSample(xLarge, y, zLarge);
                double f2 = this.fractal2x2.getSample(xLarge, y, zLarge);
                double mix1 = FractalUtils.smoothStep((double)-0.005, (double)0.1, (double)(f1 * f2));
                double xJitter = (x + this.noiseJitter1.getSample(x, y, z) * 5.0) / 2000.0;
                double zJitter = (z + this.noiseJitter2.getSample(x, y, z) * 5.0) / 2000.0;
                double sp1 = 0.0;
                boolean fast = this.val$plateaus;
                double fCheck = 0.0;
                if (fast) {
                    fCheck = this.scaledFractal1x2.getSample(xJitter, y, zJitter);
                    fCheck = FractalUtils.smoothStep((double)1.9, (double)2.0, (double)fCheck);
                }
                if (fCheck > 0.0) {
                    double sp2 = this.sparse2.getSample(xJitter, y, zJitter);
                    if ((sp2 = FractalUtils.smoothStep((double)0.0, (double)0.1, (double)sp2)) != 0.0) {
                        sp1 = 1.0 - this.sparse.getSample(xJitter, y, zJitter);
                        sp1 += this.platFilter.getSample(xJitter, y, zJitter);
                        sp1 = FractalUtils.step((double)4.0, (double)sp1);
                        sp1 = sp1 * sp2 * fCheck;
                    }
                }
                double m2 = sp1;
                double m1 = mix1;
                double uScaledContinents = unscaledContinents;
                double cSquared = FractalUtils.reslope((double)uScaledContinents, (double)2.0, (double)0.005, (double)0.8);
                cSquared *= 512.0;
                double uContinentsCut = FractalUtils.smoothStep((double)-0.11, (double)-0.1, (double)uScaledContinents);
                m1 *= uContinentsCut;
                double uRollingHills = this.fractal1x4.getSample(x / 512.0, y, z / 512.0);
                double rHills = uRollingHills * 50.0;
                double nrh = uRollingHills;
                if (nrh < -512.0) {
                    nrh = -512.0;
                } else if (nrh > 0.0) {
                    nrh = 0.0;
                }
                double uc = unscaledContinents;
                if (uc < 0.0) {
                    uc = 0.0;
                } else if (uc > 1.0) {
                    uc = 1.0;
                }
                double nScale = uc * uc;
                nrh = nrh * nScale * 500.0;
                double mountains = 0.0;
                if (m1 != 0.0) {
                    double mounts = this.fractal1x8.getSample(x / 2048.0, y, z / 2048.0);
                    mountains = mounts *= 512.0 * m1;
                }
                double mesas = 0.0;
                if (m2 != 0.0) {
                    mesas = this.cracked.getSample(x, y, z) * m2;
                }
                double r4 = nrh;
                double rFinal = Math.max(mountains, mesas);
                rFinal = Math.max(rHills, rFinal);
                double v1 = cSquared;
                double v2 = rFinal += r4;
                double result = v1 + v2;
                double ridges = 0.0;
                double ridgeFactor = 1.0;
                if (ridgeFactor > 0.0) {
                    double ridgeInput = result / 512.0;
                    ridges = this.ridgeFractal2x6.getSample(x / 2048.0, ridgeInput, z / 2048.0);
                    ridges = (ridges /= 1.6) > 0.2 ? (ridges - 0.2) / 0.8 : 0.0;
                    ridges *= ridges;
                    ridges *= ridges;
                    double ridgeScale = 0.0;
                    if (result > -4.0) {
                        if (result <= 0.0) {
                            ridgeScale = 4.0;
                        } else {
                            double maxRidge = 100.0;
                            ridgeScale = 4.0 + Math.min(maxRidge, maxRidge * (result / 20.0));
                        }
                    } else if (result > -5.0) {
                        ridgeScale = result - -5.0;
                        ridgeScale = 1.0 + ridgeScale * 4.0;
                    } else {
                        ridgeScale = Math.min(1.0, (result + 5.0) / -100.0) * 90.0;
                    }
                    result += ridges * ridgeFactor * ridgeScale;
                }
                if (result > 512.0) {
                    offset = result - 512.0;
                    result = 512.0 - offset;
                } else if (result < -128.0) {
                    offset = result + 128.0;
                    result = -(128.0 + offset);
                }
                return result;
            }

            public String toString() {
                return "DefaultTerrainFractal[plateaus=" + this.val$plateaus + "]";
            }
        });
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        Sampler resampled = Samplers.resample((Sampler)noise1, (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double weatherWidth = 16384.0;
        double weatherHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)noise2, (double)(1.0 / weatherWidth), (double)0.0, (double)(1.0 / weatherHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        final Sampler vegBase = veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        double snowLine = 618.0;
        double treeLine = 618.0;
        double deepWater = 28.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 618.0) {
                    return 0.0;
                }
                if (height < 28.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[618.0, 28.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)128.0);
        Sampler estimatedElevation = Samplers.add((Sampler)estimated, (Sampler)waterLevel);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        elevation = Samplers.clamp((Sampler)Samplers.add((Sampler)elevation, (Sampler)waterLevel), (double)0.0, (double)640.0);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        return new DefaultWorldFractal(estimatedElevation, (Sampler)elevation, waterLevel, temperature, weather, (Sampler)veg, null);
    }

    public static WorldFractal createDefaultOlder(long seed, boolean plateaus) {
        Object veg;
        AbstractSampler terrain;
        AbstractSampler elevation;
        PerlinNoise noise;
        PerlinNoise noise1 = noise = new PerlinNoise(seed);
        PerlinNoise noise2 = new PerlinNoise(seed + 1L);
        AbstractSampler estimated = elevation = (terrain = new AbstractSampler(-128.0, 640.0, (Sampler)noise1, (Sampler)noise2, seed, plateaus){
            private Sampler fractal1x2;
            private Sampler fractal1x3;
            private Sampler fractal1x4;
            private Sampler fractal1x5;
            private Sampler fractal1x6;
            private Sampler fractal2x2;
            private long cellSeed;
            private Sampler cellNoise;
            private Sampler invCellNoise;
            private Sampler sparse;
            private Sampler sparse2;
            private Sampler scaledFractal1x2;
            private Sampler platFilter;
            double jitterFrequency;
            Sampler noiseJitter1;
            Sampler noiseJitter2;
            Sampler testSampler;
            Sampler cracked;
            final /* synthetic */ Sampler val$noise1;
            final /* synthetic */ Sampler val$noise2;
            final /* synthetic */ long val$seed;
            final /* synthetic */ boolean val$plateaus;
            {
                Sampler cracks;
                this.val$noise1 = sampler;
                this.val$noise2 = sampler2;
                this.val$seed = l;
                this.val$plateaus = bl;
                super(arg0, arg1);
                this.fractal1x2 = new FractalSum(this.val$noise1, 2);
                this.fractal1x3 = new FractalSum(this.val$noise1, 3);
                this.fractal1x4 = new FractalSum(this.val$noise1, 4);
                this.fractal1x5 = new FractalSum(this.val$noise1, 5);
                this.fractal1x6 = new FractalSum(this.val$noise1, 6);
                this.fractal2x2 = new FractalSum(this.val$noise2, 2);
                this.cellSeed = this.val$seed;
                this.cellNoise = new CellularNoise(this.cellSeed);
                this.invCellNoise = new InvertedCellularNoise(this.cellSeed, true);
                this.sparse = new CellularNoise(this.cellSeed);
                this.sparse2 = new InvertedCellularNoise(this.cellSeed, true);
                this.scaledFractal1x2 = Samplers.scale((Sampler)Samplers.resample((Sampler)this.fractal1x2, (double)0.25, (double)1.0, (double)0.25), (double)8.0);
                this.platFilter = new CellularFilter(this.cellSeed, this.scaledFractal1x2);
                this.jitterFrequency = 0.2;
                this.noiseJitter1 = Samplers.resample((Sampler)this.val$noise1, (double)this.jitterFrequency, (double)1.0, (double)this.jitterFrequency);
                this.noiseJitter2 = Samplers.resample((Sampler)this.val$noise2, (double)this.jitterFrequency, (double)1.0, (double)this.jitterFrequency);
                InvertedCellularNoise cells = new InvertedCellularNoise(this.cellSeed, true);
                cells = Samplers.smoothStep((double)0.1, (double)0.25, (Sampler)cells);
                CellularFilter cellFilter = new CellularFilter(this.cellSeed, this.fractal1x2);
                cellFilter = Samplers.reflect((Sampler)cellFilter, (double)0.3, (double)1.0);
                Sampler cellsResampled = Samplers.resample((Sampler)Samplers.mult((Sampler)cells, (Sampler)cellFilter), (double)0.001953125, (double)1.0, (double)0.001953125);
                cellsResampled = Samplers.offset((Sampler)cellsResampled, (Sampler)Samplers.scale((Sampler)this.noiseJitter1, (double)5.0), (Sampler)Samplers.constant((double)0.0), (Sampler)Samplers.scale((Sampler)this.noiseJitter2, (double)5.0));
                Sampler cells2 = Samplers.smoothStep((double)0.01, (double)0.02, (Sampler)new InvertedCellularNoise(this.cellSeed, true));
                Sampler bigCracks = Samplers.resample((Sampler)cells2, (double)0.00390625, (double)1.0, (double)0.00390625);
                bigCracks = Samplers.subtract((Sampler)Samplers.constant((double)1.0), (Sampler)bigCracks);
                Sampler smallerCracks = Samplers.resample((Sampler)cells2, (double)0.015625, (double)1.0, (double)0.015625);
                smallerCracks = Samplers.subtract((Sampler)Samplers.constant((double)1.0), (Sampler)smallerCracks);
                Sampler invertedCracks = cracks = Samplers.max((Sampler)smallerCracks, (Sampler)bigCracks);
                Sampler crackNoise = Samplers.resample((Sampler)this.fractal1x2, (double)0.015625, (double)1.0, (double)0.015625);
                crackNoise = Samplers.scale((Sampler)Samplers.add((Sampler)crackNoise, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
                invertedCracks = Samplers.mult((Sampler)invertedCracks, (Sampler)crackNoise);
                invertedCracks = Samplers.mult((Sampler)invertedCracks, (Sampler)cellsResampled);
                CellularFilter cellFilter2 = new CellularFilter(this.cellSeed, this.fractal1x2);
                Sampler cellFilterResampled = Samplers.resample((Sampler)cellFilter2, (double)0.00390625, (double)1.0, (double)0.00390625);
                this.testSampler = cellFilterResampled = Samplers.offset((Sampler)cellFilterResampled, (Sampler)Samplers.scale((Sampler)this.noiseJitter1, (double)3.0), (Sampler)Samplers.constant((double)0.0), (Sampler)Samplers.scale((Sampler)this.noiseJitter2, (double)3.0));
                this.cracked = Samplers.add((Sampler[])new Sampler[]{Samplers.scale((Sampler)cellsResampled, (double)200.0), Samplers.scale((Sampler)cellFilterResampled, (double)50.0), Samplers.scale((Sampler)invertedCracks, (double)-40.0)});
            }

            public double getSample(double x, double y, double z) {
                double f3 = this.fractal1x6.getSample(x / 8096.0, y, z / 8096.0);
                double raise = this.val$noise1.getSample(x / 40096.0, y, z / 40096.0);
                f3 += (raise -= 0.1) * 3.0;
                if ((f3 *= 0.25) < -1.0) {
                    f3 = -1.0;
                } else if (f3 > 1.0) {
                    f3 = 1.0;
                }
                double unscaledContinents = f3;
                double xLarge = x / 8192.0;
                double zLarge = z / 8192.0;
                double f1 = this.fractal1x2.getSample(xLarge, y, zLarge);
                double f2 = this.fractal2x2.getSample(xLarge, y, zLarge);
                double mix1 = FractalUtils.smoothStep((double)-0.005, (double)0.1, (double)(f1 * f2));
                double xJitter = (x + this.noiseJitter1.getSample(x, y, z) * 5.0) / 2000.0;
                double zJitter = (z + this.noiseJitter2.getSample(x, y, z) * 5.0) / 2000.0;
                double sp1 = 0.0;
                boolean fast = this.val$plateaus;
                double fCheck = 0.0;
                if (fast) {
                    fCheck = this.scaledFractal1x2.getSample(xJitter, y, zJitter);
                    fCheck = FractalUtils.smoothStep((double)1.9, (double)2.0, (double)fCheck);
                }
                if (fCheck > 0.0) {
                    double sp2 = this.sparse2.getSample(xJitter, y, zJitter);
                    if ((sp2 = FractalUtils.smoothStep((double)0.0, (double)0.1, (double)sp2)) != 0.0) {
                        sp1 = 1.0 - this.sparse.getSample(xJitter, y, zJitter);
                        sp1 += this.platFilter.getSample(xJitter, y, zJitter);
                        sp1 = FractalUtils.step((double)4.0, (double)sp1);
                        sp1 = sp1 * sp2 * fCheck;
                    }
                }
                double m2 = sp1;
                double m1 = mix1;
                double uScaledContinents = unscaledContinents;
                double cSquared = FractalUtils.reslope((double)uScaledContinents, (double)2.0, (double)0.005, (double)0.8);
                cSquared *= 600.0;
                double uContinentsCut = FractalUtils.smoothStep((double)-0.11, (double)-0.1, (double)uScaledContinents);
                m1 *= uContinentsCut;
                double uRollingHills = this.fractal1x4.getSample(x / 512.0, y, z / 512.0);
                double rHills = uRollingHills * 50.0;
                double nrh = uRollingHills;
                if (nrh < -600.0) {
                    nrh = -600.0;
                } else if (nrh > 0.0) {
                    nrh = 0.0;
                }
                double uc = unscaledContinents;
                if (uc < 0.0) {
                    uc = 0.0;
                } else if (uc > 1.0) {
                    uc = 1.0;
                }
                double nScale = uc * uc;
                nrh = nrh * nScale * 500.0;
                double r1 = 0.0;
                if (m1 != 0.0) {
                    double mounts = this.fractal1x6.getSample(x / 2048.0, y, z / 2048.0);
                    r1 = mounts *= 600.0 * m1;
                }
                double r2 = 0.0;
                if (m2 != 0.0) {
                    r2 = this.cracked.getSample(x, y, z) * m2;
                }
                double r3 = rHills;
                double r4 = nrh;
                double rFinal = Math.max(r1, r2);
                rFinal = Math.max(r3, rFinal);
                double v1 = cSquared;
                double v2 = rFinal += r4;
                double result = v1 + v2;
                if (result > 512.0) {
                    double offset = result - 512.0;
                    result = 512.0 - offset;
                } else if (result < -128.0) {
                    double offset = result + 128.0;
                    result = -(128.0 + offset);
                }
                return result;
            }

            public String toString() {
                return "DefaultSlowTerrainFractal[plateaus=" + this.val$plateaus + "]";
            }
        });
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        Sampler resampled = Samplers.resample((Sampler)noise1, (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double weatherWidth = 16384.0;
        double weatherHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)noise2, (double)(1.0 / weatherWidth), (double)0.0, (double)(1.0 / weatherHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        Sampler veg3 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        final Sampler vegBase = veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        double snowLine = 500.0;
        double treeLine = 500.0;
        double deepWater = -100.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 500.0) {
                    return 0.0;
                }
                if (height < -100.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[500.0, -100.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)128.0);
        Sampler estimatedElevation = Samplers.add((Sampler)estimated, (Sampler)waterLevel);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        elevation = Samplers.clamp((Sampler)Samplers.add((Sampler)elevation, (Sampler)waterLevel), (double)0.0, (double)640.0);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        return new DefaultWorldFractal(estimatedElevation, (Sampler)elevation, waterLevel, temperature, weather, (Sampler)veg, null);
    }

    public static WorldFractal createSlowDefault(long seed) {
        Object veg;
        Sampler test3;
        Sampler elevation;
        Sampler cracks;
        PerlinNoise noise;
        PerlinNoise noise1 = noise = new PerlinNoise(seed);
        PerlinNoise noise2 = new PerlinNoise(seed + 1L);
        PerlinNoise noise3 = new PerlinNoise(seed + 2L);
        FractalSum fractal = new FractalSum((Sampler)noise1);
        fractal.setFrequencyIterations(2);
        long cellSeed = seed;
        InvertedCellularNoise cells = new InvertedCellularNoise(cellSeed, true);
        cells = Samplers.smoothStep((double)0.1, (double)0.25, (Sampler)cells);
        CellularFilter cellFilter = new CellularFilter(cellSeed, (Sampler)fractal);
        cellFilter = Samplers.reflect((Sampler)cellFilter, (double)0.3, (double)1.0);
        Sampler cellsResampled = Samplers.resample((Sampler)Samplers.mult((Sampler)cells, (Sampler)cellFilter), (double)0.001953125, (double)1.0, (double)0.001953125);
        double jitterFrequency = 0.2;
        Sampler jitter1 = Samplers.resample((Sampler)new CellularFilter(cellSeed, (Sampler)noise1), (double)jitterFrequency, (double)1.0, (double)jitterFrequency);
        Sampler jitter2 = Samplers.resample((Sampler)new CellularFilter(cellSeed, (Sampler)noise2), (double)jitterFrequency, (double)1.0, (double)jitterFrequency);
        final Sampler noiseJitter1 = Samplers.resample((Sampler)noise1, (double)jitterFrequency, (double)1.0, (double)jitterFrequency);
        final Sampler noiseJitter2 = Samplers.resample((Sampler)noise2, (double)jitterFrequency, (double)1.0, (double)jitterFrequency);
        AbstractSampler jitterTest1 = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                return noiseJitter1.getSample(x, y, z);
            }
        };
        AbstractSampler jitterTest2 = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                return noiseJitter2.getSample(x, y, z);
            }
        };
        cellsResampled = Samplers.offset((Sampler)cellsResampled, (Sampler)Samplers.scale((Sampler)noiseJitter1, (double)5.0), (Sampler)Samplers.constant((double)0.0), (Sampler)Samplers.scale((Sampler)noiseJitter2, (double)5.0));
        Sampler cells2 = Samplers.smoothStep((double)0.01, (double)0.02, (Sampler)new InvertedCellularNoise(cellSeed, true));
        Sampler bigCracks = Samplers.resample((Sampler)cells2, (double)0.00390625, (double)1.0, (double)0.00390625);
        bigCracks = Samplers.subtract((Sampler)Samplers.constant((double)1.0), (Sampler)bigCracks);
        Sampler smallerCracks = Samplers.resample((Sampler)cells2, (double)0.015625, (double)1.0, (double)0.015625);
        smallerCracks = Samplers.subtract((Sampler)Samplers.constant((double)1.0), (Sampler)smallerCracks);
        Sampler invertedCracks = cracks = Samplers.max((Sampler)smallerCracks, (Sampler)bigCracks);
        Sampler crackNoise = Samplers.resample((Sampler)fractal, (double)0.015625, (double)1.0, (double)0.015625);
        crackNoise = Samplers.scale((Sampler)Samplers.add((Sampler)crackNoise, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        invertedCracks = Samplers.mult((Sampler)invertedCracks, (Sampler)crackNoise);
        invertedCracks = Samplers.mult((Sampler)invertedCracks, (Sampler)cellsResampled);
        CellularFilter filter = new CellularFilter(cellSeed, (Sampler)fractal);
        Sampler filterResampled = Samplers.resample((Sampler)filter, (double)0.00390625, (double)1.0, (double)0.00390625);
        filterResampled = Samplers.offset((Sampler)filterResampled, (Sampler)Samplers.scale((Sampler)noiseJitter1, (double)3.0), (Sampler)Samplers.constant((double)0.0), (Sampler)Samplers.scale((Sampler)noiseJitter2, (double)3.0));
        Sampler cracked = Samplers.add((Sampler[])new Sampler[]{Samplers.scale((Sampler)cellsResampled, (double)200.0), Samplers.scale((Sampler)filterResampled, (double)50.0), Samplers.scale((Sampler)invertedCracks, (double)-40.0)});
        fractal = new FractalSum((Sampler)noise1);
        fractal.setFrequencyIterations(3);
        Sampler resampled = Samplers.resample((Sampler)fractal, (double)1.2351778656126481E-4, (double)1.0, (double)1.2351778656126481E-4);
        double raiseWidth = 40096.0;
        double raiseHeight = 40096.0;
        Sampler raise = Samplers.resample((Sampler)noise1, (double)(1.0 / raiseWidth), (double)1.0, (double)(1.0 / raiseHeight));
        raise = Samplers.subtract((Sampler)raise, (Sampler)Samplers.constant((double)0.1));
        resampled = Samplers.add((Sampler)resampled, (Sampler)Samplers.scale((Sampler)raise, (double)3.0));
        resampled = Samplers.scale((Sampler)resampled, (double)0.25);
        Sampler unscaledContinents = resampled = Samplers.clip((Sampler)resampled, (double)-1.0, (double)1.0);
        Sampler continents = resampled = Samplers.scale((Sampler)resampled, (double)600.0);
        FractalSum fractal1 = new FractalSum((Sampler)noise1);
        fractal1.setFrequencyIterations(2);
        FractalSum fractal2 = new FractalSum((Sampler)noise2);
        fractal2.setFrequencyIterations(2);
        FractalSum fractal3 = new FractalSum((Sampler)noise3);
        fractal3.setFrequencyIterations(2);
        Sampler combined = Samplers.mult((Sampler)fractal1, (Sampler)fractal2);
        Sampler mix1 = Samplers.smoothStep((double)-0.005, (double)0.005, (Sampler)Samplers.resample((Sampler)combined, (double)1.220703125E-4, (double)1.0, (double)1.220703125E-4));
        mix1 = Samplers.smoothStep((double)-0.005, (double)0.1, (Sampler)Samplers.resample((Sampler)combined, (double)1.220703125E-4, (double)1.0, (double)1.220703125E-4));
        Sampler scaled = Samplers.scale((Sampler)mix1, (double)400.0);
        CellularNoise sparse = new CellularNoise(cellSeed);
        InvertedCellularNoise sparse2 = new InvertedCellularNoise(cellSeed, true);
        sparse = Samplers.subtract((Sampler)Samplers.constant((double)1.0), (Sampler)sparse);
        sparse2 = Samplers.smoothStep((double)0.0, (double)0.1, (Sampler)sparse2);
        filter = new CellularFilter(cellSeed, Samplers.scale((Sampler)Samplers.resample((Sampler)fractal1, (double)0.25, (double)1.0, (double)0.25), (double)8.0));
        sparse = Samplers.add((Sampler)sparse, (Sampler)filter);
        sparse = Samplers.step((double)4.0, (Sampler)sparse);
        boolean oldWay = false;
        if (!oldWay) {
            sparse = Samplers.mult((Sampler)sparse, (Sampler)sparse2);
        }
        Sampler mix2 = resampled = Samplers.resample((Sampler)sparse, (double)5.0E-4, (double)1.0, (double)5.0E-4);
        boolean mixJitter = true;
        if (mixJitter) {
            mix2 = Samplers.offset((Sampler)mix2, (Sampler)Samplers.scale((Sampler)noiseJitter1, (double)5.0), (Sampler)Samplers.constant((double)0.0), (Sampler)Samplers.scale((Sampler)noiseJitter2, (double)5.0));
        }
        fractal1 = new FractalSum((Sampler)noise1);
        fractal1.setFrequencyIterations(6);
        resampled = Samplers.resample((Sampler)fractal1, (double)4.8828125E-4, (double)1.0, (double)4.8828125E-4);
        Sampler mountains = Samplers.scale((Sampler)resampled, (double)600.0);
        Sampler continentsSquared = Samplers.reslope((Sampler)unscaledContinents, (double)2.0, (double)0.005, (double)0.8);
        continentsSquared = Samplers.scale((Sampler)continentsSquared, (double)600.0);
        Sampler unscaledContinentsCut = Samplers.smoothStep((double)-0.11, (double)-0.1, (Sampler)unscaledContinents);
        mix1 = Samplers.mult((Sampler)mix1, (Sampler)unscaledContinentsCut);
        fractal1 = new FractalSum((Sampler)noise1);
        fractal1.setFrequencyIterations(4);
        Sampler unscaledRollingHills = resampled = Samplers.resample((Sampler)fractal1, (double)0.001953125, (double)1.0, (double)0.001953125);
        Sampler rollingHills = Samplers.scale((Sampler)unscaledRollingHills, (double)50.0);
        Sampler negativeRollingHills = Samplers.clamp((Sampler)Samplers.scale((Sampler)unscaledRollingHills, (double)1.0), (double)-600.0, (double)0.0);
        Sampler noiseScale = Samplers.pow((Sampler)Samplers.clamp((Sampler)unscaledContinents, (double)0.0, (double)1.0), (double)2.0);
        negativeRollingHills = Samplers.mult((Sampler)noiseScale, (Sampler)negativeRollingHills);
        negativeRollingHills = Samplers.scale((Sampler)negativeRollingHills, (double)500.0);
        Sampler mixedMountains = Samplers.mult((Sampler)mix1, (Sampler)mountains);
        Sampler mixedCracks = Samplers.mult((Sampler)mix2, (Sampler)cracked);
        Sampler rocks = Samplers.max((Sampler)mixedMountains, (Sampler)mixedCracks);
        rocks = Samplers.max((Sampler)rollingHills, (Sampler)rocks);
        rocks = Samplers.add((Sampler)rocks, (Sampler)negativeRollingHills);
        Sampler estimated = elevation = (test3 = Samplers.add((Sampler)continentsSquared, (Sampler)rocks));
        double temperatureWidth = 32768.0;
        double temperatureHeight = 16384.0;
        resampled = Samplers.resample((Sampler)noise1, (double)(1.0 / temperatureWidth), (double)0.0, (double)(1.0 / temperatureHeight));
        Sampler temperature = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        double weatherWidth = 16384.0;
        double weatherHeight = 32768.0;
        Sampler unnormalizedWetness = resampled = Samplers.resample((Sampler)noise2, (double)(1.0 / weatherWidth), (double)0.0, (double)(1.0 / weatherHeight));
        Sampler weather = Samplers.scale((Sampler)Samplers.add((Sampler)resampled, (Sampler)Samplers.constant((double)1.0)), (double)0.5);
        Sampler veg1 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0625, (double)1.0, (double)0.0625);
        Sampler veg2 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)0.0078125, (double)1.0, (double)0.0078125);
        Sampler veg3 = resampled = Samplers.resample((Sampler)new PerlinNoise(seed), (double)9.765625E-4, (double)1.0, (double)9.765625E-4);
        final Sampler vegBase = veg = Samplers.scale((Sampler)Samplers.add((Sampler)veg1, (Sampler)veg2), (double)0.5);
        double snowLine = 500.0;
        double treeLine = 500.0;
        double deepWater = -100.0;
        veg = new AbstractSampler(-1.0, 1.0){

            public double getSample(double x, double y, double z) {
                double height = y;
                if (height > 500.0) {
                    return 0.0;
                }
                if (height < -100.0) {
                    return 0.0;
                }
                double result = vegBase.getSample(x, 0.0, z);
                if (height < 0.0) {
                    result *= 0.5;
                }
                return result;
            }

            public String toString() {
                return "VegRemapping[500.0, -100.0]";
            }
        };
        veg = Samplers.clamp((Sampler)veg, (double)0.0, (double)1.0);
        Sampler waterLevel = Samplers.constant((double)128.0);
        Sampler estimatedElevation = Samplers.add((Sampler)estimated, (Sampler)waterLevel);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        elevation = Samplers.add((Sampler)elevation, (Sampler)waterLevel);
        estimatedElevation = Samplers.clamp((Sampler)estimatedElevation, (double)0.0, (double)640.0);
        return new DefaultWorldFractal(estimatedElevation, elevation, waterLevel, temperature, weather, (Sampler)veg, null);
    }
}

