/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.simsilica.crig.ColliderInfo;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mblock.phys.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColliderShape {
    static Logger log = LoggerFactory.getLogger(ColliderShape.class);
    private ColliderInfo info;
    private Part target;
    private Spatial source;

    public ColliderShape(ColliderInfo info, Spatial source, Part target) {
        this.info = info;
        this.source = source;
        this.target = target;
    }

    public void update() {
        Vec3d offset = this.info.getOffset();
        Quatd orient = this.info.getOrientation();
        offset = offset.divide(new Vec3d(this.source.getWorldScale()));
        Vector3f local = this.source.localToWorld(offset.toVector3f(), null);
        Quaternion localRot = this.source.getWorldRotation().mult(orient.toQuaternion());
        if (log.isTraceEnabled()) {
            log.trace("updating part:" + this.target.getName() + "  to:" + local);
        }
        this.target.setLocalPosition(new Vec3d(local));
        this.target.setLocalOrientation(new Quatd(localRot));
    }
}

