/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.crig.jme;

import com.jme3.anim.SkinningControl;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.util.clone.Cloner;
import com.simsilica.crig.AttachmentInfo;
import com.simsilica.crig.AttachmentPoint;
import com.simsilica.crig.jme.AnimComposerRig;
import com.simsilica.crig.jme.AttachmentPointImpl;
import com.simsilica.crig.jme.SpatialRigType;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentControl
extends AbstractControl {
    static Logger log = LoggerFactory.getLogger(AttachmentControl.class);
    private SpatialRigType rigType;
    private SkinningControl skin;
    private Map<String, AttachmentPointImpl> attachmentIndex = new HashMap<String, AttachmentPointImpl>();

    public AttachmentControl(SpatialRigType rigType) {
        this.rigType = rigType;
    }

    protected SpatialRigType getRigType() {
        return this.rigType;
    }

    public AttachmentPoint getAttachment(String name) {
        if (this.skin == null) {
            throw new UnsupportedOperationException("This spatial has no skin and cannot calculate attachments.");
        }
        AttachmentPointImpl result = this.attachmentIndex.get(name);
        if (result != null) {
            return result;
        }
        AttachmentInfo info = this.rigType.findAttachmentInfo(name);
        if (info == null) {
            throw new IllegalArgumentException("No attachment info found for:" + name);
        }
        if (log.isTraceEnabled()) {
            log.trace("Configuring attachment for:" + info);
        }
        if (this.skin.getArmature().getJoint(info.getJoint()) == null) {
            log.warn("No joint found for:" + info.getJoint() + " attachment:" + info + " rigType:" + this.rigType);
            result = new AttachmentPointImpl(info, this.getSpatial());
        } else {
            Node node = this.skin.getAttachmentsNode(info.getJoint());
            result = new AttachmentPointImpl(info, (Spatial)node);
        }
        this.attachmentIndex.put(name, result);
        return result;
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
        this.skin = AnimComposerRig.findControl(spatial, SkinningControl.class);
    }

    protected void controlUpdate(float tpf) {
    }

    public void cloneFields(Cloner cloner, Object original) {
        super.cloneFields(cloner, original);
        this.attachmentIndex = new HashMap<String, AttachmentPointImpl>();
        this.skin = (SkinningControl)cloner.clone((Object)this.skin);
    }

    protected void controlRender(RenderManager rm, ViewPort vp) {
    }
}

