/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.bpos.mphys;

import com.simsilica.bpos.BodyPosition;
import com.simsilica.bpos.LargeGridCell;
import com.simsilica.bpos.LargeObject;
import com.simsilica.es.Entity;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityContainer;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.ext.mphys.SpawnPosition;
import com.simsilica.mathd.Grid;
import com.simsilica.mathd.Quatd;
import com.simsilica.mathd.Vec3d;
import com.simsilica.mphys.PhysicsSpace;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LargeGridIndexSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(LargeGridIndexSystem.class);
    private Grid largeGrid;
    private EntityData ed;
    private PhysicsSpace phys;
    private EntityChangeObserver entityObserver = new EntityChangeObserver();
    private ConcurrentLinkedQueue<EntityId> changes = new ConcurrentLinkedQueue();
    private Set<EntityId> processed = new HashSet<EntityId>();
    private LobContainer lobs;
    private double nextTime = 0.0;
    private double timeInterval = 0.05f;

    public LargeGridIndexSystem(Grid largeGrid) {
        if (largeGrid == null) {
            throw new IllegalArgumentException("Grid cannot be null");
        }
        this.largeGrid = largeGrid;
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.phys = (PhysicsSpace)this.getSystem(PhysicsSpace.class, true);
        ((ObservableEntityData)this.ed).addEntityComponentListener((EntityComponentListener)this.entityObserver);
        this.lobs = new LobContainer(this.ed);
    }

    public void update(SimTime time) {
        super.update(time);
        this.updateLobs(time);
        if (this.changes.isEmpty()) {
            return;
        }
        EntityId id = null;
        while ((id = this.changes.poll()) != null) {
            if (!this.processed.add(id)) {
                return;
            }
            LargeObject lo = (LargeObject)this.ed.getComponent(id, LargeObject.class);
            LargeGridCell cell = (LargeGridCell)this.ed.getComponent(id, LargeGridCell.class);
            if (lo == null) {
                if (cell == null) continue;
                log.info("Removing large grid cell:" + cell + " from:" + id);
                this.ed.removeComponent(id, LargeGridCell.class);
                continue;
            }
            SpawnPosition pos = (SpawnPosition)this.ed.getComponent(id, SpawnPosition.class);
            if (pos == null) continue;
            LargeGridCell newCell = LargeGridCell.create(this.largeGrid, pos.getLocation());
            if (cell != null && newCell.getCellId() == cell.getCellId()) continue;
            log.info("Updating:" + id + " grid cell:" + newCell);
            this.ed.setComponent(id, (EntityComponent)newCell);
        }
        this.processed.clear();
    }

    private void updateLobs(SimTime time) {
        double secs = time.getTimeInSeconds();
        if (secs < this.nextTime) {
            return;
        }
        this.nextTime = secs + this.timeInterval;
        this.lobs.update();
        for (Lob lob : this.lobs.getArray()) {
            lob.updateCell();
        }
    }

    public void start() {
        super.start();
        this.lobs.start();
    }

    public void stop() {
        this.lobs.stop();
        super.stop();
    }

    protected void terminate() {
        ((ObservableEntityData)this.ed).removeEntityComponentListener((EntityComponentListener)this.entityObserver);
    }

    private class EntityChangeObserver
    implements EntityComponentListener {
        private EntityChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            Class type = change.getComponentType();
            if (type != SpawnPosition.class && type != LargeObject.class) {
                return;
            }
            LargeGridIndexSystem.this.changes.add(change.getEntityId());
        }
    }

    private class LobContainer
    extends EntityContainer<Lob> {
        public LobContainer(EntityData ed) {
            super(ed, new Class[]{LargeObject.class, BodyPosition.class});
        }

        public Lob[] getArray() {
            return (Lob[])super.getArray();
        }

        protected Lob addObject(Entity e) {
            log.info("add LOB for:" + e.getId());
            Lob object = new Lob(e);
            this.updateObject(object, e);
            return object;
        }

        protected void updateObject(Lob object, Entity e) {
            object.update();
        }

        protected void removeObject(Lob object, Entity e) {
            log.info("remove LOB for:" + e.getId());
        }
    }

    private class Lob {
        private Entity entity;
        private BodyPosition pos;
        private Vec3d lastLoc = new Vec3d();
        private Quatd lastOrient = new Quatd();
        private Long lastCellId = null;

        public Lob(Entity entity) {
            this.entity = entity;
        }

        public void update() {
            this.pos = (BodyPosition)this.entity.get(BodyPosition.class);
        }

        public void updateCell() {
            Vec3d loc = this.pos.getLastLocation();
            Quatd orient = this.pos.getLastOrientation();
            if (loc == null || orient == null) {
                return;
            }
            if (loc.isSimilar(this.lastLoc, 0.01) && orient.isSimilar(this.lastOrient, 0.01)) {
                return;
            }
            this.lastLoc.set(loc);
            this.lastOrient.set(orient);
            SpawnPosition spawnPos = new SpawnPosition(LargeGridIndexSystem.this.phys.getGrid(), loc, orient);
            if (log.isTraceEnabled()) {
                log.trace(this.entity.getId() + " Lob.update spawn pos:" + loc);
            }
            this.entity.set((EntityComponent)spawnPos);
            LargeGridCell cell = LargeGridCell.create(LargeGridIndexSystem.this.largeGrid, spawnPos.getLocation());
            if (this.lastCellId != null && cell.getCellId() == this.lastCellId.longValue()) {
                return;
            }
            this.lastCellId = cell.getCellId();
        }
    }
}

