/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.component;

import com.jme3.material.RenderState;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.shape.Quad;
import com.jme3.texture.Texture;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.component.AbstractGuiComponent;
import com.simsilica.lemur.component.ColoredComponent;
import com.simsilica.lemur.core.GuiControl;
import com.simsilica.lemur.core.GuiMaterial;

public class QuadBackgroundComponent
extends AbstractGuiComponent
implements Cloneable,
ColoredComponent {
    private Geometry background;
    private ColorRGBA color;
    private float alpha = 1.0f;
    private Texture texture;
    private Vector2f textureCoordinateScale;
    private GuiMaterial material;
    private float xMargin = 0.0f;
    private float yMargin = 0.0f;
    private float zOffset = 0.01f;
    private float alphaDiscard = 0.0f;
    private boolean lit = false;
    private Vector2f appliedTextureScale = new Vector2f(1.0f, 1.0f);

    public QuadBackgroundComponent() {
        this(ColorRGBA.Gray, 0.0f, 0.0f, 0.01f, false);
    }

    public QuadBackgroundComponent(ColorRGBA color) {
        this(color, 0.0f, 0.0f, 0.01f, false);
    }

    public QuadBackgroundComponent(ColorRGBA color, float xMargin, float yMargin) {
        this(color, xMargin, yMargin, 0.01f, false);
    }

    public QuadBackgroundComponent(ColorRGBA color, float xMargin, float yMargin, float zOffset, boolean lit) {
        this.xMargin = xMargin;
        this.yMargin = yMargin;
        this.zOffset = zOffset;
        this.lit = lit;
        this.setColor(color);
        this.createMaterial();
    }

    public QuadBackgroundComponent(Texture texture) {
        this(texture, 0.0f, 0.0f, 0.01f, false);
    }

    public QuadBackgroundComponent(Texture texture, float xMargin, float yMargin) {
        this(texture, xMargin, yMargin, 0.01f, false);
    }

    public QuadBackgroundComponent(Texture texture, float xMargin, float yMargin, float zOffset, boolean lit) {
        this.xMargin = xMargin;
        this.yMargin = yMargin;
        this.zOffset = zOffset;
        this.lit = lit;
        this.setTexture(texture);
        this.setColor(ColorRGBA.White);
        this.createMaterial();
    }

    @Override
    public QuadBackgroundComponent clone() {
        QuadBackgroundComponent result = (QuadBackgroundComponent)super.clone();
        result.material = this.material.clone();
        result.background = null;
        return result;
    }

    @Override
    public void attach(GuiControl parent) {
        super.attach(parent);
    }

    @Override
    public void detach(GuiControl parent) {
        if (this.background != null) {
            this.getNode().detachChild((Spatial)this.background);
        }
        super.detach(parent);
    }

    @Override
    public void setColor(ColorRGBA c) {
        this.color = c;
        this.resetColor();
    }

    protected void resetColor() {
        if (this.material == null) {
            return;
        }
        if (this.alpha >= 1.0f) {
            this.material.setColor(this.color);
        } else {
            ColorRGBA adjusted = this.color != null ? this.color.clone() : ColorRGBA.White.clone();
            adjusted.a *= this.alpha;
            this.material.setColor(adjusted);
        }
    }

    @Override
    public ColorRGBA getColor() {
        return this.color;
    }

    @Override
    public void setAlpha(float f) {
        if (this.alpha == f) {
            return;
        }
        this.alpha = f;
        this.resetColor();
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public void setTexture(Texture t) {
        if (this.texture == t) {
            return;
        }
        this.texture = t;
        if (this.material != null) {
            this.material.setTexture(this.texture);
        }
    }

    public Texture getTexture() {
        return this.texture;
    }

    public void setTextureCoordinateScale(Vector2f scale) {
        this.textureCoordinateScale = scale;
    }

    public Vector2f getTextureCoordinateScale() {
        return this.textureCoordinateScale;
    }

    public void setMargin(float x, float y) {
        this.xMargin = x;
        this.yMargin = y;
        this.invalidate();
    }

    public void setMargin(Vector2f margin) {
        if (margin == null) {
            throw new IllegalArgumentException("Margin cannot be null");
        }
        this.setMargin(margin.x, margin.y);
    }

    public Vector2f getMargin() {
        return new Vector2f(this.xMargin, this.yMargin);
    }

    public void setZOffset(float z) {
        this.zOffset = z;
        this.invalidate();
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public void setAlphaDiscard(float alphaDiscard) {
        if (this.alphaDiscard == alphaDiscard) {
            return;
        }
        this.alphaDiscard = alphaDiscard;
        if (this.material != null) {
            this.material.getMaterial().setFloat("AlphaDiscardThreshold", alphaDiscard);
        }
    }

    public float getAlphaDiscard() {
        return this.alphaDiscard;
    }

    public GuiMaterial getMaterial() {
        return this.material;
    }

    @Override
    public void calculatePreferredSize(Vector3f size) {
        size.x += this.xMargin * 2.0f;
        size.y += this.yMargin * 2.0f;
        size.z += Math.abs(this.zOffset);
    }

    @Override
    public void reshape(Vector3f pos, Vector3f size) {
        this.refreshBackground(size);
        this.background.setLocalTranslation(pos.x, pos.y - size.y, pos.z);
        pos.x += this.xMargin;
        pos.y -= this.yMargin;
        pos.z += this.zOffset;
        size.x -= this.xMargin * 2.0f;
        size.y -= this.yMargin * 2.0f;
        size.z -= Math.abs(this.zOffset);
    }

    protected void createMaterial() {
        this.material = GuiGlobals.getInstance().createMaterial(this.color, this.lit);
        if (this.texture != null) {
            this.material.setTexture(this.texture);
        }
        this.material.getMaterial().getAdditionalRenderState().setBlendMode(RenderState.BlendMode.Alpha);
        this.material.getMaterial().setFloat("AlphaDiscardThreshold", this.alphaDiscard);
    }

    protected void refreshBackground(Vector3f size) {
        Vector2f effectiveScale;
        Quad q;
        if (this.background == null) {
            q = new Quad(size.x, size.y);
            if (this.lit) {
                q.setBuffer(VertexBuffer.Type.Normal, 3, new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f});
            }
            this.background = new Geometry("background", (Mesh)q);
            if (this.material == null) {
                this.createMaterial();
            }
            this.background.setMaterial(this.material.getMaterial());
            this.getNode().attachChild((Spatial)this.background);
            this.appliedTextureScale.set(1.0f, 1.0f);
        } else {
            q = (Quad)this.background.getMesh();
            if (size.x != q.getWidth() || size.y != q.getHeight()) {
                q.updateGeometry(size.x, size.y);
                q.clearCollisionData();
            }
        }
        Vector2f vector2f = effectiveScale = this.textureCoordinateScale == null ? Vector2f.UNIT_XY : this.textureCoordinateScale;
        if (!this.appliedTextureScale.equals((Object)effectiveScale)) {
            Mesh m = this.background.getMesh();
            m.scaleTextureCoordinates(new Vector2f(1.0f / this.appliedTextureScale.x, 1.0f / this.appliedTextureScale.y));
            this.appliedTextureScale.set(effectiveScale);
            m.scaleTextureCoordinates(this.appliedTextureScale);
        }
    }
}

