/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityChange;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityComponentListener;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.es.ObservableEntityData;
import com.simsilica.ext.mphys.ShapeInfo;
import com.simsilica.mblock.CellArray;
import com.simsilica.mblock.db.CellArrayId;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.character.BodyConfig;
import mythruna.character.BodyConfigIndex;
import mythruna.es.BodyEffect;
import mythruna.es.BodyType;
import mythruna.es.ClothingInfo;
import mythruna.es.HairColor;
import mythruna.es.Race;
import mythruna.es.SkinColor;
import mythruna.es.SkinVariation;
import mythruna.es.WornBy;
import mythruna.fabric.ClothingAccumulator;
import mythruna.shape.ShapeName;
import mythruna.world.WorldManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppearanceSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(AppearanceSystem.class);
    private EntityData ed;
    private EntityId worldEntity;
    private WorldManager worldManager;
    private BodyConfigIndex bodyConfigs;
    private EntityChangeObserver entityListener = new EntityChangeObserver();
    private ConcurrentLinkedQueue<EntityChange> changes = new ConcurrentLinkedQueue();
    private Set<Class> components = new HashSet<Class>(Arrays.asList(Race.class, BodyType.class, WornBy.class, SkinColor.class, HairColor.class, SkinVariation.class, BodyEffect.class));
    private LoadingCache<String, ShapeName> baseClothes = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, ShapeName>(){

        public ShapeName load(String key) {
            return AppearanceSystem.this.loadClothing(key);
        }
    });

    protected <T extends EntityComponent> T find(Class<T> type, EntityComponent ... components) {
        for (EntityComponent c : components) {
            if (c == null || c.getClass() != type) continue;
            return (T)((EntityComponent)type.cast(c));
        }
        return null;
    }

    protected boolean isEmpty(EntityComponent ... components) {
        for (EntityComponent c : components) {
            if (c == null) continue;
            return false;
        }
        return true;
    }

    public ShapeName calculateBaseShape(EntityComponent ... components) {
        if (log.isDebugEnabled()) {
            log.debug("calculateBaseShape(" + Arrays.asList(components) + ")");
        }
        ShapeName mainName = this.createBaseShape(null, true, components);
        return mainName;
    }

    protected BodyConfig getBodyConfig(EntityComponent ... components) {
        String bodyId;
        Race race = this.find(Race.class, components);
        String raceId = race == null ? null : race.getTypeName(this.ed);
        BodyType body = this.find(BodyType.class, components);
        String string = bodyId = body == null ? null : body.getTypeName(this.ed);
        if (raceId == null && bodyId == null) {
            return new BodyConfig();
        }
        return this.bodyConfigs.find(raceId, bodyId);
    }

    protected ShapeName createBaseShape(EntityId entityId, boolean includeDefaultClothing, EntityComponent ... components) {
        ShapeName mainName;
        if (log.isDebugEnabled()) {
            log.debug("createBaseShape(" + entityId + ", " + Arrays.asList(components) + ")");
        }
        if (this.isEmpty(components)) {
            if (log.isDebugEnabled()) {
                log.debug("no components, entity is probably being deleted");
            }
            return null;
        }
        BodyConfig bodyConfig = this.getBodyConfig(components);
        if (log.isDebugEnabled()) {
            log.debug("body config:" + bodyConfig);
        }
        if (bodyConfig == null) {
            throw new IllegalArgumentException("No body config found for:" + Arrays.asList(components));
        }
        if (bodyConfig.getModel() != null) {
            mainName = ShapeName.parse(bodyConfig.getModel());
            if (includeDefaultClothing) {
                mainName.getAddOns().add(this.getClothing(bodyConfig.getClothing()));
            }
        } else {
            ShapeInfo shapeInfo = this.find(ShapeInfo.class, components);
            if (shapeInfo != null) {
                ShapeName currentName = ShapeName.parse(shapeInfo.getShapeName(this.ed));
                mainName = currentName.clearAddOns();
            } else {
                log.info("Cannot resolve base shape for:" + entityId + " components:" + Arrays.asList(components));
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("mainName:" + mainName);
        }
        for (EntityComponent comp : components) {
            int index;
            int color;
            if (comp == null) continue;
            if (comp.getClass() == HairColor.class) {
                color = ((HairColor)comp).getColorArgb();
                mainName.getAddOns().add(new ShapeName("hc", String.format("%06x", color & 0xFFFFFF)));
                continue;
            }
            if (comp.getClass() == SkinColor.class) {
                color = ((SkinColor)comp).getColorArgb();
                mainName.getAddOns().add(new ShapeName("sc", String.format("%06x", color & 0xFFFFFF)));
                continue;
            }
            if (comp.getClass() == SkinVariation.class) {
                index = ((SkinVariation)comp).getIndex();
                mainName.getAddOns().add(new ShapeName("sv", String.valueOf(index)));
                continue;
            }
            if (comp.getClass() != BodyEffect.class) continue;
            index = ((BodyEffect)comp).getIndex();
            mainName.getAddOns().add(new ShapeName("fx", String.valueOf(index)));
        }
        return mainName;
    }

    protected EntityId findClothingDesign(EntityId parent, String name) {
        ComponentFilter filter1 = Filters.fieldEquals(ClothingInfo.class, (String)"parent", (Object)parent);
        ComponentFilter filter2 = Filters.fieldEquals(ClothingInfo.class, (String)"name", (Object)name);
        return this.ed.findEntity(Filters.and(ClothingInfo.class, (ComponentFilter[])new ComponentFilter[]{filter1, filter2}), new Class[]{ClothingInfo.class});
    }

    protected EntityId findDefaultClothingDesign(String name) {
        return this.findClothingDesign(this.worldEntity, name);
    }

    protected void initialize() {
        log.info("initialize()");
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.worldManager = (WorldManager)this.getSystem(WorldManager.class, true);
        this.worldEntity = this.worldManager.getWorldEntity();
        this.bodyConfigs = (BodyConfigIndex)this.getSystem(BodyConfigIndex.class, true);
    }

    protected ShapeName getClothing(String designName) {
        return (ShapeName)this.baseClothes.getUnchecked((Object)designName);
    }

    protected ShapeName loadClothing(String designName) {
        EntityId id = this.findDefaultClothingDesign(designName);
        if (id == null) {
            throw new IllegalArgumentException("No clothing found for:" + designName);
        }
        ShapeInfo shape = (ShapeInfo)this.ed.getComponent(id, ShapeInfo.class);
        return ShapeName.parse(shape.getShapeName(this.ed));
    }

    protected void terminate() {
    }

    public void start() {
        log.info("start()");
        ((ObservableEntityData)this.ed).addEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    public void update(SimTime time) {
        this.processChanges();
    }

    protected void processChanges() {
        if (this.changes.isEmpty()) {
            return;
        }
        HashSet<EntityId> recalculate = new HashSet<EntityId>();
        EntityChange change = null;
        while ((change = this.changes.poll()) != null) {
            Class type = change.getComponentType();
            if (type == WornBy.class) {
                WornBy comp = (WornBy)change.getComponent();
                if (comp == null || comp.getTarget() == null) continue;
                recalculate.add(comp.getTarget());
                continue;
            }
            if (type == Race.class) {
                recalculate.add(change.getEntityId());
                continue;
            }
            if (type == HairColor.class) {
                recalculate.add(change.getEntityId());
                continue;
            }
            if (type == SkinColor.class) {
                recalculate.add(change.getEntityId());
                continue;
            }
            if (type == SkinVariation.class) {
                recalculate.add(change.getEntityId());
                continue;
            }
            if (type != BodyEffect.class) continue;
            recalculate.add(change.getEntityId());
        }
        if (!recalculate.isEmpty()) {
            for (EntityId id : recalculate) {
                this.recalculate(id);
            }
        }
    }

    protected void recalculate(EntityId entity) {
        BodyEffect fx;
        SkinVariation skinVariation;
        SkinColor skinColor;
        if (log.isDebugEnabled()) {
            log.debug("recalculate(" + entity + ")");
        }
        Race race = (Race)this.ed.getComponent(entity, Race.class);
        ShapeInfo shapeInfo = (ShapeInfo)this.ed.getComponent(entity, ShapeInfo.class);
        double scale = shapeInfo == null ? 1.0 : shapeInfo.getScale();
        HairColor hairColor = (HairColor)this.ed.getComponent(entity, HairColor.class);
        ShapeName main = this.createBaseShape(entity, false, new EntityComponent[]{race, hairColor, skinColor = (SkinColor)this.ed.getComponent(entity, SkinColor.class), skinVariation = (SkinVariation)this.ed.getComponent(entity, SkinVariation.class), shapeInfo, fx = (BodyEffect)this.ed.getComponent(entity, BodyEffect.class)});
        if (main == null) {
            return;
        }
        CellArrayId clothingId = this.buildOutfit(entity);
        if (clothingId != null) {
            main.getAddOns().add(new ShapeName("fab", clothingId.toIdString()));
        }
        ShapeInfo shape = ShapeInfo.create((String)main.toCompositeString(), (double)scale, (EntityData)this.ed);
        log.info("Setting entity:" + entity + " shape:" + main.toCompositeString());
        this.ed.setComponent(entity, (EntityComponent)shape);
    }

    protected CellArrayId buildOutfit(EntityId entity) {
        List<Clothing> worn;
        if (log.isDebugEnabled()) {
            log.debug("buildOutfit(" + entity + ")");
        }
        if ((worn = this.getWornItems(entity)).isEmpty()) {
            return null;
        }
        ClothingAccumulator accumulator = new ClothingAccumulator(32, 32, 32);
        for (Clothing c : worn) {
            ShapeName shape = ShapeName.parse(c.shape.getShapeName(this.ed));
            if (log.isTraceEnabled()) {
                log.trace("  shape:" + shape);
            }
            CellArrayId cellArrayId = CellArrayId.fromString((String)shape.getName());
            if (log.isTraceEnabled()) {
                log.trace("  id:" + cellArrayId);
            }
            CellArray cells = this.worldManager.getCellArrayStorage().apply(cellArrayId);
            if (log.isTraceEnabled()) {
                log.trace("  cells:" + cells);
            }
            accumulator.addCells(cells);
        }
        CellArrayId clothingId = this.worldManager.getCellArrayStorage().store(accumulator.getCells());
        if (log.isDebugEnabled()) {
            log.debug("clothingId:" + clothingId);
        }
        return clothingId;
    }

    protected List<Clothing> getWornItems(EntityId entity) {
        ArrayList<Clothing> results = new ArrayList<Clothing>();
        ComponentFilter filter = Filters.fieldEquals(WornBy.class, (String)"target", (Object)entity);
        for (EntityId item : this.ed.findEntities(filter, new Class[]{WornBy.class})) {
            WornBy worn = (WornBy)this.ed.getComponent(item, WornBy.class);
            ShapeInfo shape = (ShapeInfo)this.ed.getComponent(item, ShapeInfo.class);
            if (worn == null || shape == null || worn.getLayer() == -1) continue;
            Clothing c = new Clothing(this, item, worn, shape);
            int index = Collections.binarySearch(results, c);
            if (index < 0) {
                index = -index;
                --index;
            }
            results.add(index, c);
        }
        return results;
    }

    public void stop() {
        ((ObservableEntityData)this.ed).removeEntityComponentListener((EntityComponentListener)this.entityListener);
    }

    private class EntityChangeObserver
    implements EntityComponentListener {
        private EntityChangeObserver() {
        }

        public void componentChange(EntityChange change) {
            Class type = change.getComponentType();
            if (AppearanceSystem.this.components.contains(type)) {
                if (log.isDebugEnabled()) {
                    log.debug("componentChange(" + change + ")");
                }
                AppearanceSystem.this.changes.add(change);
            }
        }
    }

    private class Clothing
    implements Comparable<Clothing> {
        private final EntityId entityId;
        private final WornBy wornBy;
        private final ShapeInfo shape;

        public Clothing(AppearanceSystem appearanceSystem, EntityId entityId, WornBy wornBy, ShapeInfo shape) {
            this.entityId = entityId;
            this.wornBy = wornBy;
            this.shape = shape;
        }

        @Override
        public int compareTo(Clothing other) {
            int layer2;
            if (this == other) {
                return 0;
            }
            int layer1 = this.wornBy.getLayer();
            int result = Integer.compare(layer1, layer2 = other.wornBy.getLayer());
            if (result != 0) {
                return result;
            }
            return Long.compare(this.entityId.getId(), other.entityId.getId());
        }
    }
}

