/*
 * Decompiled with CFR 0.152.
 */
package mythruna.sim.ai;

import com.simsilica.es.ComponentFilter;
import com.simsilica.es.EntityComponent;
import com.simsilica.es.EntityData;
import com.simsilica.es.EntityId;
import com.simsilica.es.Filters;
import com.simsilica.sim.AbstractGameSystem;
import com.simsilica.sim.SimTime;
import com.simsilica.thread.IterationProcessor;
import com.simsilica.thread.IterationProcessorThread;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import mythruna.es.AgentType;
import mythruna.sim.GameActionSystem;
import mythruna.sim.ai.ActivationZoneListener;
import mythruna.sim.ai.AgentActivationProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentActivationSystem
extends AbstractGameSystem {
    static Logger log = LoggerFactory.getLogger(AgentActivationSystem.class);
    private EntityData ed;
    private IterationProcessorThread thread;
    private AgentActivationProcessor processor;
    private GameActionSystem gameActions;
    private List<ActivationZoneListener> listeners = new ArrayList<ActivationZoneListener>();
    private ActivationAccumulator accumulator = new ActivationAccumulator(this);

    public String getDiagnostics() {
        return this.processor.getDiagnostics();
    }

    public void addActivationZoneListener(ActivationZoneListener l) {
        this.listeners.add(l);
    }

    public void removeActivationZoneListener(ActivationZoneListener l) {
        this.listeners.remove(l);
    }

    protected void initialize() {
        this.ed = (EntityData)this.getSystem(EntityData.class, true);
        this.gameActions = (GameActionSystem)((Object)this.getSystem(GameActionSystem.class, true));
        this.processor = new AgentActivationProcessor(this.ed, this.gameActions, List.of(this.accumulator));
        this.thread = new IterationProcessorThread("agentActivationSystem", (IterationProcessor)this.processor, true);
    }

    protected void terminate() {
    }

    public void start() {
        this.initializeAgentLevels();
        this.thread.start();
    }

    public void update(SimTime time) {
        if (this.accumulator.update()) {
            for (Long l : this.accumulator.getAdded()) {
                this.fireActivateZone(l);
            }
            for (Long l : this.accumulator.getRemoved()) {
                this.fireDeactivateZone(l);
            }
        }
        this.thread.iterate();
    }

    public void stop() {
        this.thread.close();
    }

    protected void initializeAgentLevels() {
        ComponentFilter<AgentType> highFilter = AgentType.levelFilter(0);
        ComponentFilter<AgentType> lowFilter = AgentType.levelFilter(1);
        ComponentFilter filter = Filters.or(AgentType.class, (ComponentFilter[])new ComponentFilter[]{highFilter, lowFilter});
        for (EntityId id : this.ed.findEntities(filter, new Class[]{AgentType.class})) {
            log.warn("Fixing agent:" + id + " to be passive.");
            AgentType type = (AgentType)this.ed.getComponent(id, AgentType.class);
            this.ed.setComponent(id, (EntityComponent)type.changeLevel(2));
        }
    }

    protected void fireActivateZone(long zoneId) {
        for (ActivationZoneListener l : this.listeners) {
            l.activateZone(zoneId);
        }
    }

    protected void fireDeactivateZone(long zoneId) {
        for (ActivationZoneListener l : this.listeners) {
            l.deactivateZone(zoneId);
        }
    }

    private class ActivationAccumulator
    implements ActivationZoneListener {
        private Set<Long> activeZones = new HashSet<Long>();
        private Set<Long> added = new HashSet<Long>();
        private Set<Long> removed = new HashSet<Long>();
        private ConcurrentLinkedQueue<Runnable> updates = new ConcurrentLinkedQueue();

        private ActivationAccumulator(AgentActivationSystem agentActivationSystem) {
        }

        public Set<Long> getAdded() {
            return this.added;
        }

        public Set<Long> getRemoved() {
            return this.removed;
        }

        public boolean update() {
            this.added.clear();
            this.removed.clear();
            boolean changed = false;
            Runnable r = null;
            while ((r = this.updates.poll()) != null) {
                r.run();
                changed = true;
            }
            return changed;
        }

        @Override
        public void activateZone(long zoneId) {
            this.updates.add(() -> {
                if (this.activeZones.add(zoneId)) {
                    this.added.add(zoneId);
                    this.removed.remove(zoneId);
                }
            });
        }

        @Override
        public void deactivateZone(long zoneId) {
            this.updates.add(() -> {
                if (this.activeZones.remove(zoneId)) {
                    this.added.remove(zoneId);
                    this.removed.add(zoneId);
                }
            });
        }
    }
}

