/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.ethereal.io;

import com.simsilica.ethereal.io.BitInputStream;
import com.simsilica.ethereal.io.BitOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Random;

public class BitStreamTester {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        Random rand = new Random(1L);
        int count = 1000;
        int[] bits = new int[count];
        long[] values = new long[count];
        int totalBits = 0;
        for (int i = 0; i < count; ++i) {
            int size;
            bits[i] = size = rand.nextInt(63) + 1;
            totalBits += size;
            long mask = -1L >>> 64 - size;
            long value = rand.nextLong();
            value &= mask;
            values[i] = value &= Long.MAX_VALUE;
        }
        System.out.println("Writing " + count + " values as " + totalBits + " bits... ~" + totalBits / 8 + " bytes.");
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (BitOutputStream out = new BitOutputStream(bOut);){
            for (int i = 0; i < count; ++i) {
                out.writeLongBits(values[i], bits[i]);
            }
        }
        byte[] raw = bOut.toByteArray();
        System.out.println("Array size:" + raw.length);
        long[] readValues = new long[count];
        ByteArrayInputStream bIn = new ByteArrayInputStream(raw);
        BitInputStream in = new BitInputStream(bIn);
        for (int i = 0; i < count; ++i) {
            readValues[i] = in.readLongBits(bits[i]);
        }
        boolean good = true;
        for (int i = 0; i < count; ++i) {
            if (readValues[i] == values[i]) continue;
            System.out.println("Index " + i + " differs, read:" + readValues[i] + " wrote:" + values[i] + " size:" + bits[i]);
            good = false;
            break;
        }
        if (good) {
            System.out.println("Input matches written data.");
        }
    }
}

