/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.lemur.demo;

import com.jme3.app.Application;
import com.jme3.app.BasicProfilerState;
import com.jme3.app.DebugKeysAppState;
import com.jme3.app.SimpleApplication;
import com.jme3.app.StatsAppState;
import com.jme3.app.state.AppState;
import com.jme3.app.state.ScreenshotAppState;
import com.jme3.math.Vector3f;
import com.jme3.scene.Node;
import com.jme3.scene.Spatial;
import com.simsilica.lemur.Action;
import com.simsilica.lemur.ActionButton;
import com.simsilica.lemur.Axis;
import com.simsilica.lemur.Button;
import com.simsilica.lemur.ColorChooser;
import com.simsilica.lemur.Container;
import com.simsilica.lemur.FillMode;
import com.simsilica.lemur.GuiGlobals;
import com.simsilica.lemur.Label;
import com.simsilica.lemur.ListBox;
import com.simsilica.lemur.OptionPanelState;
import com.simsilica.lemur.component.SpringGridLayout;
import com.simsilica.lemur.core.GuiLayout;
import com.simsilica.lemur.core.VersionedList;
import com.simsilica.lemur.style.BaseStyles;
import com.simsilica.lemur.style.ElementId;

public class ProtoDemo
extends SimpleApplication {
    private ListBox<String> listBox;
    private VersionedList<String> testList = new VersionedList();

    public static void main(String ... args) {
        ProtoDemo main = new ProtoDemo();
        main.start();
    }

    public ProtoDemo() {
        super(new AppState[]{new StatsAppState(), new DebugKeysAppState(), new BasicProfilerState(false), new OptionPanelState("glass"), new ScreenshotAppState("", System.currentTimeMillis())});
    }

    public void simpleInitApp() {
        GuiGlobals.initialize((Application)this);
        BaseStyles.loadGlassStyle();
        Container window = new Container("glass");
        window.addChild((Node)new Label("Test List", new ElementId("title"), "glass"), new Object[0]);
        for (int i = 0; i < 10; ++i) {
            this.testList.add("Item " + (i + 1));
        }
        this.listBox = new ListBox<String>(this.testList, "glass");
        window.addChild(this.listBox, new Object[0]);
        Action add = new Action("Add"){

            @Override
            public void execute(Button b) {
                ProtoDemo.this.testList.add("New Item " + (ProtoDemo.this.testList.size() + 1));
            }
        };
        final Action delete = new Action("Delete"){

            @Override
            public void execute(Button b) {
                Integer selected = ProtoDemo.this.listBox.getSelectionModel().getSelection();
                if (selected != null && selected < ProtoDemo.this.testList.size()) {
                    ProtoDemo.this.testList.remove(selected);
                }
            }
        };
        final Action cancel = new Action("Cancel"){

            @Override
            public void execute(Button b) {
            }
        };
        Action safeDelete = new Action("Safe Delete"){

            @Override
            public void execute(Button b) {
                Integer selected = ProtoDemo.this.listBox.getSelectionModel().getSelection();
                if (selected == null || selected >= ProtoDemo.this.testList.size()) {
                    return;
                }
                String val = (String)ProtoDemo.this.testList.get(selected);
                OptionPanelState ops = (OptionPanelState)ProtoDemo.this.stateManager.getState(OptionPanelState.class);
                ops.show("Delete", "Really delete '" + val + "'?", delete, cancel);
            }
        };
        Container buttons = new Container((GuiLayout)new SpringGridLayout(Axis.X, Axis.Y, FillMode.Even, FillMode.Even));
        window.addChild((Node)buttons, new Object[0]);
        buttons.addChild((Node)new ActionButton(add, "glass"), new Object[0]);
        buttons.addChild((Node)new ActionButton(safeDelete, "glass"), new Object[0]);
        buttons.addChild((Node)new ActionButton(delete, "glass"), new Object[0]);
        window.setLocalTranslation(300.0f, 600.0f, 0.0f);
        this.guiNode.attachChild((Spatial)window);
        window = new Container("glass");
        window.addChild((Node)new Label("Test Color Chooser", new ElementId("title"), "glass"), new Object[0]);
        ColorChooser colors = (ColorChooser)window.addChild((Node)new ColorChooser("glass"), new Object[0]);
        colors.setPreferredSize(new Vector3f(300.0f, 90.0f, 0.0f));
        window.setLocalTranslation(100.0f, 400.0f, 0.0f);
        this.guiNode.attachChild((Spatial)window);
    }
}

