/*
 * Decompiled with CFR 0.152.
 */
package com.simsilica.sim;

import com.simsilica.sim.LoopSleepStrategy;
import java.util.concurrent.locks.LockSupport;

public class NanoLoopSleepStrategy
implements LoopSleepStrategy {
    private long updateRate;
    private long expectedOverheadNanos = 100000L;

    public NanoLoopSleepStrategy() {
    }

    public NanoLoopSleepStrategy(long updateRateNanos) {
        this.updateRate = updateRateNanos;
    }

    @Override
    public void setUpdateRateNanos(long updateRate) {
        this.updateRate = updateRate;
    }

    @Override
    public long getUpdateRateNanos() {
        return this.updateRate;
    }

    public void setExpectedOsOverheadNanos(long expectedOverheadNanos) {
        this.expectedOverheadNanos = expectedOverheadNanos;
    }

    public long getExpectedOverheadNanos() {
        return this.expectedOverheadNanos;
    }

    @Override
    public void loopSleep(long currentFrameTime, long pollDelta, long lastUpdateTime, long systemUpdateLength) throws InterruptedException {
        long delta;
        long nextFrameTime = lastUpdateTime + this.updateRate;
        long currentTime = currentFrameTime;
        if (lastUpdateTime == currentFrameTime) {
            currentTime += systemUpdateLength;
        }
        if ((delta = nextFrameTime - currentTime - this.expectedOverheadNanos) > 0L) {
            LockSupport.parkNanos(delta);
        }
    }
}

