/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.opencl.lwjgl;

import com.jme3.opencl.Buffer;
import com.jme3.opencl.CommandQueue;
import com.jme3.opencl.Event;
import com.jme3.opencl.Image;
import com.jme3.opencl.MappingAccess;
import com.jme3.opencl.MemoryAccess;
import com.jme3.opencl.OpenCLObject;
import com.jme3.opencl.lwjgl.LwjglCommandQueue;
import com.jme3.opencl.lwjgl.LwjglEvent;
import com.jme3.opencl.lwjgl.LwjglImage;
import com.jme3.opencl.lwjgl.Utils;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL10GL;
import org.lwjgl.opencl.CL12;
import org.lwjgl.opencl.CLCommandQueue;
import org.lwjgl.opencl.CLEvent;
import org.lwjgl.opencl.CLMem;

public class LwjglBuffer
extends Buffer {
    private final CLMem buffer;

    public LwjglBuffer(CLMem buffer) {
        super((OpenCLObject.ObjectReleaser)new ReleaserImpl(buffer));
        this.buffer = buffer;
    }

    public CLMem getBuffer() {
        return this.buffer;
    }

    public long getSize() {
        return this.buffer.getInfoSize(4354);
    }

    public MemoryAccess getMemoryAccessFlags() {
        return Utils.getMemoryAccessFromFlag(this.buffer.getInfoLong(4353));
    }

    public void read(CommandQueue queue, ByteBuffer dest, long size, long offset) {
        dest.limit((int)((long)dest.position() + size));
        int ret = CL10.clEnqueueReadBuffer((CLCommandQueue)((LwjglCommandQueue)queue).getQueue(), (CLMem)this.buffer, (int)1, (long)offset, (ByteBuffer)dest, null, null);
        Utils.checkError(ret, "clEnqueueReadBuffer");
    }

    public Event readAsync(CommandQueue queue, ByteBuffer dest, long size, long offset) {
        dest.limit((int)((long)dest.position() + size));
        Utils.pointerBuffers[0].rewind();
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueReadBuffer((CLCommandQueue)q, (CLMem)this.buffer, (int)0, (long)offset, (ByteBuffer)dest, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueReadBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(q.getCLEvent(event));
    }

    public void write(CommandQueue queue, ByteBuffer src, long size, long offset) {
        src.limit((int)((long)src.position() + size));
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueWriteBuffer((CLCommandQueue)q, (CLMem)this.buffer, (int)1, (long)offset, (ByteBuffer)src, null, null);
        Utils.checkError(ret, "clEnqueueWriteBuffer");
    }

    public Event writeAsync(CommandQueue queue, ByteBuffer src, long size, long offset) {
        src.limit((int)((long)src.position() + size));
        Utils.pointerBuffers[0].rewind();
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueWriteBuffer((CLCommandQueue)q, (CLMem)this.buffer, (int)0, (long)offset, (ByteBuffer)src, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueWriteBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(q.getCLEvent(event));
    }

    public void copyTo(CommandQueue queue, Buffer dest, long size, long srcOffset, long destOffset) {
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clEnqueueCopyBuffer((CLCommandQueue)q, (CLMem)this.buffer, (CLMem)((LwjglBuffer)dest).buffer, (long)srcOffset, (long)destOffset, (long)size, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        ret = CL10.clWaitForEvents((CLEvent)q.getCLEvent(event));
        Utils.checkError(ret, "clWaitForEvents");
    }

    public Event copyToAsync(CommandQueue queue, Buffer dest, long size, long srcOffset, long destOffset) {
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clEnqueueCopyBuffer((CLCommandQueue)q, (CLMem)this.buffer, (CLMem)((LwjglBuffer)dest).buffer, (long)srcOffset, (long)destOffset, (long)size, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(q.getCLEvent(event));
    }

    public ByteBuffer map(CommandQueue queue, long size, long offset, MappingAccess access) {
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        long flags = Utils.getMappingAccessFlags(access);
        Utils.errorBuffer.rewind();
        ByteBuffer b = CL10.clEnqueueMapBuffer((CLCommandQueue)q, (CLMem)this.buffer, (int)1, (long)flags, (long)offset, (long)size, null, null, (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clEnqueueMapBuffer");
        return b;
    }

    public void unmap(CommandQueue queue, ByteBuffer ptr) {
        ptr.position(0);
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        Utils.pointerBuffers[0].rewind();
        int ret = CL10.clEnqueueUnmapMemObject((CLCommandQueue)q, (CLMem)this.buffer, (ByteBuffer)ptr, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueUnmapMemObject");
        long event = Utils.pointerBuffers[0].get(0);
        ret = CL10.clWaitForEvents((CLEvent)q.getCLEvent(event));
        Utils.checkError(ret, "clWaitForEvents");
    }

    public Buffer.AsyncMapping mapAsync(CommandQueue queue, long size, long offset, MappingAccess access) {
        Utils.pointerBuffers[0].rewind();
        Utils.errorBuffer.rewind();
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        long flags = Utils.getMappingAccessFlags(access);
        ByteBuffer buf = CL10.clEnqueueMapBuffer((CLCommandQueue)q, (CLMem)this.buffer, (int)0, (long)flags, (long)offset, (long)size, null, (PointerBuffer)Utils.pointerBuffers[0], (IntBuffer)Utils.errorBuffer);
        Utils.checkError(Utils.errorBuffer, "clEnqueueMapBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new Buffer.AsyncMapping((Event)new LwjglEvent(q.getCLEvent(event)), buf);
    }

    public Event fillAsync(CommandQueue queue, ByteBuffer pattern, long size, long offset) {
        Utils.pointerBuffers[0].rewind();
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL12.clEnqueueFillBuffer((CLCommandQueue)q, (CLMem)this.buffer, (ByteBuffer)pattern, (long)offset, (long)size, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueFillBuffer");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(q.getCLEvent(event));
    }

    public Event copyToImageAsync(CommandQueue queue, Image dest, long srcOffset, long[] destOrigin, long[] destRegion) {
        if (destOrigin.length != 3 || destRegion.length != 3) {
            throw new IllegalArgumentException("origin and region must both be arrays of length 3");
        }
        Utils.pointerBuffers[0].rewind();
        Utils.pointerBuffers[1].rewind();
        Utils.pointerBuffers[2].rewind();
        Utils.pointerBuffers[1].put(destOrigin).position(0);
        Utils.pointerBuffers[2].put(destRegion).position(0);
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10.clEnqueueCopyBufferToImage((CLCommandQueue)q, (CLMem)this.buffer, (CLMem)((LwjglImage)dest).getImage(), (long)srcOffset, (PointerBuffer)Utils.pointerBuffers[1], (PointerBuffer)Utils.pointerBuffers[2], null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueCopyBufferToImage");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(q.getCLEvent(event));
    }

    public Event acquireBufferForSharingAsync(CommandQueue queue) {
        Utils.pointerBuffers[0].rewind();
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueAcquireGLObjects((CLCommandQueue)q, (CLMem)this.buffer, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueAcquireGLObjects");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(q.getCLEvent(event));
    }

    public void acquireBufferForSharingNoEvent(CommandQueue queue) {
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueAcquireGLObjects((CLCommandQueue)q, (CLMem)this.buffer, null, null);
        Utils.checkError(ret, "clEnqueueAcquireGLObjects");
    }

    public Event releaseBufferForSharingAsync(CommandQueue queue) {
        Utils.pointerBuffers[0].rewind();
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueReleaseGLObjects((CLCommandQueue)q, (CLMem)this.buffer, null, (PointerBuffer)Utils.pointerBuffers[0]);
        Utils.checkError(ret, "clEnqueueReleaseGLObjects");
        long event = Utils.pointerBuffers[0].get(0);
        return new LwjglEvent(q.getCLEvent(event));
    }

    public void releaseBufferForSharingNoEvent(CommandQueue queue) {
        CLCommandQueue q = ((LwjglCommandQueue)queue).getQueue();
        int ret = CL10GL.clEnqueueReleaseGLObjects((CLCommandQueue)q, (CLMem)this.buffer, null, null);
        Utils.checkError(ret, "clEnqueueReleaseGLObjects");
    }

    private static class ReleaserImpl
    implements OpenCLObject.ObjectReleaser {
        private CLMem mem;

        private ReleaserImpl(CLMem mem) {
            this.mem = mem;
        }

        public void release() {
            if (this.mem != null) {
                int ret = CL10.clReleaseMemObject((CLMem)this.mem);
                this.mem = null;
                Utils.reportError(ret, "clReleaseMemObject");
            }
        }
    }
}

